/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.HtmlParser;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.BodyFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.BreadCrumbFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.H1FragmentHandler;
import com.mathworks.helpsearch.index.doccenter.H2FragmentHandler;
import com.mathworks.helpsearch.index.doccenter.LinkFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.SyntaxFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.TitleFragmentHandler;
import com.mathworks.helpsearch.index.doccenter.TitleTagFragmentHandler;
import com.mathworks.helpsearch.index.shared.DescriptionFragmentHandler;
import com.mathworks.helpsearch.index.shared.RefEntityFragmentHandler;
import com.mathworks.helpsearch.product.DocSetItem;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;

public class DocCenterHtmlParserFactory
implements HtmlParserFactory {
    private final DocSetItem fDocSetItem;

    public DocCenterHtmlParserFactory(DocSetItem docSetItem) {
        this.fDocSetItem = docSetItem;
    }

    @Override
    public HtmlParser createParserForDocument(Document doc, String relPath) {
        List<XmlFragmentHandler> handlers = this.createHandlers(relPath);
        return new HtmlParser(doc, handlers);
    }

    private List<XmlFragmentHandler> createHandlers(String relPath) {
        ArrayList<XmlFragmentHandler> handlers = new ArrayList<XmlFragmentHandler>();
        handlers.add(new RefEntityFragmentHandler());
        handlers.add(new TitleFragmentHandler());
        handlers.add(new DescriptionFragmentHandler());
        handlers.add(new BreadCrumbFragmentHandler(this.fDocSetItem, relPath));
        handlers.add(new BodyFragmentHandler());
        handlers.add(new LinkFragmentHandler());
        handlers.add(new SyntaxFragmentHandler());
        handlers.add(new TitleTagFragmentHandler());
        handlers.add(new H1FragmentHandler());
        handlers.add(new H2FragmentHandler());
        return handlers;
    }
}

