/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import java.util.LinkedList;
import java.util.List;

public class SyntaxFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private final List<String> fSyntaxLines = new LinkedList<String>();
    private StringBuilder fCurrentLine;

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"p"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        String tagClass = xmlTag.getAttribute("class");
        return tagClass != null && tagClass.matches("\\bsynopsis\\b");
    }

    @Override
    public boolean continueHandling() {
        return true;
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        this.fCurrentLine = new StringBuilder();
        return this;
    }

    @Override
    public void startElement(XmlTagInfo location) {
        if (location.getTagName().equalsIgnoreCase("br")) {
            this.fSyntaxLines.add(this.fCurrentLine.toString());
            this.fCurrentLine = new StringBuilder();
        }
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
        this.fCurrentLine.append(chars);
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public void endFragment(XmlTagInfo location) {
        String lastLine = this.fCurrentLine.toString();
        if (lastLine.trim().length() > 0) {
            this.fSyntaxLines.add(lastLine);
        }
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        List<String> existing = doc.getSyntaxLines();
        if (existing == null || existing.isEmpty()) {
            doc.addSyntaxLines(this.fSyntaxLines);
        }
    }
}

