/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.example;

import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.FileHelpPathBuilder;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.WebHelpPathBuilder;
import com.mathworks.helpsearch.index.example.Example;
import com.mathworks.helpsearch.index.example.ExampleMetadataWriter;
import com.mathworks.helpsearch.product.DocProduct;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlExampleMetadataWriter
implements ExampleMetadataWriter {
    private final File fDocRoot;
    private final DocProduct fProduct;
    private final DocLanguage fDocLanguage;

    public XmlExampleMetadataWriter(File docRoot, DocProduct product, DocLanguage language) {
        this.fDocRoot = docRoot;
        this.fProduct = product;
        this.fDocLanguage = language;
    }

    @Override
    public void createMetadataDocument(Collection<Example> examples) {
        if (this.fDocLanguage == null || this.fDocLanguage == DocLanguage.ENGLISH) {
            try {
                Document xmlDoc = this.getXmlDocument();
                Element rootElement = xmlDoc.createElement("examples");
                xmlDoc.appendChild(rootElement);
                for (Example example : examples) {
                    this.addExample(xmlDoc, rootElement, example);
                }
                this.writeMetadataToFile(xmlDoc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeMetadataToFile(Document xmlDoc) throws TransformerException, UnsupportedEncodingException {
        File helpDir = this.fProduct.getHelpLocation().buildHelpPath(this.fDocRoot, new FileHelpPathBuilder(), new String[0]);
        File xmlFile = new File(helpDir, URLEncoder.encode(this.fProduct.getShortName() + "_examples", "UTF-8") + ".xml");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(xmlDoc);
        StreamResult result = new StreamResult(xmlFile);
        transformer.transform(source, result);
    }

    private void addExample(Document xmlDoc, Element parent, Example example) {
        Element exampleElement = xmlDoc.createElement("example");
        this.addExampleId(xmlDoc, exampleElement, example);
        this.addExampleTitle(xmlDoc, exampleElement, example);
        this.addExampleType(xmlDoc, exampleElement, example);
        this.addExampleDocPageUrl(xmlDoc, exampleElement, example);
        this.addExampleCategory(xmlDoc, exampleElement, example);
        this.addExampleProductBaseCode(xmlDoc, exampleElement, example);
        this.addExampleProductLocation(xmlDoc, exampleElement, example);
        this.addFields(xmlDoc, exampleElement, "language", this.fProduct.getDocSet().getLanguage().getDirectory());
        parent.appendChild(exampleElement);
    }

    private void addExampleProductLocation(Document xmlDoc, Element parent, Example example) {
        this.addFields(xmlDoc, parent, "producthelplocation", this.buildRelativeHelpUrl());
    }

    private String buildRelativeHelpUrl() {
        String helpLoc = this.fProduct.getHelpLocation().buildHelpPath("", new WebHelpPathBuilder(), new String[0]);
        if (helpLoc.startsWith("/")) {
            return helpLoc.substring(1);
        }
        return helpLoc;
    }

    private void addFields(Document xmlDoc, Element parent, String field, String value) {
        Element fieldElement = xmlDoc.createElement(field);
        fieldElement.appendChild(xmlDoc.createTextNode(value));
        parent.appendChild(fieldElement);
    }

    private void addExampleProductBaseCode(Document xmlDoc, Element parent, Example example) {
        this.addFields(xmlDoc, parent, "product", this.fProduct.getShortName());
    }

    private void addExampleCategory(Document xmlDoc, Element parent, Example example) {
        ResultCategory topLevelCategory = example.getResultCategory();
        if (topLevelCategory != null) {
            this.addFields(xmlDoc, parent, "categoryid", topLevelCategory.getNodeId());
            this.addFields(xmlDoc, parent, "categorylabel", topLevelCategory.getLabel());
        }
    }

    private void addExampleDocPageUrl(Document xmlDoc, Element parent, Example example) {
        this.addFields(xmlDoc, parent, "docpageurl", example.getDocPageUrl());
    }

    private void addExampleType(Document xmlDoc, Element parent, Example example) {
        Element exampleType = xmlDoc.createElement("type");
        exampleType.appendChild(xmlDoc.createTextNode(example.getType().getType()));
        parent.appendChild(exampleType);
    }

    private void addExampleTitle(Document xmlDoc, Element parent, Example example) {
        String title = example.getTitle();
        if (title != null) {
            this.addFields(xmlDoc, parent, "title", example.getTitle());
        }
    }

    private void addExampleId(Document xmlDoc, Element parent, Example example) {
        this.addFields(xmlDoc, parent, "id", example.getId());
    }

    private Document getXmlDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }
}

