/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.CompoundSearchExpression;
import com.mathworks.search.PartialWordSearchExpression;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SimpleSearchExpression;
import java.util.ArrayList;
import java.util.Collection;

public class ProductSearchExpression
extends CompoundSearchExpression {
    private final String fProductShortName;
    private final boolean fIncludeAddOns;

    public ProductSearchExpression(String productShortName, boolean includeAddOns) {
        super(ProductSearchExpression.buildSearchExpressions(productShortName, includeAddOns));
        this.setBooleanOperator(BooleanSearchOperator.MUST_OCCUR);
        this.fProductShortName = productShortName;
        this.fIncludeAddOns = includeAddOns;
    }

    private static Collection<SearchExpression> buildSearchExpressions(String shortName, boolean includeAddOns) {
        ArrayList<SearchExpression> exprs = new ArrayList<SearchExpression>(includeAddOns ? 2 : 1);
        SimpleSearchExpression prodExpr = new SimpleSearchExpression(shortName, BooleanSearchOperator.SHOULD_OCCUR);
        prodExpr.addSearchField((SearchField)DocumentationSearchField.PRODUCT);
        exprs.add((SearchExpression)prodExpr);
        if (includeAddOns) {
            PartialWordSearchExpression addOnExpr = new PartialWordSearchExpression(shortName + "::", BooleanSearchOperator.SHOULD_OCCUR);
            addOnExpr.addSearchField((SearchField)DocumentationSearchField.PRODUCT);
            exprs.add((SearchExpression)addOnExpr);
        }
        return exprs;
    }

    public int hashCode() {
        return this.fProductShortName.hashCode() + (this.fIncludeAddOns ? 13 : 17);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProductSearchExpression) {
            ProductSearchExpression otherExpr = (ProductSearchExpression)((Object)obj);
            return otherExpr.fProductShortName.equals(this.fProductShortName) && otherExpr.fIncludeAddOns == this.fIncludeAddOns;
        }
        return false;
    }
}

