/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.reference.map;

import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import com.mathworks.helpsearch.reference.map.ReferenceMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class ReferenceEntityNode {
    private final SortedSet<ReferenceMapping> fMappings = new TreeSet<ReferenceMapping>();
    private Map<String, ReferenceEntityNode> fSimpleChildren = new HashMap<String, ReferenceEntityNode>();
    private ReferenceEntityNode fWildcardNode = null;

    public List<ReferenceEntity> getReferenceEntities(String path) {
        return this.getReferenceEntities(path, null);
    }

    private List<ReferenceEntity> getReferenceEntities(String path, RefEntityType type) {
        String[] parts = path.split("\\.");
        List<ReferenceEntityNode> nodes = this.findNodesByPath(Arrays.asList(parts));
        if (nodes.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ReferenceEntity> entities = new LinkedList<ReferenceEntity>();
        for (ReferenceEntityNode node : nodes) {
            entities.addAll(node.getEntitiesForType(path, type));
        }
        return entities;
    }

    private List<ReferenceEntityNode> findNodesByPath(List<String> pathParts) {
        if (pathParts.isEmpty()) {
            return Arrays.asList(this);
        }
        LinkedList<ReferenceEntityNode> foundNodes = new LinkedList<ReferenceEntityNode>();
        String currentPart = pathParts.get(0);
        List<String> remainingParts = pathParts.subList(1, pathParts.size());
        List<ReferenceEntityNode> children = this.getChildren(currentPart);
        for (ReferenceEntityNode child : children) {
            foundNodes.addAll(child.findNodesByPath(remainingParts));
        }
        return foundNodes;
    }

    private List<ReferenceEntityNode> getChildren(String name) {
        LinkedList<ReferenceEntityNode> children = new LinkedList<ReferenceEntityNode>();
        ReferenceEntityNode simple = this.getSimpleChild(name);
        if (simple != null) {
            children.add(simple);
        }
        if (this.fWildcardNode != null) {
            children.add(this.fWildcardNode);
        }
        return children;
    }

    private ReferenceEntityNode getSimpleChild(String name) {
        return this.fSimpleChildren.get(name.toLowerCase(Locale.ENGLISH));
    }

    private List<ReferenceEntity> getEntitiesForType(String path, RefEntityType type) {
        String[] pathParts = path.split("\\.");
        ArrayList<ReferenceEntity> mappedEntities = new ArrayList<ReferenceEntity>(this.fMappings.size());
        for (ReferenceMapping mapping : this.fMappings) {
            ReferenceEntity entity = mapping.mapSourceEntity(pathParts, type);
            if (entity == null) continue;
            mappedEntities.add(entity);
        }
        return mappedEntities;
    }

    public void add(String srcPattern, String destPattern, RefEntityType destType) {
        ReferenceMapping mapping = new ReferenceMapping(srcPattern, destPattern, destType);
        this.add(srcPattern, mapping);
    }

    private void add(String srcPattern, ReferenceMapping mapping) {
        String[] path = srcPattern.split("\\.");
        ReferenceEntityNode currentNode = this;
        for (String pathPart : path) {
            currentNode = currentNode.getChildForAdd(pathPart);
        }
        currentNode.addMapping(mapping);
    }

    private void addMapping(ReferenceMapping mapping) {
        this.fMappings.add(mapping);
    }

    private ReferenceEntityNode getChildForAdd(String name) {
        if (ReferenceEntityNode.isWildcardName(name)) {
            if (this.fWildcardNode == null) {
                this.fWildcardNode = new ReferenceEntityNode();
            }
            return this.fWildcardNode;
        }
        return ReferenceEntityNode.getChildForAdd(name.toLowerCase(Locale.ENGLISH), this.fSimpleChildren);
    }

    private static <T> ReferenceEntityNode getChildForAdd(T name, Map<T, ReferenceEntityNode> nodeMap) {
        if (nodeMap.containsKey(name)) {
            return nodeMap.get(name);
        }
        ReferenceEntityNode newNode = new ReferenceEntityNode();
        nodeMap.put(name, newNode);
        return newNode;
    }

    private static boolean isWildcardName(String name) {
        return name.startsWith("[") && name.endsWith("]");
    }
}

