/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.suggestion;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocSetItemResolver;
import com.mathworks.helpsearch.suggestion.PageSuggestion;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.TextHighlighter;
import java.util.Collection;

public class PageSuggestionAdapter
implements SearchResultAdapter<PageSuggestion> {
    static final int MAX_LENGTH = 70;
    private final DocSetItemResolver fProdResolver;
    private final TextHighlighter fHighlighter;

    public PageSuggestionAdapter(DocSetItemResolver prodResolver, Collection<String> keywords) {
        this.fProdResolver = prodResolver;
        this.fHighlighter = this.createHighlighter(keywords);
    }

    private TextHighlighter createHighlighter(Collection<String> keywords) {
        if (keywords == null || keywords.isEmpty()) {
            return null;
        }
        return new TextHighlighter(TextHighlighter.HighlightRule.PREFIX, keywords);
    }

    public PageSuggestion adaptResult(SearchResult result) {
        String prodName = result.getFieldValue(DocumentationSearchField.PRODUCT.getFieldName());
        DocSetItem prod = this.fProdResolver.getDocSetItemByIndexString(prodName);
        String title = result.getFieldValue(DocumentationSearchField.TITLE_DISPLAY.getFieldName());
        String h1 = result.getFieldValue(DocumentationSearchField.SUMMARY.getFieldName());
        String loc = result.getFieldValue(DocumentationSearchField.RELATIVE_PATH.getFieldName());
        return new PageSuggestion(prod, title, h1, loc, this.fHighlighter);
    }
}

