/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm.exec;

import com.mathworks.mvm.exec.MatlabStackTraceElement;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MvmException
extends Exception {
    private static final MatlabStackTraceElement[] EMPTY = new MatlabStackTraceElement[0];
    private final MatlabStackTraceElement[] fElements;
    private final String fID;
    private final String fFunctionName;
    private static final long serialVersionUID = 1L;

    MvmException(String string, String string2, MatlabStackTraceElement[] matlabStackTraceElementArray, @Nullable String string3) {
        super(string);
        this.fElements = matlabStackTraceElementArray == null ? EMPTY : matlabStackTraceElementArray;
        this.fID = string2;
        this.fFunctionName = string3;
    }

    MvmException(String string, String string2, MatlabStackTraceElement[] matlabStackTraceElementArray) {
        this(string, string2, matlabStackTraceElementArray, null);
    }

    private MvmException(String string) {
        this(string, "dummy:id", new MatlabStackTraceElement[]{new MatlabStackTraceElement("foo", "bar", 5)}, "dummy");
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[this.fElements.length];
        int n = 0;
        for (MatlabStackTraceElement matlabStackTraceElement : this.fElements) {
            int n2 = matlabStackTraceElement.fFuncName.indexOf(46);
            String string = matlabStackTraceElement.fFuncName.substring(0, n2 < 0 ? 0 : n2);
            String string2 = matlabStackTraceElement.fFuncName.substring(n2 + 1);
            stackTraceElementArray[n++] = new StackTraceElement(string, string2, matlabStackTraceElement.fFileName, matlabStackTraceElement.fLineNum);
        }
        return stackTraceElementArray;
    }

    private MatlabStackTraceElement[] getMatlabStackTrace() {
        return this.fElements;
    }

    @Nullable
    public String getFunctionName() {
        return this.fFunctionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            for (MatlabStackTraceElement matlabStackTraceElement : this.fElements) {
                printStream.println(matlabStackTraceElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            for (MatlabStackTraceElement matlabStackTraceElement : this.fElements) {
                printWriter.println(matlabStackTraceElement);
            }
        }
    }

    public String getID() {
        return this.fID;
    }

    public int hashCode() {
        return (this.fID != null ? this.fID.hashCode() : 0) + (this.getMessage() != null ? 0 : this.getMessage().hashCode()) + Arrays.hashCode(this.fElements);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof MvmException)) {
            return false;
        }
        MvmException mvmException = (MvmException)object;
        return MvmException.equ(this.fID, mvmException.getID()) && MvmException.equ(this.getMessage(), mvmException.getMessage()) && Arrays.equals(this.fElements, mvmException.getMatlabStackTrace());
    }

    private static boolean equ(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }
}

