/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.ide.arrayeditor;

import com.mathworks.ide.arrayeditor.ArrayView;
import com.mathworks.ide.arrayeditor.ArrayViewLooper;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.mwt.table.TableData;
import com.mathworks.mwt.table.TableDataEvent;
import com.mathworks.util.StringUtils;
import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class MatlabVariableData
extends TableData {
    public static final int FORMAT_SHORT = 0;
    public static final int FORMAT_SHORT_E = 1;
    public static final int FORMAT_SHORT_G = 2;
    public static final int FORMAT_LONG = 3;
    public static final int FORMAT_LONG_E = 4;
    public static final int FORMAT_LONG_G = 5;
    public static final int FORMAT_HEX = 6;
    public static final int FORMAT_BANK = 7;
    public static final int FORMAT_PLUS = 8;
    public static final int FORMAT_RATIONAL = 9;
    public static final int NUM_FORMATS = 10;
    public static final String GOTDATA_COMPLETED = "DataBoundsChangedCompleted";
    protected static final int STATUS_INIT = 0;
    protected static final int STATUS_OK = 1;
    protected static final int STATUS_NONEXISTENT = 2;
    protected static final int STATUS_UNSUPPORTED = 3;
    protected static final int STATUS_TOO_LARGE = 4;
    protected static final int STATUS_OUT_OF_SCOPE = 5;
    protected static final int STATUS_ERROR = 6;
    protected static final int STATUS_EMPTY = 7;
    protected static final int STATUS_NOT_2D = 8;
    protected static final int STATUS_NO_VARIABLE = 9;
    protected static final String[] SUPPORTED_FORMATS = new String[]{"short", "shorte", "shortg", "long", "longE", "longG", "hex", "bank", "+", "rational"};
    protected static final int MAX_ELEMENTS = 65536;
    private static final int NO_INDEX = -1;
    private static final String NEWLINE = System.getProperty("line.separator");
    private String fName;
    private volatile MLArrayRef fRef;
    private MLArrayRef fPendingRef;
    private int fFormat;
    private int fType;
    private int fWidth;
    private int fHeight;
    private int fVarWidth;
    private int fVarHeight;
    private int fOldVarWidth;
    private int fOldVarHeight;
    private boolean fFactorFixed = false;
    private String fFactor;
    private String[] fData;
    private String fStack;
    private String fCurStack;
    private int fStatus;
    private ActionListener fActionListener;

    public MatlabVariableData(String string) {
        this.fName = string;
        this.fPendingRef = null;
        this.fRef = null;
        this.fFormat = 2;
        this.initialize();
    }

    public MatlabVariableData(MLArrayRef mLArrayRef) {
        this.fPendingRef = mLArrayRef;
        this.fRef = null;
        this.fName = null;
        this.fFormat = 2;
        this.initialize();
    }

    private void initialize() {
        this.fType = this.fRef == null ? 0 : this.fRef.getType();
        this.fWidth = 0;
        this.fHeight = 0;
        this.fVarWidth = 0;
        this.fVarHeight = 0;
        this.fFactor = "";
        this.fData = null;
        this.fStack = null;
        this.fCurStack = null;
        this.fStatus = 0;
    }

    protected void registerInterests() {
        ArrayViewLooper.register(this);
        this.refresh();
    }

    protected void unregisterInterests() {
        ArrayViewLooper.unregister(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    protected void fireActionEvent(String string) {
        if (this.fActionListener != null) {
            ActionEvent actionEvent = new ActionEvent((Object)this, 1001, string);
            this.fActionListener.actionPerformed(actionEvent);
        }
    }

    public int getType() {
        return this.fType;
    }

    public String getVariableName() {
        return this.fName != null ? this.fName : "";
    }

    public void setVariableName(String string) {
        this.fName = string != null && string.equals("") ? null : string;
        if (this.fRef != null) {
            this.fRef.dispose();
            this.fRef = null;
        }
        this.initialize();
        this.refresh();
    }

    public MLArrayRef getVariableRef() {
        return this.fRef;
    }

    public void setVariableRef(MLArrayRef mLArrayRef) {
        this.fName = null;
        if (this.fRef != null) {
            this.fRef.dispose();
        }
        this.fPendingRef = mLArrayRef;
        this.fRef = null;
        this.initialize();
        this.refresh();
    }

    public int getFormat() {
        return this.fFormat;
    }

    public void setFormat(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.fFormat = n;
                this.refresh();
            }
        }
    }

    public String getFactor() {
        return this.fFactor;
    }

    public String getStack() {
        return this.fStack;
    }

    public String getCurrentStack() {
        return this.fCurStack;
    }

    protected int getStringSize() {
        int n;
        int n2 = n = this.fType == 1 ? 15 : 8;
        if (this.fData != null) {
            for (int i = 0; i < this.fData.length; ++i) {
                if (this.fData[i] == null || this.fData[i].length() + 1 <= n) continue;
                n = this.fData[i].length() + 1;
            }
        }
        return n;
    }

    protected int getStatus() {
        return this.fStatus;
    }

    public Object getData(int n, int n2) {
        int n3 = this.getIndex(n, n2);
        String string = null;
        if (n3 != -1 && this.fData != null && n3 < this.fData.length) {
            string = this.fData[n3];
        }
        return string;
    }

    public void setData(int n, int n2, Object object) {
        this.setData(n, n2, object, null);
    }

    public void setData(int n, int n2, Object object, ArrayView arrayView) {
        String string = null;
        if (object instanceof String) {
            if (this.fName != null) {
                switch (this.fType) {
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        string = this.fName + "(" + (n + 1) + "," + (n2 + 1) + ") = " + object + ";";
                        break;
                    }
                    case 1: {
                        string = this.fName + "{" + (n + 1) + "," + (n2 + 1) + "} = '" + StringUtils.quoteSingleQuotes((String)((String)object)) + "';";
                        break;
                    }
                    case 4: {
                        string = this.fName + " = '" + StringUtils.quoteSingleQuotes((String)((String)object)) + "';";
                    }
                }
                if (string != null) {
                    ArrayViewLooper.eval(string, arrayView.getFrame());
                }
            } else if (this.fRef != null) {
                double[] dArray = new double[]{n + 1};
                double[] dArray2 = new double[]{n2 + 1};
                Object[] objectArray = new Object[]{dArray, dArray2};
                ArrayViewLooper.setValue(this.fRef, objectArray, (String)object, this, arrayView.getFrame());
            }
        }
    }

    public void setPort(Object object, int n, int n2, int n3, int n4) {
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setWidth(int n) {
    }

    protected int getVarWidth() {
        return this.fVarWidth;
    }

    protected void setVarWidth(int n, ArrayView arrayView) {
        if (this.fName != null) {
            String string = null;
            String string2 = null;
            switch (this.fType) {
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "0";
                    break;
                }
                case 1: {
                    string2 = "{''}";
                    break;
                }
            }
            if (string2 != null) {
                if (n > this.fVarWidth) {
                    string = this.fName + "(:,end+1:" + n + ") = " + string2 + ";";
                } else if (n < this.fVarWidth) {
                    string = this.fName + "(:," + n + "+1:end) = [];";
                }
            }
            if (string != null) {
                this.fVarWidth = n;
                ArrayViewLooper.eval(string, null);
                this.fWidth = n;
                this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            }
        } else if (this.fRef != null) {
            ArrayViewLooper.setVarWidth(this.fRef, n, this, arrayView.getFrame());
        }
    }

    public int getHeight() {
        return this.fHeight;
    }

    public void setHeight(int n) {
    }

    protected int getVarHeight() {
        return this.fVarHeight;
    }

    protected void setVarHeight(int n, ArrayView arrayView) {
        if (this.fName != null) {
            String string = null;
            String string2 = null;
            switch (this.fType) {
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "0";
                    break;
                }
                case 1: {
                    string2 = "{''}";
                    break;
                }
            }
            if (string2 != null) {
                if (n > this.fVarHeight) {
                    string = this.fName + "(end+1:" + n + ",:) = " + string2 + ";";
                } else if (n < this.fVarHeight) {
                    string = this.fName + "(" + n + "+1:end,:) = [];";
                }
            }
            if (string != null) {
                this.fVarHeight = n;
                ArrayViewLooper.eval(string, null);
                this.fHeight = n;
                this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            }
        } else if (this.fRef != null) {
            ArrayViewLooper.setVarHeight(this.fRef, n, this, arrayView.getFrame());
        }
    }

    public void addRows(int n, int n2) {
    }

    public void addColumns(int n, int n2) {
    }

    public void removeRows(int n, int n2) {
    }

    public void removeColumns(int n, int n2) {
    }

    protected void gotStack(String string, boolean bl) {
        if (bl) {
            this.fStack = string;
        }
        this.fCurStack = string;
        if (!this.fCurStack.equals(this.fStack)) {
            this.badStatus(5);
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        } else {
            ArrayViewLooper.getRef(this, this.fName);
        }
    }

    protected void gotSharedDataCopy(MLArrayRef mLArrayRef) {
        this.fPendingRef = null;
        if (mLArrayRef != null) {
            this.fRef = mLArrayRef;
            this.gotRef(this.fRef, true, false);
        } else {
            this.fRef = null;
            this.badStatus(6);
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    protected void gotRef(MLArrayRef mLArrayRef, boolean bl, boolean bl2) {
        boolean bl3 = true;
        this.fOldVarWidth = this.fVarWidth;
        this.fOldVarHeight = this.fVarHeight;
        boolean bl4 = true;
        this.fVarWidth = 0;
        this.fVarHeight = 0;
        if (mLArrayRef != null) {
            this.fType = mLArrayRef.getType();
            this.fVarWidth = mLArrayRef.getN();
            this.fVarHeight = mLArrayRef.getM();
            if (this.fVarHeight == this.fOldVarHeight && this.fVarWidth == this.fOldVarWidth) {
                bl4 = false;
            }
            if (mLArrayRef.isSparse()) {
                this.badStatus(3);
            } else {
                switch (this.fType) {
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (mLArrayRef.getNDimensions() != 2) {
                            this.badStatus(8);
                            break;
                        }
                        int n = mLArrayRef.getM() * mLArrayRef.getN();
                        int n2 = 1;
                        if (n == 0) {
                            n2 = 7;
                        } else if (n > 65536) {
                            n2 = 4;
                        }
                        if (n2 == 1) {
                            this.fStatus = 1;
                            this.fWidth = mLArrayRef.getN();
                            this.fHeight = mLArrayRef.getM();
                            break;
                        }
                        this.badStatus(n2);
                        break;
                    }
                    case 4: {
                        if (mLArrayRef.getNDimensions() != 2) {
                            this.badStatus(8);
                            break;
                        }
                        if (mLArrayRef.getM() != 1) {
                            this.badStatus(3);
                            break;
                        }
                        this.fStatus = 1;
                        this.fWidth = 1;
                        this.fHeight = 1;
                        break;
                    }
                    default: {
                        this.badStatus(3);
                    }
                }
                if (this.fWidth == 0 || this.fHeight == 0) {
                    this.fData = null;
                }
                if (this.fStatus == 1) {
                    ArrayViewLooper.getData(this, mLArrayRef, SUPPORTED_FORMATS[this.fFormat], bl2);
                    bl3 = false;
                } else if (bl2) {
                    mLArrayRef.dispose();
                }
            }
        } else if (bl) {
            this.badStatus(3);
        } else {
            this.badStatus(2);
        }
        if (bl3) {
            if (bl4) {
                this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
            } else {
                this.fireDataEvent(new TableDataEvent(0, 0, this.fWidth, this.fHeight));
            }
        }
    }

    protected void gotData(String string) {
        boolean bl = true;
        if (string != null) {
            int n = this.fWidth * this.fHeight;
            boolean bl2 = bl = this.fWidth != this.fOldVarWidth || this.fHeight != this.fOldVarHeight;
            if (this.fData == null || this.fData.length != n) {
                this.fData = new String[n];
            }
            switch (this.fType) {
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    int n2 = 0;
                    boolean bl3 = true;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
                    while (stringTokenizer.hasMoreTokens() && n2 < this.fData.length) {
                        String string2 = stringTokenizer.nextToken();
                        if (bl3) {
                            if (string2.endsWith("*")) {
                                this.fFactor = string2.trim();
                            } else {
                                this.fFactor = "";
                                this.fData[n2++] = MatlabVariableData.compact(string2);
                            }
                            bl3 = false;
                            continue;
                        }
                        this.fData[n2++] = MatlabVariableData.compact(string2);
                    }
                    break;
                }
                case 1: {
                    this.fFactor = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
                    int n3 = 0;
                    while (stringTokenizer.hasMoreTokens() && n3 < this.fData.length) {
                        String string3 = stringTokenizer.nextToken();
                        this.fData[n3++] = string3.substring(0, string3.length() - 1);
                    }
                    break;
                }
                case 4: {
                    this.fFactor = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string, NEWLINE);
                    if (!stringTokenizer.hasMoreTokens()) break;
                    this.fData[0] = stringTokenizer.nextToken();
                }
            }
        } else if (this.fType == 1) {
            this.badStatus(3);
        } else if (this.fType == 4) {
            this.badStatus(3);
        } else {
            this.badStatus(6);
        }
        if (bl || !this.fFactorFixed) {
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        } else {
            this.fireDataEvent(new TableDataEvent(0, 0, this.fWidth, this.fHeight));
        }
        this.fFactorFixed = true;
        this.fireActionEvent(GOTDATA_COMPLETED);
    }

    protected void gotInterest(int n) {
        if (this.fName != null) {
            switch (n) {
                case -2147483648: {
                    ArrayViewLooper.getStack(this, false);
                    break;
                }
                default: {
                    if (this.fStatus == 5) break;
                    ArrayViewLooper.getRef(this, this.fName);
                }
            }
        }
    }

    private void refresh() {
        if (this.fName != null) {
            ArrayViewLooper.getStack(this, this.fCurStack == null);
        } else if (this.fPendingRef != null) {
            ArrayViewLooper.getSharedDataCopy(this, this.fPendingRef);
        } else if (this.fRef != null) {
            this.gotRef(this.fRef, true, false);
        } else {
            this.badStatus(9);
            this.fireDataEvent(new TableDataEvent(this.fWidth, this.fHeight));
        }
    }

    private static String compact(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = 0;
        String string2 = string;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = n == 0 ? stringTokenizer.nextToken() : string2 + " " + stringTokenizer.nextToken();
            ++n;
        }
        return string2;
    }

    private void badStatus(int n) {
        this.fStatus = n;
        this.fData = null;
        this.fFactor = "";
        this.fWidth = 0;
        this.fHeight = 0;
    }

    private int getIndex(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n < this.fHeight && n2 >= 0 && n2 < this.fWidth) {
            n3 = n2 * this.fHeight + n;
        }
        return n3;
    }
}

