/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BoxList;
import ice.pilots.html4.ButtonBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSCounters;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DRange;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FixedPainter;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.RefreshEvent;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TextBox;
import ice.pilots.html4.TheView;
import ice.storm.DynamicObject;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.JavaVersion;
import ice.util.memory.MemoryManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class CSSLayout
implements EventListener {
    static final boolean forceGC = Defs.sysPropertyBoolean((String)"ice.browser.forcegc");
    int[] breaks = new int[1000];
    static final byte PSEUDO_NONE = 0;
    static final byte PSEUDO_HOVER = 1;
    static final byte PSEUDO_ACTIVE = 2;
    static final byte PSEUDO_FOCUS = 4;
    static final byte PSEUDO_BEFORE = 8;
    static final byte PSEUDO_AFTER = 16;
    private Object layout_lock = new Object();
    StormData sdata;
    protected CSSBox topBox = null;
    DDocument doc;
    protected CSSMatcher matcher;
    DocPaneXml docPane;
    TheView theView;
    protected boolean inPrintMode = false;
    OutlinePainter outlinePainter = new OutlinePainter();
    int mutation = 0;
    private boolean refreshEventComingUp = false;
    boolean hasBeenPurged = false;
    int zoom = 256;
    boolean doImageAnimation = true;
    Hashtable dynamicStyles = new Hashtable();
    private CSSCounters counters = new CSSCounters();
    private Vector resetedCounters = null;
    private CSSBox curParentBox;
    CSSBox pseudoBefore = null;
    CSSBox pseudoAfter = null;
    Hashtable substBoxes = new Hashtable();
    private FloatPainter floatPainter = new FloatPainter();
    private FixedPainter fixedPainter = new FixedPainter();
    BoxList boxList = new BoxList();
    private Hashtable anchors = new Hashtable();
    private String waitForRef = null;
    private int presetScrollX;
    private int presetScrollY;
    CSSBox focusedBox = null;
    private FocusManager focusManager = null;
    private boolean fixedBackgrounds = false;
    DRange selection;
    boolean somethingSelected;
    private boolean cleared = true;
    int maxOutlineWidth = 0;
    private int memoryCheckCounter = 0;
    private boolean printback = true;
    private Point eventPos = new Point();
    private CSSBox prevMoveBox;
    private CSSBox prevDownBox;
    private DNode prevMoveNode;
    private DNode prevDownNode;
    private long pressTimeStamp;
    private int clickCounter;
    private int prevMoveX = -1;
    private int prevMoveY;
    private int prevMoveScrollX;
    private int prevMoveScrollY;
    private Rectangle sel_tmp = new Rectangle();
    private int sel_y1;
    private int sel_y2;
    private Color documentFocusOutlineColor;
    private int documentFocusOutlineWidth;
    private DNode firstDNodeForSelection = null;
    private int firstOffsetForSelection = 0;
    private long prevRefreshEventTime = 0L;
    final long minRefreshDelay = Defs.sysPropertyInt((String)"ice.pilots.html4.refreshDelay", (int)50);
    final long maxRefreshDelay = Defs.sysPropertyInt((String)"ice.pilots.html4.maxRefreshDelay", (int)500);
    private int layoutCallCount = 0;
    private static Object renderingHints;
    private static Method rHintsMethod;
    private static Object cssDebugger;
    private static Method debugDisplayMethod;
    Rectangle imageablePrintArea = null;
    private AccessPosition _position;
    private AccessPosition _tempPosition;
    private boolean hasReceivedLoadEvent = false;

    CSSLayout(StormData stormData, DDocument dDocument, CSSMatcher cSSMatcher) {
        this.sdata = stormData;
        this.doc = dDocument;
        this.matcher = cSSMatcher;
        this.theView = new TheView(dDocument, this);
        this.selection = dDocument.getSelection();
        this._position = new AccessPosition();
        this._tempPosition = new AccessPosition();
        dDocument.addEventListener("load", this, true);
        dDocument.addEventListener("unload", this, true);
        dDocument.addEventListener("focus", this, true);
        dDocument.addEventListener("blur", this, true);
        dDocument.addEventListener("CSSModified", this, true);
        dDocument.addEventListener("DOMAttrModified", this, true);
        dDocument.addEventListener("DOMNodeInserted", this, true);
        dDocument.addEventListener("DOMNodeRemoved", this, true);
        dDocument.addEventListener("DOMSubtreeModified", this, true);
    }

    final ObjectPool getObjectPool() {
        return this.doc.pilot.objectPool;
    }

    Object getLock() {
        return this.layout_lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refExists(String string) {
        Object object = this.getLock();
        synchronized (object) {
            return this.anchors.get(string.toLowerCase()) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRefPos(String string) {
        Object object = this.getLock();
        synchronized (object) {
            CSSBox cSSBox;
            DNode dNode = (DNode)this.anchors.get(string.toLowerCase());
            if (dNode != null && (cSSBox = this.findCSSBox(dNode)) != null) {
                Point point = new Point();
                cSSBox.findAbsolutePosition(point);
                return point.y;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DNode getRefNode(String string) {
        DNode dNode = null;
        Object object = this.getLock();
        synchronized (object) {
            dNode = (DNode)this.anchors.get(string.toLowerCase());
        }
        return dNode;
    }

    void setWaitForRef(String string) {
        this.waitForRef = string;
    }

    void setPresetScrollPos(int n) {
        this.presetScrollY = n;
    }

    void setPresetScrollPosition(int n, int n2) {
        this.presetScrollX = n;
        this.presetScrollY = n2;
    }

    void setLayoutZoom(int n) {
        if (n < 1 || n > 4096) {
            return;
        }
        this.zoom = n;
        this.doc.mutate();
        this.validateLayout();
    }

    int getLayoutZoom() {
        return this.zoom;
    }

    void clear() {
        this.clear(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(boolean bl) {
        this.mutation = 0;
        this.hasBeenPurged = true;
        this.refreshEventComingUp = false;
        if (this.docPane != null && bl) {
            this.docPane.do_clear();
        }
        this.theView = new TheView(this.doc, this);
        Object object = this.getLock();
        synchronized (object) {
            this.prevDownBox = null;
            this.prevMoveBox = null;
            this.prevDownNode = null;
            this.prevMoveNode = null;
            this.selection.empty();
            this.dynamicStyles = new Hashtable();
            this.anchors = new Hashtable();
            this.counters.clear();
            if (this.topBox != null) {
                this.topBox.dispose();
                this.topBox = null;
            }
            this.curParentBox = null;
            this.focusedBox = null;
            this.floatPainter.clear();
            this.fixedPainter.clear();
            this.boxList.clear();
            if (this.focusManager != null) {
                this.focusManager.clearElements();
            }
            this.fixedBackgrounds = false;
            this.outlinePainter.clear();
            this.cleared = true;
        }
    }

    boolean isLayoutValid() {
        if (this.docPane == null) {
            return true;
        }
        if (this.topBox != null && this.topBox.minWidth == 0) {
            return false;
        }
        return this.doc.getMutation() == this.mutation;
    }

    void validateLayout() {
        if (this.docPane == null) {
            return;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.refresh();
        } else {
            this.docPane.reqRepaint();
        }
    }

    int getWidth() {
        if (this.topBox != null) {
            return this.topBox.width;
        }
        return 0;
    }

    int getHeight() {
        if (this.topBox != null) {
            return this.topBox.height;
        }
        return 0;
    }

    boolean containsFixedBoxes() {
        if (this.fixedPainter != null) {
            return !this.fixedPainter.isEmpty() || this.fixedBackgrounds;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics graphics) {
        block9: {
            this.outlinePainter.clear();
            if (renderingHints != null) {
                try {
                    rHintsMethod.invoke((Object)graphics, renderingHints);
                }
                catch (Exception exception) {
                    if (!Debug.ex) break block9;
                    Debug.ex((Throwable)exception);
                }
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.topBox != null) {
                this.topBox.paintBackground(graphics, graphics.getClipBounds(), 0, 0, this.getWidth(), this.getHeight(), 0);
                this.floatPainter.paintNegativeZ_Indices(graphics);
                this.topBox.paint(graphics);
                this.floatPainter.paintPositiveZ_Indices(graphics);
                this.boxList.paint(graphics);
                this.outlinePainter.paint(graphics);
            }
        }
        if (this.documentFocusOutlineColor != null && this.getFocusManager().isFrameFocused()) {
            graphics.setColor(this.documentFocusOutlineColor);
            for (int i = 0; i < this.documentFocusOutlineWidth; ++i) {
                graphics.drawRect(i, i, this.getWidth() - 1 - i * 2, this.getHeight() - 1 - i * 2);
            }
        }
    }

    void paintFixed(Graphics graphics) {
        if (this.fixedPainter != null) {
            this.fixedPainter.paintNegativeZ_Indices(graphics);
            this.fixedPainter.paintPositiveZ_Indices(graphics);
        }
    }

    void layout(int n, int n2) {
        this.do_layout(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_layout(int n, int n2) {
        ++this.layoutCallCount;
        this.checkDocumentFocusOutline();
        if (this.docPane != null) {
            this.docPane.setCursor(0);
        }
        this.doc.notifyLayoutBegin();
        DNode dNode = null;
        if (this.mutation != this.doc.getMutation()) {
            if (this.focusManager != null) {
                dNode = this.focusManager.getFocusedElement();
            }
            if (!this.cleared) {
                this.clear(false);
            }
            this.generate();
        }
        Class[] classArray = this.getLock();
        synchronized (classArray) {
            int n3;
            this.floatPainter.clear();
            if (this.topBox == null) {
                this.doc.notifyLayoutEnd();
                return;
            }
            this.topBox.calcMinMaxWidths();
            this.topBox.ox = 0;
            this.topBox.oy = 0;
            this.topBox.width = n3 = n;
            FloatManager floatManager = new FloatManager(0, n3);
            this.topBox.layout(n3, n2, floatManager);
            this.topBox.height += floatManager.skipTill(n3);
            CSSBox cSSBox = floatManager.getFirstFloater();
            if (cSSBox != null) {
                this.floatPainter.add(cSSBox);
            }
            this.fixedPainter.layout(n, n2);
            this.boxList.layout(this.topBox);
            if (n3 < this.topBox.minWidth && this.topBox.width < this.topBox.minWidth) {
                this.topBox.width = this.topBox.minWidth;
            }
        }
        if (this.focusManager != null) {
            this.focusManager.layoutComplete();
            if (dNode != null) {
                this.focusManager.setFocusedBox(dNode);
            }
        }
        this.doc.notifyLayoutEnd();
        if (this.prevMoveX != -1 && this.prevMoveBox == null) {
            this.doMouseOver(null, this.prevMoveX, this.prevMoveY, this.prevMoveScrollX, this.prevMoveScrollY, false);
        }
        if (cssDebugger != null) {
            try {
                classArray = new Class[]{CSSBox.class};
                debugDisplayMethod = cssDebugger.getClass().getMethod("showTree", classArray);
                Object[] objectArray = new Object[]{this.topBox};
                debugDisplayMethod.invoke(cssDebugger, objectArray);
            }
            catch (Exception exception) {
                cssDebugger = null;
            }
        }
        this._position._needsReview = true;
    }

    void postLayout() {
        if (this.waitForRef != null) {
            int n = this.getRefPos(this.waitForRef);
            if (n >= 0) {
                this.waitForRef = null;
                if (this.docPane != null) {
                    this.docPane.setScrollPosition(0, n);
                }
            }
        } else if (this.presetScrollX > 0 || this.presetScrollY > 0) {
            this.docPane.setScrollPosition(this.presetScrollX, this.presetScrollY);
            this.presetScrollX = 0;
            this.presetScrollY = 0;
        }
    }

    void addFixedBox(CSSBox cSSBox) {
        this.fixedPainter.add(cSSBox);
    }

    void addRelativeBox(CSSBox cSSBox, CSSBox cSSBox2) {
        this.boxList.addChild(cSSBox, cSSBox2);
    }

    void addAbsoluteBox(CSSBox cSSBox, CSSBox cSSBox2) {
        this.boxList.addChild(cSSBox, cSSBox2);
    }

    FocusManager getFocusManager() {
        return this.focusManager;
    }

    void setFocusManager(FocusManager focusManager) {
        this.focusManager = focusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() {
        Object object;
        int n;
        DynamicObject dynamicObject;
        int n2 = 0;
        Vector vector = new Vector();
        Object object2 = this.getLock();
        synchronized (object2) {
            this.prevDownBox = null;
            this.prevMoveBox = null;
            this.prevDownNode = null;
            this.prevMoveNode = null;
            n2 = this.doc.getMutation();
            this.focusedBox = null;
            this.dynamicStyles.clear();
            this.anchors.clear();
            this.counters.clear();
            this.floatPainter.clear();
            this.fixedPainter.clear();
            this.boxList.clear();
            this.maxOutlineWidth = 0;
            this.matcher.build();
            dynamicObject = (DElement)this.doc.getDocumentElement();
            if (dynamicObject == null) {
                return;
            }
            this.curParentBox = null;
            this.topBox = this.visitElement((DElement)dynamicObject);
            if (forceGC) {
                System.gc();
                System.gc();
            }
            this.gen_r((DNode)dynamicObject, this.topBox, vector);
            this.curParentBox = null;
            this.substBoxes.clear();
            this.cleared = false;
        }
        object2 = this.getObjectPool();
        ((ObjectPool)object2).beginCreating();
        dynamicObject = (DNodeList)this.doc.getIFrames();
        int n3 = ((DNodeList)dynamicObject).getLength();
        if (n3 > 0) {
            for (n = 0; n < n3; ++n) {
                DElement dElement = (DElement)((DNodeList)dynamicObject).item(n);
                object = ((ObjectPool)object2).createEmbeddedObjectPainter(dElement, null);
                if (object == null) continue;
                object.setBox(null);
            }
            if (this.doc.pilot.isFromHistory) {
                this.doc.pilot.firePropertyChange("viewport", null, "childrenReady");
            }
        }
        int n4 = vector.size();
        for (n = 0; n != n4; ++n) {
            ObjectPainter objectPainter;
            object = (CSSBox)vector.elementAt(n);
            DElement dElement = (DElement)((CSSBox)object).getDomNode();
            if (dElement == null || (objectPainter = ((ObjectPool)object2).createEmbeddedObjectPainter(dElement, (CSSBox)object)) == null) continue;
            ObjectBox objectBox = new ObjectBox(objectPainter, this);
            object = ((CSSBox)object).addChild(objectBox);
            this.initObjectBox(objectBox, objectPainter);
        }
        ((ObjectPool)object2).endCreating();
        vector.removeAllElements();
        this.mutation = n2;
        this.doc.notifyLayoutBuilt();
    }

    private void gen_r(DNode dNode, CSSBox cSSBox, Vector vector) {
        Vector vector2 = null;
        DNode dNode2 = dNode.getFirstDChild();
        while (dNode2 != null) {
            Object object;
            Object object2;
            if (this.memoryCheckCounter > 0) {
                this.memoryCheckCounter = 200;
            } else if (MemoryManager.getInstance().isLowMemory()) {
                this.doc.pilot.clear("text/html");
                object2 = new ICEException(1, 4, 2);
                this.doc.pilot.firePropertyChange("contentLoading", object2, "error");
                throw new RuntimeException("low mem in layout");
            }
            if (cSSBox.parentBox == null && !this.substBoxes.isEmpty() && (object2 = (CSSBox)this.substBoxes.get(cSSBox)) != null) {
                this.substBoxes.remove(cSSBox);
                cSSBox = object2;
            }
            this.curParentBox = cSSBox;
            object2 = null;
            if (dNode2 instanceof DElement) {
                object = (DElement)dNode2;
                object2 = ((DElement)object).isReplacedElement() ? this.visitObjectElement((DElement)object, vector) : this.visitElement((DElement)object);
            } else if (dNode2 instanceof DTextNode) {
                object2 = this.visitTextNode((DTextNode)dNode2);
            }
            cSSBox = this.curParentBox;
            if (this.resetedCounters != null) {
                vector2 = this.resetedCounters;
                this.resetedCounters = null;
            }
            if (object2 != null) {
                if (object2 instanceof ScrollBox) {
                    vector.addElement(object2);
                }
                if (this.pseudoBefore != null) {
                    object = this.pseudoBefore;
                    this.pseudoBefore = null;
                    object2 = ((CSSBox)object2).addChild((CSSBox)object);
                }
                if (this.pseudoAfter != null) {
                    object = object2;
                    CSSBox cSSBox2 = this.pseudoAfter;
                    this.pseudoAfter = null;
                    this.gen_r(dNode2, (CSSBox)object2, vector);
                    object = ((CSSBox)object).addChild(cSSBox2);
                } else {
                    this.gen_r(dNode2, (CSSBox)object2, vector);
                }
                ((CSSBox)object2).notifyChildrenGenerated();
            }
            if (vector2 != null) {
                this.counters.removeCounters(vector2);
                vector2 = null;
            }
            dNode2 = dNode2.next;
        }
    }

    protected void initObjectBox(ObjectBox objectBox, ObjectPainter objectPainter) {
        objectPainter.setBox(objectBox);
    }

    String getCounterValue(String string, boolean bl, String string2, int n) {
        return this.counters.getCounterValue(string, bl, string2, n);
    }

    void incCounters(Vector vector) {
        this.counters.incCounters(vector);
    }

    void updateCounters(Vector vector) {
        this.counters.updateCounters(vector);
    }

    void resetCounters(Vector vector) {
        this.resetedCounters = vector;
        this.counters.resetCounters(vector);
    }

    private final CSSBox visitElement(DElement dElement) {
        CSSBox cSSBox = this.matcher.createCSSBox(dElement, this.curParentBox, this);
        if (cSSBox != null) {
            if (!this.inPrintMode) {
                dElement.hack_box = cSSBox;
            }
            if (dElement.isFocusable() && this.focusManager != null) {
                this.focusManager.registerNewElement(cSSBox, dElement);
            }
            if (dElement.tagId == 1) {
                String string = dElement.getAttribute(63);
                if (string == null) {
                    string = dElement.getAttribute(50);
                }
                if (string != null) {
                    this.anchors.put(string.toLowerCase(), dElement);
                }
            } else {
                String string = dElement.getAttribute(50);
                if (string != null && string.length() != 0) {
                    this.anchors.put(string.toLowerCase(), dElement);
                }
            }
            if (cSSBox.css.background_image != null) {
                if ((cSSBox.css.background_params & 4) != 0) {
                    this.fixedBackgrounds = true;
                }
                if (this.printback) {
                    cSSBox.loadBackgroundImage(this.doc);
                }
            }
        }
        return cSSBox;
    }

    void setPrintBack(boolean bl) {
        this.printback = bl;
    }

    boolean getPrintBack() {
        return this.printback;
    }

    final CSSBox visitObjectElement(DElement dElement, Vector vector) {
        CSSBox cSSBox = this.visitElement(dElement);
        if (cSSBox != null) {
            Node node;
            vector.addElement(cSSBox);
            String string = dElement.getAttribute(112);
            if (string != null && this.focusManager != null && string.length() > 1 && (node = this.doc.getMaps().namedItem(string.substring(1))) instanceof DMapElement) {
                DMapElement dMapElement = (DMapElement)node;
                for (int i = 0; i < dMapElement.getAreas().getLength(); ++i) {
                    this.focusManager.registerNewElement(cSSBox, (DElement)dMapElement.getAreas().item(i));
                }
            }
        }
        return null;
    }

    private final CSSBox visitTextNode(DTextNode dTextNode) {
        TextBox textBox = new TextBox(dTextNode, this);
        this.curParentBox = this.curParentBox.addChild(textBox);
        return null;
    }

    CSSBox getBoxAt(int n, int n2, int n3, int n4, Point point) {
        CSSBox cSSBox = this.fixedPainter.getBoxAt(n, n2, point);
        if (cSSBox == null) {
            cSSBox = this.boxList.getBoxAt(n + n3, n2 + n4, point);
        }
        if (cSSBox == null) {
            cSSBox = this.floatPainter.getBoxAt(n + n3, n2 + n4, point);
        }
        if (cSSBox == null && this.topBox != null) {
            cSSBox = this.topBox.getBoxAt(n + n3, n2 + n4, point);
        }
        if (cSSBox != null && (cSSBox.css.misc & 1) == 0) {
            cSSBox = null;
        }
        return cSSBox;
    }

    void handleEvent(DOMUIEvent dOMUIEvent) {
        this.do_handleEvent(dOMUIEvent);
    }

    private void do_handleEvent(DOMUIEvent dOMUIEvent) {
        if (this.topBox == null) {
            return;
        }
        int n = dOMUIEvent.getPosX();
        int n2 = dOMUIEvent.getPosY();
        int n3 = dOMUIEvent.getScrollX();
        int n4 = dOMUIEvent.getScrollY();
        switch (dOMUIEvent.typeId) {
            case 21: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                DNode dNode = null;
                if (this.focusedBox != null) {
                    dNode = this.focusedBox.getDomNode();
                }
                if (dNode == null) {
                    dNode = (DNode)((Object)this.doc.getBody());
                }
                if (dNode == null || this.callDispatchEvent(dOMUIEvent, dNode)) break;
                return;
            }
            case 5: {
                this.doMouseOver(dOMUIEvent, n, n2, n3, n4, true);
                break;
            }
            case 7: {
                this.clickCounter = 0;
                this.doMouseOut(dOMUIEvent);
                break;
            }
            case 6: {
                this.doMouseMove(dOMUIEvent, n, n2, n3, n4);
                break;
            }
            case 3: {
                long l = System.currentTimeMillis();
                this.clickCounter = l - this.pressTimeStamp < 400L ? ++this.clickCounter : 1;
                this.pressTimeStamp = l;
                dOMUIEvent.detail = this.clickCounter;
                this.prevDownBox = this.prevMoveBox;
                this.prevDownNode = this.prevMoveNode;
                if (this.prevDownNode != null) {
                    dOMUIEvent.setPosX(this.eventPos.x);
                    dOMUIEvent.setPosY(this.eventPos.y);
                    if (!this.callDispatchEvent(dOMUIEvent, this.prevDownNode)) {
                        return;
                    }
                }
                if (this.prevDownBox == null) break;
                this.prevDownBox.applyDynamicStyle(dOMUIEvent.typeId);
                break;
            }
            case 4: {
                if (this.prevMoveNode != null) {
                    dOMUIEvent.detail = this.clickCounter;
                    dOMUIEvent.setPosX(this.eventPos.x);
                    dOMUIEvent.setPosY(this.eventPos.y);
                    dOMUIEvent.relatedNode = this.prevMoveNode;
                    if (!this.callDispatchEvent(dOMUIEvent, this.prevMoveNode)) {
                        return;
                    }
                    if (this.prevDownBox != null) {
                        this.prevDownBox.applyDynamicStyle(dOMUIEvent.typeId);
                    }
                }
                this.prevDownBox = null;
                this.prevDownNode = null;
            }
        }
    }

    private final void doMouseOver(DOMUIEvent dOMUIEvent, int n, int n2, int n3, int n4, boolean bl) {
        CSSBox cSSBox = this.getBoxAt(n, n2, n3, n4, this.eventPos);
        DNode dNode = null;
        if (cSSBox != null) {
            if (cSSBox instanceof ObjectBox) {
                dNode = ((ObjectBox)cSSBox).getDomNode(this.eventPos.x, this.eventPos.y);
                if (dNode != cSSBox.getDomNode() && dOMUIEvent != null) {
                    dOMUIEvent.nodeAfterMap = cSSBox.getDomNode();
                }
            } else {
                dNode = cSSBox.getDomNode();
            }
        }
        this.prevMoveBox = cSSBox;
        this.prevMoveNode = dNode;
        this.prevMoveX = n;
        this.prevMoveY = n2;
        this.prevMoveScrollX = n3;
        this.prevMoveScrollY = n4;
        if (dNode != null && bl) {
            dOMUIEvent.setPosX(this.eventPos.x);
            dOMUIEvent.setPosY(this.eventPos.y);
            if (!this.callDispatchEvent(dOMUIEvent, dNode)) {
                return;
            }
        }
        this.doApplyDynamicStyle(cSSBox, 5);
        if (cSSBox != null && cSSBox.css.cursor >= 0) {
            this.docPane.setCursor(cSSBox.css.cursor);
        }
    }

    private final void doMouseOut(DOMUIEvent dOMUIEvent) {
        CSSBox cSSBox = this.prevMoveBox;
        DNode dNode = this.prevMoveNode;
        this.prevMoveBox = null;
        this.prevMoveNode = null;
        this.prevMoveX = -1;
        if (dNode != null && !this.callDispatchEvent(dOMUIEvent, dNode)) {
            return;
        }
        if (cSSBox != null && cSSBox.css.cursor >= 0) {
            this.docPane.setCursor(0);
        }
        this.doApplyDynamicStyle(cSSBox, dOMUIEvent.typeId);
    }

    private final void doMouseMove(DOMUIEvent dOMUIEvent, int n, int n2, int n3, int n4) {
        CSSBox cSSBox = this.getBoxAt(n, n2, n3, n4, this.eventPos);
        DNode dNode = null;
        if (cSSBox != null) {
            if (cSSBox instanceof ObjectBox) {
                dNode = ((ObjectBox)cSSBox).getDomNode(this.eventPos.x, this.eventPos.y);
                if (dNode != cSSBox.getDomNode()) {
                    dOMUIEvent.nodeAfterMap = cSSBox.getDomNode();
                }
            } else {
                dNode = cSSBox.getDomNode();
            }
        }
        CSSBox cSSBox2 = this.prevMoveBox;
        DNode dNode2 = this.prevMoveNode;
        this.prevMoveBox = cSSBox;
        this.prevMoveNode = dNode;
        this.prevMoveX = n;
        this.prevMoveY = n2;
        this.prevMoveScrollX = n3;
        this.prevMoveScrollY = n4;
        if (cSSBox == cSSBox2 && dNode == dNode2) {
            if (dNode != null) {
                dOMUIEvent.setPosX(this.eventPos.x);
                dOMUIEvent.setPosY(this.eventPos.y);
                if (!this.callDispatchEvent(dOMUIEvent, dNode)) {
                    return;
                }
            }
        } else {
            DNode dNode3;
            DOMUIEvent dOMUIEvent2;
            this.clickCounter = 0;
            if (dNode2 != null) {
                dOMUIEvent2 = (DOMUIEvent)this.doc.createDOMEvent(7);
                dOMUIEvent2.copyUIDataFrom(dOMUIEvent);
                if (dNode2 instanceof DAreaElement && cSSBox2 != null) {
                    dNode3 = cSSBox2.getDomNode();
                    dOMUIEvent2.nodeAfterMap = dNode3.tagId == 6 ? dNode3.getParentDNode().getNextDSibling() : dNode3;
                }
                dOMUIEvent2.relatedNode = dNode;
                if (!this.callDispatchEvent(dOMUIEvent2, dNode2)) {
                    return;
                }
            }
            if (cSSBox2 != null && cSSBox2.css.cursor >= 0) {
                this.docPane.setCursor(0);
            }
            this.doApplyDynamicStyle(cSSBox2, 7);
            if (dNode != null) {
                dOMUIEvent2 = (DOMUIEvent)this.doc.createDOMEvent(5);
                dOMUIEvent2.copyUIDataFrom(dOMUIEvent);
                if (dNode instanceof DAreaElement && cSSBox != null) {
                    dNode3 = cSSBox.getDomNode();
                    dOMUIEvent2.nodeAfterMap = dNode3.tagId == 6 ? dNode3.getParentDNode().getNextDSibling() : dNode3;
                }
                dOMUIEvent2.setPosX(this.eventPos.x);
                dOMUIEvent2.setPosY(this.eventPos.y);
                dOMUIEvent2.relatedNode = dNode2;
                if (!this.callDispatchEvent(dOMUIEvent2, dNode)) {
                    return;
                }
            }
            this.doApplyDynamicStyle(cSSBox, 5);
            if (cSSBox != null && cSSBox.css.cursor >= 0) {
                this.docPane.setCursor(cSSBox.css.cursor);
            }
        }
    }

    private boolean callDispatchEvent(DOMUIEvent dOMUIEvent, DNode dNode) {
        int n = this.layoutCallCount;
        dNode.dispatchEvent(dOMUIEvent);
        return n == this.layoutCallCount;
    }

    private void doApplyDynamicStyle(CSSBox cSSBox, int n) {
        CSSAttribs cSSAttribs;
        CSSBox cSSBox2;
        if (cSSBox == null) {
            return;
        }
        if (cSSBox instanceof ButtonBox) {
            cSSBox = ((ButtonBox)cSSBox).getBlock();
        }
        cSSBox.applyDynamicStyle(n);
        if (n == 7 && (cSSBox2 = this.focusedBox) != null) {
            cSSBox2.applyDynamicStyle(21);
        }
        if (n == 22 && (cSSBox2 = this.focusedBox) != null && (cSSAttribs = this.getDynamicStyle(cSSBox2, 1)) != null && cSSBox2.css != cSSAttribs && this.prevMoveBox != null) {
            this.prevMoveBox.applyDynamicStyle(5);
        }
    }

    CSSAttribs getDynamicStyle(CSSBox cSSBox, int n) {
        DNode dNode = cSSBox.getDomNode();
        if (dNode == null) {
            return null;
        }
        CSSAttribs[] cSSAttribsArray = (CSSAttribs[])this.dynamicStyles.get(dNode);
        if (n == 4) {
            n = 3;
        }
        if (cSSAttribsArray == null || n < 0 || n >= cSSAttribsArray.length) {
            return null;
        }
        return cSSAttribsArray[n];
    }

    CSSBox findCSSBox(DNode dNode) {
        CSSBox cSSBox = null;
        if (dNode instanceof DElement) {
            cSSBox = ((DElement)dNode).hack_box;
        }
        if (cSSBox == null) {
            cSSBox = this.find_r(this.topBox, dNode);
            if (cSSBox == null) {
                cSSBox = this.find_inpainter(this.fixedPainter, dNode);
            }
            if (cSSBox == null) {
                cSSBox = this.find_inpainter(this.floatPainter, dNode);
            }
            if (cSSBox == null) {
                cSSBox = this.boxList.findCSSBox(dNode);
            }
        }
        return cSSBox;
    }

    ObjectBox getWrappedObjectBoxOrNull(CSSBox cSSBox) {
        if (cSSBox instanceof InlineBox) {
            InlineBox inlineBox = (InlineBox)cSSBox;
            cSSBox = inlineBox.first;
            while (cSSBox != null) {
                if (cSSBox instanceof ObjectBox) {
                    return (ObjectBox)cSSBox;
                }
                cSSBox = cSSBox.next;
            }
        } else if (cSSBox instanceof ObjectBox) {
            return (ObjectBox)cSSBox;
        }
        return null;
    }

    private CSSBox find_inpainter(FloatPainter floatPainter, DNode dNode) {
        CSSBox cSSBox = floatPainter.getFirst();
        CSSBox cSSBox2 = null;
        while (cSSBox != null && cSSBox2 == null) {
            cSSBox2 = this.find_r(cSSBox, dNode);
            cSSBox = cSSBox.next;
        }
        return cSSBox2;
    }

    private CSSBox find_r(CSSBox cSSBox, DNode dNode) {
        if (cSSBox == null) {
            return null;
        }
        if (cSSBox.getDomNode() == dNode) {
            return cSSBox;
        }
        CSSBox cSSBox2 = cSSBox.getFirstChild();
        CSSBox cSSBox3 = null;
        while (cSSBox2 != null && cSSBox3 == null) {
            cSSBox3 = this.find_r(cSSBox2, dNode);
            cSSBox2 = cSSBox2.next;
        }
        return cSSBox3;
    }

    void clearSelection() {
        this.firstDNodeForSelection = null;
        this.firstOffsetForSelection = 0;
        if (this.somethingSelected) {
            this.selection.empty();
            this.somethingSelected = false;
            this.docPane.reqRepaint();
        }
    }

    void setSelection(int n, int n2, int n3, int n4, int n5, int n6) {
        CSSBox cSSBox;
        this.sel_y1 = n2 + n6;
        this.sel_y2 = n4 + n6;
        DNode dNode = null;
        DNode dNode2 = null;
        int n7 = 0;
        int n8 = 0;
        Point point = new Point();
        Point point2 = new Point();
        Point point3 = new Point();
        Point point4 = new Point();
        int n9 = 0;
        int n10 = 0;
        CSSBox cSSBox2 = this.getBoxAt(n, n2, n5, n6, point);
        if (cSSBox2 != null && cSSBox2 instanceof TextBox) {
            dNode = cSSBox2.getDomNode();
            cSSBox2.findAbsolutePosition(point3);
            n9 = ((TextBox)cSSBox2).getRenderedLineNumber(n2 + n6);
        }
        if ((cSSBox = this.getBoxAt(n3, n4, n5, n6, point2)) != null && cSSBox instanceof TextBox) {
            dNode2 = cSSBox.getDomNode();
            cSSBox.findAbsolutePosition(point4);
            n10 = ((TextBox)cSSBox).getRenderedLineNumber(n4 + n6);
        }
        boolean bl = false;
        if (n10 > n9) {
            bl = true;
        } else if (n10 == n9 && n3 > n) {
            bl = true;
        }
        if (cSSBox2 != null && cSSBox2 instanceof TextBox) {
            n7 = ((TextBox)cSSBox2).getCharacterIndex(point.x, bl);
        }
        if (cSSBox != null && cSSBox instanceof TextBox) {
            n8 = ((TextBox)cSSBox).getCharacterIndex(point2.x, !bl);
        }
        if (dNode != null && dNode2 != null) {
            this.selection.setRange(dNode, n7, dNode2, n8);
            this.somethingSelected = true;
            this.docPane.reqRepaint();
        } else if (dNode == null && dNode2 != null) {
            if (this.firstDNodeForSelection == null) {
                this.firstDNodeForSelection = cSSBox.getDomNode();
                this.firstOffsetForSelection = ((TextBox)cSSBox).getCharacterIndex(point2.x, n4 > n2);
            }
            this.selection.setRange(this.firstDNodeForSelection, this.firstOffsetForSelection, dNode2, n8);
            this.somethingSelected = true;
            this.docPane.reqRepaint();
        }
    }

    void selectWord(int n, int n2, int n3, int n4) {
        CSSBox cSSBox = this.getBoxAt(n, n2, n3, n4, new Point());
        if (cSSBox == null || !(cSSBox instanceof TextBox)) {
            return;
        }
        TextBox textBox = (TextBox)cSSBox;
        DNode dNode = textBox.getDomNode();
        if (!(dNode instanceof DTextNode)) {
            return;
        }
        DTextNode dTextNode = (DTextNode)textBox.getDomNode();
        int n5 = this.getIndexAtPoint(n, n2, n3, n4);
        int n6 = n5 - textBox.getStartingCharacterOffset();
        int n7 = 0;
        int n8 = textBox.getText().length;
        int[] nArray = ((DTextNode)textBox.getDomNode()).breakOffset;
        for (int i = 0; i < nArray.length; ++i) {
            int n9 = Math.abs(nArray[i]);
            if (n9 <= n6) {
                n7 = n9;
            }
            if (n9 <= n6) continue;
            n8 = n9 - 1;
            break;
        }
        this.selection.setRange(dTextNode, n7, dTextNode, n8);
        this.somethingSelected = true;
        this.docPane.reqRepaint();
    }

    public void selectWordByIndex(int n) {
        CSSBox cSSBox = ((BlockBox)this.topBox).findChildByIndex(2, n);
        if (cSSBox == null || !(cSSBox instanceof TextBox)) {
            return;
        }
        DNode dNode = cSSBox.getDomNode();
        TextBox textBox = (TextBox)cSSBox;
        int n2 = textBox.getCharIndexOfWordAbsolute(n);
        String string = this.getText(2, n, false).trim();
        int n3 = n2 + string.length();
        if (n2 >= 0 && n3 > 0) {
            this.scrollToBox((DTextNode)dNode);
            this.selection.setRange(dNode, n2, dNode, n3);
            this.somethingSelected = true;
        }
        this.docPane.reqRepaint();
    }

    void selectAll() {
        int n = 1;
        DNode dNode = this.getNodeByIndex(n, 0);
        int n2 = this.getCount(n) - 1;
        DNode dNode2 = this.getNodeByIndex(n, n2);
        CSSBox cSSBox = this.findCSSBox(dNode2);
        int n3 = n2 - cSSBox.getStartingCharacterOffset() + 1;
        this.selection.setRange(dNode, 0, dNode2, n3);
        this.somethingSelected = true;
        this.docPane.reqRepaint();
    }

    private final DNode findTextNode_r(DNode dNode, boolean bl) {
        if (dNode == null || dNode instanceof DTextNode) {
            return dNode;
        }
        if (bl) {
            dNode = dNode.first;
            while (dNode != null) {
                DNode dNode2 = this.findTextNode_r(dNode, bl);
                if (dNode2 != null && this.sel_accept(dNode2, bl)) {
                    return dNode2;
                }
                dNode = dNode.next;
            }
        } else {
            dNode = dNode.last;
            while (dNode != null) {
                DNode dNode3 = this.findTextNode_r(dNode, bl);
                if (dNode3 != null && this.sel_accept(dNode3, bl)) {
                    return dNode3;
                }
                dNode = dNode.prev;
            }
        }
        return null;
    }

    public void scrollToBox(DTextNode dTextNode) {
        TheView theView = (TheView)this.doc.getDefaultView();
        if (theView != null) {
            Rectangle rectangle = new Rectangle();
            theView.findBoundingBox(dTextNode, rectangle);
            if (rectangle.width > 0 && !this.docPane.isVisibleOnScreen(rectangle.x, rectangle.y)) {
                if (rectangle.width < this.docPane.getPaneWidth() && rectangle.x <= this.docPane.getPaneWidth()) {
                    this.docPane.setScrollPosition(0, rectangle.y);
                } else {
                    this.docPane.setScrollPosition(rectangle.x, rectangle.y);
                }
            }
        }
    }

    private final boolean sel_accept(DNode dNode, boolean bl) {
        CSSBox cSSBox = this.findCSSBox(dNode);
        if (cSSBox == null) {
            return false;
        }
        this.sel_tmp.x = 0;
        this.sel_tmp.y = 0;
        this.sel_tmp.width = 0;
        this.sel_tmp.height = 0;
        cSSBox.findBoundingBox(this.sel_tmp);
        return this.sel_tmp.y + this.sel_tmp.height > this.sel_y1 && this.sel_tmp.y < this.sel_y2;
    }

    void paintCallback(Graphics graphics, ObjectPainter objectPainter) {
        objectPainter.draw(graphics);
    }

    private CSSBox postProcessBox(CSSBox cSSBox) {
        if (cSSBox instanceof TextBox) {
            return cSSBox.parentBox;
        }
        return cSSBox;
    }

    final void checkDocumentFocusOutline() {
        Color color = null;
        int n = 0;
        String string = Defs.sysProperty((String)"ice.pilots.html4.documentFocusOutline");
        if (string != null) {
            string = "outline: " + string;
            char[] cArray = string.toCharArray();
            CSSDecl cSSDecl = CSSLookup.parseDeclaration(this.sdata, cArray, 0, 7, 9, string.length() - 9);
            CSSAttribs cSSAttribs = new CSSAttribs(this.sdata, this.getLayoutZoom());
            while (cSSDecl != null) {
                CSSLookup.apply(cSSAttribs, cSSDecl, this.getLayoutZoom(), null);
                cSSDecl = cSSDecl.next;
            }
            color = cSSAttribs.outline_color;
            n = cSSAttribs.outline_width;
            if (color == null) {
                color = Color.black;
            }
            if (n <= 0) {
                n = 1;
            }
        }
        this.documentFocusOutlineColor = color;
        this.documentFocusOutlineWidth = n;
    }

    public void handleEvent(Event event) {
        if (this.doc.pilot.noLayoutUpdate != 0) {
            return;
        }
        DOMEvent dOMEvent = (DOMEvent)event;
        switch (dOMEvent.getTypeId()) {
            case 13: {
                if (this.hasReceivedLoadEvent) break;
                this.hasReceivedLoadEvent = true;
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 14: {
                if (!this.hasReceivedLoadEvent) break;
                this.hasReceivedLoadEvent = false;
                break;
            }
            case 29: {
                DMutationEvent dMutationEvent = (DMutationEvent)dOMEvent;
                Element element = (Element)((Object)dMutationEvent.getTarget());
                String string = dMutationEvent.getAttrName();
                String string2 = dMutationEvent.getNewValue();
                if (string2 == null) {
                    this.doc.mutate();
                    this.validateLayout();
                    break;
                }
                if (!this.changeStyle(element, string, string2)) {
                    this.doc.mutate();
                }
                this.validateLayout();
                break;
            }
            case 28: {
                DMutationEvent dMutationEvent = (DMutationEvent)dOMEvent;
                EventTarget eventTarget = dMutationEvent.getTarget();
                String string = dMutationEvent.getAttrName();
                if (eventTarget instanceof DElement && ((DElement)eventTarget).tagId == 34) {
                    this.doc.pilot.updateFrameset((DElement)eventTarget);
                    break;
                }
                if (eventTarget instanceof DInputElement) {
                    if ("type".equals(string)) {
                        ((DInputElement)eventTarget).updateType();
                    } else if ("value".equals(string)) {
                        this.tryObjectPainterModified(dMutationEvent);
                        this.validateLayout();
                        return;
                    }
                }
                if (this.tryObjectPainterModified(dMutationEvent)) {
                    return;
                }
                if (eventTarget instanceof DTextNode && "value".equals(string)) {
                    this.validateLayout();
                    return;
                }
                if ("bgcolor".equals(string)) {
                    this.docPane.reqRepaint();
                    return;
                }
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 26: {
                DMutationEvent dMutationEvent = (DMutationEvent)dOMEvent;
                DNode dNode = (DNode)dMutationEvent.getTarget();
                if (dNode == null) {
                    return;
                }
                this.handleDOMNodeInserted(dMutationEvent, dNode);
                break;
            }
            case 27: {
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 25: {
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 21: {
                CSSBox cSSBox;
                DOMUIEvent dOMUIEvent = (DOMUIEvent)dOMEvent;
                DNode dNode = (DNode)dOMEvent.getTarget();
                this.focusedBox = cSSBox = this.findCSSBox(dNode);
                this.doApplyDynamicStyle(cSSBox, 21);
                if (!(dNode instanceof DAreaElement)) break;
                Point point = new Point();
                cSSBox = this.getBoxAt(dOMUIEvent.getPosX() + 1, dOMUIEvent.getPosY() + 1, 0, 0, point);
                if (!(cSSBox instanceof ObjectBox)) break;
                ((ObjectBox)cSSBox).onBoxFocusChange(dNode, 21);
                break;
            }
            case 22: {
                DOMUIEvent dOMUIEvent = (DOMUIEvent)dOMEvent;
                DNode dNode = (DNode)dOMEvent.getTarget();
                CSSBox cSSBox = this.findCSSBox(dNode);
                this.doApplyDynamicStyle(cSSBox, 22);
                if (dNode instanceof DAreaElement) {
                    Point point = new Point();
                    cSSBox = this.getBoxAt(dOMUIEvent.getPosX() + 1, dOMUIEvent.getPosY() + 1, 0, 0, point);
                    if (cSSBox instanceof ObjectBox) {
                        ((ObjectBox)cSSBox).onBoxFocusChange(dNode, 22);
                    }
                }
                this.focusedBox = null;
                break;
            }
            default: {
                Defs.badArg();
            }
        }
    }

    private void handleDOMNodeInserted(DMutationEvent dMutationEvent, DNode dNode) {
        switch (dNode.getNameId()) {
            case 63: {
                try {
                    DOptionElement dOptionElement = (DOptionElement)dNode;
                    DSelectElement dSelectElement = (DSelectElement)dOptionElement.getParentNode();
                    if (dSelectElement == null) {
                        return;
                    }
                    DSelectElement.SelectPainter selectPainter = dSelectElement.getSelectPainter();
                    if (selectPainter == null) break;
                    selectPainter.onOptionStructChange();
                    break;
                }
                catch (ClassCastException classCastException) {
                    if (Debug.ex) {
                        Debug.ex((Throwable)classCastException);
                    }
                    if (Debug.trace) {
                        Debug.trace((String)"HTML.TAG_OPTION - classcast exp");
                    }
                    return;
                }
            }
            case 71: {
                DSelectElement dSelectElement = (DSelectElement)dNode;
                DSelectElement.SelectPainter selectPainter = dSelectElement.getSelectPainter();
                if (selectPainter == null) break;
                break;
            }
            default: {
                this.doc.mutate();
                this.validateLayout();
            }
        }
    }

    private boolean tryObjectPainterModified(DMutationEvent dMutationEvent) {
        try {
            EventTarget eventTarget = dMutationEvent.getTarget();
            if (!(eventTarget instanceof DElement)) {
                return false;
            }
            DElement dElement = (DElement)eventTarget;
            ObjectPainter objectPainter = this.doc.pilot.objectPool.getNodePainter(dElement);
            if (objectPainter == null) {
                return false;
            }
            String string = dMutationEvent.getAttrName();
            if (string == null) {
                return false;
            }
            DAttr dAttr = (DAttr)dElement.getAttributeNode(string);
            objectPainter.onElementAttrChange(dElement, dAttr);
            return true;
        }
        catch (ClassCastException classCastException) {
            if (Debug.ex) {
                Debug.ex((Throwable)classCastException);
            }
            if (Debug.trace) {
                Debug.trace((String)("BAD: " + dMutationEvent.toString()));
            }
            return false;
        }
    }

    private boolean changeStyle(Element element, String string, String string2) {
        int n = string.length();
        char[] cArray = new char[n + string2.length()];
        string.getChars(0, n, cArray, 0);
        string2.getChars(0, string2.length(), cArray, n);
        CSSDecl cSSDecl = CSSLookup.parseDeclaration(this.sdata, cArray, 0, n, n, cArray.length - n);
        return this.changeStyle(element, cSSDecl);
    }

    private boolean changeStyle(Element element, CSSDecl cSSDecl) {
        boolean bl;
        block24: {
            bl = true;
            try {
                CSSBox cSSBox = this.findCSSBox((DElement)element);
                if (cSSBox == null) {
                    return false;
                }
                CSSAttribs cSSAttribs = null;
                if (cSSBox.getParentBox() != null) {
                    cSSAttribs = cSSBox.getParentBox().css;
                }
                while (cSSDecl != null) {
                    CSSAttribs[] cSSAttribsArray;
                    int n;
                    int n2;
                    int n3 = cSSBox.css.top;
                    if (n3 == -123456) {
                        n3 = 0;
                    }
                    if ((n2 = cSSBox.css.left) == -123456) {
                        n2 = 0;
                    }
                    if (cSSDecl.id == 97) {
                        n = cSSBox.css.misc & 1;
                        if (cSSDecl.type == 121 && n == 0 || cSSDecl.type == 120 && n != 0) {
                            cSSDecl = cSSDecl.next;
                            continue;
                        }
                    }
                    if (cSSBox.dynamic > 0 && (cSSAttribsArray = (CSSAttribs[])this.dynamicStyles.get(cSSBox.getDomNode())) != null) {
                        for (int i = 0; i < cSSAttribsArray.length; ++i) {
                            CSSAttribs cSSAttribs2 = cSSAttribsArray[i];
                            if (cSSAttribs2 == null) continue;
                            CSSLookup.apply(cSSAttribs2, cSSDecl, this.getLayoutZoom(), cSSAttribs);
                        }
                    }
                    CSSLookup.apply(cSSBox.css, cSSDecl, this.getLayoutZoom(), cSSAttribs);
                    n = 0;
                    switch (cSSDecl.id) {
                        case 94: {
                            n = cSSBox.css.top - n3;
                            if (cSSBox instanceof PositionedBox) {
                                ((PositionedBox)cSSBox).changeTopAndLeft(0, n);
                                break;
                            }
                            cSSBox.oy += n;
                            break;
                        }
                        case 52: {
                            n = cSSBox.css.left - n2;
                            if (cSSBox instanceof PositionedBox) {
                                ((PositionedBox)cSSBox).changeTopAndLeft(n, 0);
                                break;
                            }
                            cSSBox.ox += n;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 39: 
                        case 46: 
                        case 51: 
                        case 74: 
                        case 100: 
                        case 102: {
                            bl = false;
                            break;
                        }
                        case 97: {
                            if ((cSSBox.css.misc & 0x20) != 0 && cSSBox.parentBox != null) {
                                cSSBox.css.misc = (short)(cSSBox.css.misc & 0xFFFFFFFE);
                                cSSBox.css.misc = (short)(cSSBox.css.misc | cSSBox.parentBox.css.misc & 1);
                            }
                            cSSBox.propagateVisibility(cSSBox.css.misc, false);
                            break;
                        }
                        case 5: 
                        case 33: {
                            ObjectBox objectBox = this.getWrappedObjectBoxOrNull(cSSBox);
                            if (objectBox == null) break;
                            objectBox.updatePainterColors();
                        }
                    }
                    cSSDecl = cSSDecl.next;
                }
                if (bl && this.docPane != null) {
                    this.docPane.reqRepaint();
                }
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block24;
                Debug.trace((String)("Style not changed: " + exception));
            }
        }
        return bl;
    }

    private static Object instantiateRenderingHints() {
        Object var8_8;
        block12: {
            String string = Defs.sysProperty((String)"ice.pilots.html4.antiAliasing");
            String string2 = Defs.sysProperty((String)"ice.pilots.html4.textAntiAliasing");
            String string3 = Defs.sysProperty((String)"ice.pilots.html4.renderQuality");
            String string4 = Defs.sysProperty((String)"ice.pilots.html4.alphaInterpolation");
            String string5 = Defs.sysProperty((String)"ice.pilots.html4.dithering");
            String string6 = Defs.sysProperty((String)"ice.pilots.html4.fractionalMetrics");
            String string7 = Defs.sysProperty((String)"ice.pilots.html4.interpolation");
            String string8 = Defs.sysProperty((String)"ice.pilots.html4.strokeControl");
            if (string == null && string2 == null && string3 == null && string4 == null && string5 == null && string6 == null && string7 == null && string8 == null) {
                return null;
            }
            var8_8 = null;
            try {
                Class<?>[] classArray;
                Class<?> clazz = Class.forName("java.awt.RenderingHints");
                Class<?> clazz2 = Class.forName("java.util.Map");
                Constructor<?>[] constructorArray = clazz.getConstructors();
                if (constructorArray.length > 0) {
                    for (int i = 0; i < constructorArray.length; ++i) {
                        classArray = constructorArray[i].getParameterTypes();
                        if (classArray.length != 1 || !classArray[0].equals(clazz2)) continue;
                        var8_8 = constructorArray[i].newInstance(new Object[]{null});
                        if (string != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_ANTIALIASING", string);
                        }
                        if (string2 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_TEXT_ANTIALIASING", string2);
                        }
                        if (string3 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_RENDERING", string3);
                        }
                        if (string4 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_ALPHA_INTERPOLATION", string4);
                        }
                        if (string5 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_DITHERING", string5);
                        }
                        if (string6 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_FRACTIONALMETRICS", string6);
                        }
                        if (string7 != null) {
                            CSSLayout.addKeyValue(var8_8, "KEY_INTERPOLATION", string7);
                        }
                        if (string8 == null) break;
                        CSSLayout.addKeyValue(var8_8, "KEY_STROKE_CONTROL", string8);
                        break;
                    }
                }
                Class[] classArray2 = new Class[]{clazz2};
                classArray = Class.forName("java.awt.Graphics2D");
                rHintsMethod = classArray.getMethod("addRenderingHints", classArray2);
            }
            catch (Exception exception) {
                if (!Debug.ex) break block12;
                Debug.ex((Throwable)exception);
            }
        }
        return var8_8;
    }

    private static Object instantiateDebugClass() {
        Object object = null;
        try {
            Class<?> clazz = Class.forName("ice.pilots.html4.RenderTreeDialog");
            Class[] classArray = new Class[]{};
            debugDisplayMethod = clazz.getMethod("getInstance", classArray);
            Object[] objectArray = new Object[]{};
            object = debugDisplayMethod.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    private static void addKeyValue(Object object, String string, String string2) {
        block2: {
            Class<?> clazz = object.getClass();
            try {
                Object[] objectArray = new Object[2];
                Field field = clazz.getField(string);
                objectArray[0] = field.get(object);
                field = clazz.getField(string2);
                objectArray[1] = field.get(object);
                Method method = clazz.getMethod("put", Object.class, Object.class);
                method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                if (!Debug.ex) break block2;
                Debug.ex((Throwable)exception);
            }
        }
    }

    void refresh() {
        this.refresh(false);
    }

    void refresh(boolean bl) {
        if (!this.isLayoutValid()) {
            if (!this.refreshEventComingUp || bl) {
                this.refreshEventComingUp = true;
                this.prevRefreshEventTime = System.currentTimeMillis();
                this.hasBeenPurged = false;
                RefreshEvent refreshEvent = new RefreshEvent(this);
                if (bl) {
                    refreshEvent._loadSessionTag = this.doc.pilot.getPilotViewport().addOnloadBlocker(this);
                }
                refreshEvent.postToEventThread(this.minRefreshDelay);
            } else {
                long l = System.currentTimeMillis();
                if (l - this.prevRefreshEventTime > this.maxRefreshDelay) {
                    this.hasBeenPurged = false;
                    RefreshEvent refreshEvent = new RefreshEvent(this);
                    refreshEvent.postToEventThread(this.minRefreshDelay);
                    this.prevRefreshEventTime = System.currentTimeMillis();
                }
            }
        }
    }

    void eventThreadRevalidate() {
        if (this.docPane != null) {
            this.docPane.revalidate();
        }
        this.refreshEventComingUp = false;
    }

    int getCount(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Boundary type enumeration out of range: " + n);
        }
        if (this.topBox != null) {
            Point point = new Point();
            int n2 = this.topBox.getCount(n, point);
            switch (n) {
                case 1: {
                    this._position._maxCharacters = n2;
                    break;
                }
                case 2: {
                    this._position._maxWords = n2;
                    break;
                }
                case 3: {
                    this._position._maxSentences = n2;
                }
            }
            return n2;
        }
        return 0;
    }

    String getSelectedText() {
        return this.selection.toString();
    }

    int getSelectionStart() {
        CSSBox cSSBox;
        this.checkInit();
        int n = 0;
        DNode dNode = this.selection.startContainer;
        if (dNode != null && (cSSBox = this.findCSSBox(dNode)) != null) {
            n = cSSBox.getStartingCharacterOffset() + this.selection.startOffset;
        }
        return n;
    }

    int getSelectionEnd() {
        CSSBox cSSBox;
        this.checkInit();
        int n = 0;
        DNode dNode = this.selection.endContainer;
        if (dNode != null && (cSSBox = this.findCSSBox(dNode)) != null && cSSBox instanceof TextBox) {
            n = cSSBox.getStartingCharacterOffset() + this.selection.endOffset;
        }
        return n;
    }

    void positionToIndex(int n, int n2) {
        this.checkInit();
        switch (n) {
            case 1: {
                if (n2 < 0 || n2 >= this._position._maxCharacters) break;
                this._position._characterInDoc = n2;
                this.getText(n, n2, true);
                break;
            }
            case 2: {
                if (n2 < 0 || n2 >= this._position._maxWords) break;
                this._position._wordInDoc = n2;
                this.getText(n, n2, true);
                break;
            }
            case 3: {
                if (n2 < 0 || n2 >= this._position._maxSentences) break;
                this._position._sentenceInDoc = n2;
                this.getText(n, n2, true);
            }
        }
    }

    String getText(int n, int n2, boolean bl) {
        CSSBox cSSBox;
        this.checkInit();
        if (n2 == -1) {
            n2 = 0;
        }
        if (this.topBox != null && (cSSBox = ((BlockBox)this.topBox).findChildByIndex(n, n2)) != null) {
            if (bl) {
                return cSSBox.getText(n, n2, this._position);
            }
            return cSSBox.getText(n, n2, this._tempPosition);
        }
        return null;
    }

    public DNode getNodeByIndex(int n, int n2) {
        CSSBox cSSBox;
        this.checkInit();
        if (this.topBox != null && (cSSBox = ((BlockBox)this.topBox).findChildByIndex(n, n2)) != null) {
            return cSSBox.getDomNode();
        }
        return null;
    }

    private void checkInit() {
        if (this._position._needsReview) {
            this.getCount(1);
            this.getCount(2);
            this.getCount(3);
            if (this._position._characterInDoc > this._position._maxCharacters) {
                this._position._characterInDoc = 0;
            }
            if (this._position._wordInDoc > this._position._maxWords) {
                this._position._wordInDoc = 0;
            }
            if (this._position._sentenceInDoc > this._position._maxSentences) {
                this._position._sentenceInDoc = 0;
            }
            this._position._needsReview = false;
        }
    }

    String getCurrentText(int n) {
        this.checkInit();
        switch (n) {
            case 1: {
                if (this._position._characterInDoc >= this._position._maxCharacters) break;
                return this.getText(n, this._position._characterInDoc, false);
            }
            case 2: {
                if (this._position._wordInDoc >= this._position._maxWords) break;
                return this.getText(n, this._position._wordInDoc, false);
            }
            case 3: {
                if (this._position._sentenceInDoc >= this._position._maxSentences) break;
                return this.getText(n, this._position._sentenceInDoc, false);
            }
        }
        return null;
    }

    String getTextAt(int n, int n2, int n3, int n4, int n5) {
        int n6;
        this.checkInit();
        this._position._characterInDoc = n6 = this.getIndexAtPoint(n2, n3, n4, n5);
        return this.getText(n, n6, true);
    }

    int getCaretPosition(int n) {
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = this._position._characterInDoc;
                break;
            }
            case 2: {
                n2 = this._position._wordInDoc;
                break;
            }
            case 3: {
                n2 = this._position._sentenceInDoc;
            }
        }
        if (n2 == -1) {
            n2 = 0;
        }
        return n2;
    }

    public CSSAttribs getCharAttribs(int n) {
        CSSBox cSSBox;
        this.checkInit();
        if (this.topBox != null && (cSSBox = ((BlockBox)this.topBox).findChildByIndex(1, n)) != null) {
            return cSSBox.css;
        }
        return null;
    }

    public int getIndexAtPoint(int n, int n2, int n3, int n4) {
        this.checkInit();
        int n5 = 0;
        int n6 = 0;
        Point point = new Point();
        Point point2 = new Point();
        CSSBox cSSBox = this.getBoxAt(n, n2, n3, n4, point);
        if (cSSBox != null && cSSBox instanceof TextBox) {
            cSSBox.findAbsolutePosition(point2);
        }
        if (cSSBox != null && cSSBox instanceof TextBox) {
            n5 = ((TextBox)cSSBox).getCharacterIndex(point.x, false);
            n6 = cSSBox.getStartingCharacterOffset() + n5;
            n6 = n6 > 0 ? --n6 : 0;
        }
        return n6;
    }

    public String getNext(int n) {
        this.checkInit();
        switch (n) {
            case 1: {
                if (this._position._characterInDoc < this._position._maxCharacters - 1) {
                    return this.getText(n, this._position._characterInDoc + 1, true);
                }
                return this.getText(n, 0, true);
            }
            case 2: {
                if (this._position._wordInDoc < this._position._maxWords - 1) {
                    return this.getText(n, this._position._wordInDoc + 1, true);
                }
                return this.getText(n, 0, true);
            }
            case 3: {
                if (this._position._sentenceInDoc < this._position._maxSentences - 1) {
                    return this.getText(n, this._position._sentenceInDoc + 1, true);
                }
                return this.getText(n, 0, true);
            }
        }
        return null;
    }

    public String getPrevious(int n) {
        this.checkInit();
        switch (n) {
            case 1: {
                if (this._position._characterInDoc > 0) {
                    return this.getText(n, this._position._characterInDoc - 1, true);
                }
                return this.getText(n, this._position._maxCharacters - 1, true);
            }
            case 2: {
                if (this._position._wordInDoc > 0) {
                    return this.getText(n, this._position._wordInDoc - 1, true);
                }
                return this.getText(n, this._position._maxWords - 1, true);
            }
            case 3: {
                if (this._position._sentenceInDoc > 0) {
                    return this.getText(n, this._position._sentenceInDoc - 1, true);
                }
                return this.getText(n, this._position._maxSentences - 1, true);
            }
        }
        return null;
    }

    void setImageablePrintArea(Rectangle rectangle) {
        this.imageablePrintArea = rectangle;
    }

    void moveCaretToNode(DNode dNode) {
        this.checkInit();
        CSSBox cSSBox = this.findCSSBox(dNode);
        this.positionToIndex(1, cSSBox.getStartingCharacterOffset());
    }

    static {
        if (JavaVersion.isV12orGreater()) {
            renderingHints = CSSLayout.instantiateRenderingHints();
            cssDebugger = CSSLayout.instantiateDebugClass();
        }
    }
}

