/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.image;

import ice.debug.Debug;
import ice.pilots.image.ThePilot;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import ice.storm.print.StormPageFormat;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector pageLayoutCache = new Vector();
    private ImageComponent imageComponent;

    ThePrinter(ThePilot thePilot) {
        this.pageFormat = new StormPageFormat();
        this.imageComponent = new ImageComponent(thePilot.getImage());
        this.getPageCount();
    }

    public void printPage(Graphics graphics, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.numberOfPages - 1) {
            n = this.numberOfPages - 1;
        }
        Point[] pointArray = (Point[])this.pageLayoutCache.elementAt(n);
        Graphics graphics2 = graphics.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        graphics2.setClip(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        MediaTracker mediaTracker = new MediaTracker(this.imageComponent);
        mediaTracker.addImage(this.imageComponent.getScaledImage(), 1);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Debug.p((String)(" " + interruptedException));
        }
        if (!mediaTracker.isErrorAny()) {
            graphics2.drawImage(this.imageComponent.getScaledImage(), -pointArray[0].x, -pointArray[0].y, this.imageComponent);
        } else {
            Debug.trace((String)"Loading Image error");
        }
        this.imageComponent.paint(graphics2);
        graphics2.dispose();
        Graphics graphics3 = graphics.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        graphics3.translate(0, 0);
        graphics3.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        Vector vector = this.pageFormat.getDecoration();
        for (int i = vector.size() - 1; i >= 0; --i) {
            PageDecoration pageDecoration = (PageDecoration)vector.elementAt(i);
            pageDecoration.paint(graphics3, n, this.numberOfPages, this.pageFormat);
        }
        graphics3.dispose();
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            throw new NullPointerException();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            if (this.pageFormat.isScaleToFitEnabled()) {
                double d = 1.0 / (double)this.imageComponent.getWidth() * this.pageFormat.getImageableWidth();
                this.pageFormat.setScale(d);
            }
            this.imageComponent.scaleImage(this.pageFormat.getScale());
            this.pageLayoutCache = new Vector();
            this.currentPageIndex = 0;
            int n = 0;
            int n2 = 0;
            Point[] pointArray = new Point[]{new Point(0, 0), new Point(0, (int)this.pageFormat.getImageableHeight())};
            while (n2 < this.imageComponent.getScaledHeight()) {
                while (n < this.imageComponent.getScaledWidth()) {
                    n = (int)((double)n + this.pageFormat.getImageableWidth());
                    Point[] pointArray2 = new Point[]{new Point(pointArray[0].x, pointArray[0].y), new Point(n, pointArray[0].y), new Point(pointArray[1].x, pointArray[1].y), new Point(n, pointArray[0].y)};
                    this.pageLayoutCache.addElement(pointArray2);
                    pointArray[0] = new Point(pointArray2[1].x, pointArray2[1].y);
                    pointArray[1] = new Point(pointArray2[3].x, pointArray2[3].y);
                }
                n = 0;
                n2 = (int)((double)n2 + this.pageFormat.getImageableHeight());
                pointArray[0] = new Point(0, n2);
                pointArray[1] = new Point(0, n2 + (int)this.pageFormat.getImageableHeight());
            }
            this.currentPageIndex = -1;
            this.pageFormat.setImageableAreaChangedFlag(false);
            this.numberOfPages = this.pageLayoutCache.size();
        }
        return this.numberOfPages;
    }

    public void print(Graphics graphics) {
        graphics.drawImage(this.imageComponent.getScaledImage(), 0, 0, null, null);
    }

    public Dimension getDimension() {
        return new Dimension(this.imageComponent.getScaledWidth(), this.imageComponent.getScaledHeight());
    }

    public void setZoom(int n) {
        double d = (double)Math.abs(n) / 256.0;
        this.pageFormat.setScale(d);
        this.getPageCount();
    }

    public int getZoom() {
        if (this.pageFormat.isScaleToFitEnabled()) {
            double d = 1.0 / (double)this.imageComponent.getWidth() * this.pageFormat.getImageableWidth();
            this.pageFormat.setScale(d);
        }
        return (int)Math.round(this.pageFormat.getScale() * 256.0);
    }

    public void dispose() {
    }

    class ImageComponent
    extends Component {
        private Image image;
        private Image scaledImage;
        private int scaledWidth;
        private int scaledHeight;

        ImageComponent(Image image) {
            this.image = image;
            this.scaledImage = image.getScaledInstance(-1, -1, 8);
            this.scaledWidth = image.getWidth(this);
            this.scaledHeight = image.getHeight(this);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        }

        public Image getScaledImage() {
            return this.scaledImage;
        }

        public Image getImage() {
            return this.image;
        }

        public int getScaledWidth() {
            return this.scaledWidth;
        }

        public int getWidth() {
            return this.image.getWidth(this);
        }

        public int getHeight() {
            return this.image.getHeight(this);
        }

        public int getScaledHeight() {
            return this.scaledHeight;
        }

        private void scaleImage(double d) {
            this.scaledWidth = (int)((double)this.image.getWidth(this) * d);
            this.scaledHeight = (int)((double)this.image.getHeight(this) * d);
            this.scaledImage = this.image.getScaledInstance(this.scaledWidth, this.scaledHeight, 4);
        }
    }
}

