/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class PopupManager {
    protected JComponent popup = null;
    protected JTextComponent textComponent;
    public static final Placement Above = new Placement("Above");
    public static final Placement Below = new Placement("Below");
    public static final Placement Largest = new Placement("Largest");
    public static final Placement AbovePreferred = new Placement("AbovePreferred");
    public static final Placement BelowPreferred = new Placement("BelowPreferred");
    public static final HorizontalBounds ViewPortBounds = new HorizontalBounds("ViewPort");
    public static final HorizontalBounds ScrollBarBounds = new HorizontalBounds("ScrollBar");
    private KeyListener keyListener;
    private TextComponentListener componentListener;

    public PopupManager(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.keyListener = new PopupKeyListener();
        jTextComponent.addKeyListener(this.keyListener);
        this.componentListener = new TextComponentListener();
        jTextComponent.addComponentListener(this.componentListener);
    }

    public void install(JComponent jComponent) {
        if (this.textComponent == null) {
            return;
        }
        int n = this.textComponent.getCaret().getDot();
        try {
            Rectangle rectangle = this.textComponent.modelToView(n);
            this.install(jComponent, rectangle, Largest);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void uninstall(JComponent jComponent) {
        if (this.popup != null) {
            if (this.popup.isVisible()) {
                this.popup.setVisible(false);
            }
            this.removeFromRootPane(this.popup);
        }
        if (jComponent != this.popup && jComponent != null) {
            if (jComponent.isVisible()) {
                jComponent.setVisible(false);
            }
            this.removeFromRootPane(jComponent);
        }
    }

    public void install(JComponent jComponent, Rectangle rectangle, Placement placement, HorizontalBounds horizontalBounds, int n, int n2) {
        Rectangle rectangle2;
        if (this.popup != null) {
            if (this.popup.isVisible() && this.popup != jComponent) {
                this.popup.setVisible(false);
            }
            this.removeFromRootPane(this.popup);
        }
        this.popup = jComponent;
        if (this.popup != null) {
            this.installToRootPane(this.popup);
        }
        if ((rectangle2 = PopupManager.computeBounds(this.popup, this.textComponent, rectangle, placement, horizontalBounds)) != null) {
            JRootPane jRootPane;
            if (horizontalBounds == ScrollBarBounds) {
                rectangle2.x = 0;
            }
            if ((jRootPane = this.textComponent.getRootPane()) != null) {
                rectangle2 = SwingUtilities.convertRectangle(this.textComponent, rectangle2, jRootPane.getLayeredPane());
            }
            if (horizontalBounds == ScrollBarBounds && this.textComponent.getParent() instanceof JViewport) {
                int n3 = this.textComponent.getParent().getX();
                Rectangle rectangle3 = ((JViewport)this.textComponent.getParent()).getViewRect();
                rectangle2.x += rectangle3.x;
                rectangle2.x -= n3;
                rectangle2.width += n3;
            }
            rectangle2.x += n;
            rectangle2.y += n2;
            rectangle2.width -= n;
            rectangle2.height -= n2;
            this.popup.setBounds(rectangle2);
        } else {
            this.popup.setVisible(false);
        }
    }

    public void install(JComponent jComponent, Rectangle rectangle, Placement placement, HorizontalBounds horizontalBounds) {
        this.install(jComponent, rectangle, placement, ViewPortBounds, 0, 0);
    }

    public void install(JComponent jComponent, Rectangle rectangle, Placement placement) {
        this.install(jComponent, rectangle, placement, ViewPortBounds);
    }

    public JComponent get() {
        return this.popup;
    }

    private void installToRootPane(JComponent jComponent) {
        JRootPane jRootPane = this.textComponent.getRootPane();
        if (jRootPane != null) {
            jRootPane.getLayeredPane().add(jComponent, JLayeredPane.POPUP_LAYER, 0);
        }
    }

    private void removeFromRootPane(JComponent jComponent) {
        JRootPane jRootPane = jComponent.getRootPane();
        if (jRootPane != null) {
            jRootPane.getLayeredPane().remove(jComponent);
        }
    }

    protected static Rectangle computeBounds(JComponent jComponent, JComponent jComponent2, Rectangle rectangle, Placement placement, HorizontalBounds horizontalBounds) {
        Rectangle rectangle2;
        Container container;
        if (horizontalBounds == null) {
            horizontalBounds = ViewPortBounds;
        }
        if ((container = jComponent2.getParent()) instanceof JViewport) {
            Rectangle rectangle3 = ((JViewport)container).getViewRect();
            Rectangle rectangle4 = (Rectangle)rectangle.clone();
            rectangle4.translate(-rectangle3.x, -rectangle3.y);
            rectangle2 = PopupManager.computeBounds(jComponent, rectangle3.width, rectangle3.height, rectangle4, placement, horizontalBounds);
            if (rectangle2 != null) {
                rectangle2.translate(rectangle3.x, rectangle3.y);
            }
        } else {
            rectangle2 = PopupManager.computeBounds(jComponent, jComponent2.getWidth(), jComponent2.getHeight(), rectangle, placement);
        }
        return rectangle2;
    }

    protected static Rectangle computeBounds(JComponent jComponent, JComponent jComponent2, Rectangle rectangle, Placement placement) {
        return PopupManager.computeBounds(jComponent, jComponent2, rectangle, placement, ViewPortBounds);
    }

    protected static Rectangle computeBounds(JComponent jComponent, int n, int n2, Rectangle rectangle, Placement placement, HorizontalBounds horizontalBounds) {
        Placement placement2;
        if (placement == null) {
            throw new NullPointerException("placement cannot be null");
        }
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        int n5 = n2 - n4;
        if (placement == Largest) {
            placement = n3 < n5 ? Below : Above;
        } else if (placement == AbovePreferred && n3 > n5) {
            placement = Above;
        } else if (placement == BelowPreferred && n5 > n3) {
            placement = Below;
        }
        Rectangle rectangle2 = null;
        while (true) {
            jComponent.putClientProperty(Placement.class, placement);
            int n6 = placement == Above || placement == AbovePreferred ? n3 : n5;
            jComponent.setSize(n, n6);
            rectangle2 = jComponent.getBounds();
            placement2 = (Placement)jComponent.getClientProperty(Placement.class);
            if (placement2 == placement) break;
            if (placement == AbovePreferred && placement2 == null) {
                placement = Below;
                continue;
            }
            if (placement != BelowPreferred || placement2 != null) break;
            placement = Above;
        }
        if (placement2 == null) {
            rectangle2 = null;
        }
        if (rectangle2 != null) {
            rectangle2.x = Math.min(rectangle.x, n - rectangle2.width);
            rectangle2.y = placement == Above || placement == AbovePreferred ? n3 - rectangle2.height : n4;
        }
        return rectangle2;
    }

    protected static Rectangle computeBounds(JComponent jComponent, int n, int n2, Rectangle rectangle, Placement placement) {
        return PopupManager.computeBounds(jComponent, n, n2, rectangle, placement, ViewPortBounds);
    }

    public static final class HorizontalBounds {
        private final String representation;

        private HorizontalBounds(String string) {
            this.representation = string;
        }

        public String toString() {
            return this.representation;
        }
    }

    public static final class Placement {
        private final String representation;

        private Placement(String string) {
            this.representation = string;
        }

        public String toString() {
            return this.representation;
        }
    }

    private final class TextComponentListener
    extends ComponentAdapter {
        private TextComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            PopupManager.this.install(null);
        }
    }

    private class PopupKeyListener
    implements KeyListener {
        private PopupKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent == null) {
                return;
            }
            if (PopupManager.this.popup != null && PopupManager.this.popup.isShowing()) {
                Action action;
                ActionMap actionMap = PopupManager.this.popup.getActionMap();
                InputMap inputMap = PopupManager.this.popup.getInputMap();
                Object object = inputMap.get(KeyStroke.getKeyStrokeForEvent(keyEvent));
                if (object != null && (action = actionMap.get(object)) != null) {
                    action.actionPerformed(null);
                    keyEvent.consume();
                }
            }
        }
    }
}

