/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.java;

import java.util.ArrayList;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.ext.java.JavaTokenContext;

public class JCExpression {
    private static final int INVALID = -1;
    public static final int CONSTANT = 0;
    public static final int VARIABLE = 1;
    public static final int OPERATOR = 2;
    public static final int UNARY_OPERATOR = 3;
    public static final int DOT = 4;
    public static final int DOT_OPEN = 5;
    public static final int ARRAY_OPEN = 6;
    public static final int ARRAY = 7;
    public static final int PARENTHESIS_OPEN = 8;
    public static final int PARENTHESIS = 9;
    public static final int METHOD_OPEN = 10;
    public static final int METHOD = 11;
    public static final int CONSTRUCTOR = 12;
    public static final int CONVERSION = 13;
    public static final int TYPE = 14;
    public static final int NEW = 15;
    public static final int INSTANCEOF = 16;
    public static final int GENERIC_TYPE = 17;
    public static final int GENERIC_TYPE_OPEN = 18;
    public static final int GENERIC_WILD_CHAR = 19;
    public static final int ANNOTATION = 20;
    public static final int ANNOTATION_OPEN = 21;
    public static final int IMPORT = 22;
    public static final int CASE = 23;
    private static final int LAST_ID = 23;
    private static final int javaTokenIDsLength = JavaTokenContext.context.getTokenIDs().length;
    private static final int[] OP = new int[javaTokenIDsLength + 23 + 1];
    private static final int RIGHT_ASSOCIATIVE = 32;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private JCExpression parent;
    private int expID;
    private String type;
    private int tokenCountM3;
    private Object[] tokenBlocks = EMPTY_OBJECT_ARRAY;
    private ArrayList prmList;

    JCExpression(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("expID=" + n);
        }
        this.expID = n;
    }

    static JCExpression createEmptyVariable(int n) {
        JCExpression jCExpression = new JCExpression(1);
        jCExpression.addToken(JavaTokenContext.IDENTIFIER, n, "");
        return jCExpression;
    }

    static int getOperatorID(TokenID tokenID) {
        int n = -1;
        if (tokenID.getCategory() == JavaTokenContext.OPERATORS) {
            n = tokenID.getNumericID();
        } else {
            switch (tokenID.getNumericID()) {
                case 96: {
                    n = javaTokenIDsLength + 15;
                    break;
                }
                case 93: {
                    n = javaTokenIDsLength + 16;
                }
            }
        }
        return n;
    }

    static int getOperatorID(JCExpression jCExpression) {
        int n = jCExpression != null ? jCExpression.getExpID() : -1;
        switch (n) {
            case 2: {
                return jCExpression.getTokenID(0).getNumericID();
            }
        }
        return javaTokenIDsLength + n;
    }

    static int getOperatorPrecedence(int n) {
        return OP[n] & 0x1F;
    }

    static boolean isOperatorRightAssociative(int n) {
        return (OP[n] & 0x20) != 0;
    }

    static boolean isValidType(JCExpression jCExpression) {
        switch (jCExpression.getExpID()) {
            case 7: {
                if (jCExpression.getParameterCount() == 1) {
                    return JCExpression.isValidType(jCExpression.getParameter(0));
                }
                return false;
            }
            case 4: {
                int n = jCExpression.getParameterCount();
                for (int i = 0; i < n; ++i) {
                    if (jCExpression.getParameter(i).getExpID() == 1) continue;
                    return false;
                }
                return true;
            }
            case 1: 
            case 14: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public int getExpID() {
        return this.expID;
    }

    void setExpID(int n) {
        this.expID = n;
    }

    public JCExpression getParent() {
        return this.parent;
    }

    void setParent(JCExpression jCExpression) {
        this.parent = jCExpression;
    }

    public String getType() {
        return this.type;
    }

    void setType(String string) {
        this.type = string;
    }

    public int getTokenCount() {
        return this.tokenCountM3 / 3;
    }

    public String getTokenText(int n) {
        return (String)this.tokenBlocks[(n *= 3) + 2];
    }

    public int getTokenOffset(int n) {
        return (Integer)this.tokenBlocks[(n *= 3) + 1];
    }

    public int getTokenLength(int n) {
        return ((String)this.tokenBlocks[(n *= 3) + 2]).length();
    }

    public TokenID getTokenID(int n) {
        return (TokenID)this.tokenBlocks[n *= 3];
    }

    void addToken(TokenID tokenID, int n, String string) {
        if (this.tokenCountM3 == this.tokenBlocks.length) {
            Object[] objectArray = new Object[Math.max(3, this.tokenBlocks.length * 2)];
            if (this.tokenBlocks.length > 0) {
                System.arraycopy(this.tokenBlocks, 0, objectArray, 0, this.tokenBlocks.length);
            }
            this.tokenBlocks = objectArray;
        }
        this.tokenBlocks[this.tokenCountM3++] = tokenID;
        this.tokenBlocks[this.tokenCountM3++] = new Integer(n);
        this.tokenBlocks[this.tokenCountM3++] = string;
    }

    public int getParameterCount() {
        return this.prmList != null ? this.prmList.size() : 0;
    }

    public JCExpression getParameter(int n) {
        return (JCExpression)this.prmList.get(n);
    }

    void addParameter(JCExpression jCExpression) {
        if (this.prmList == null) {
            this.prmList = new ArrayList();
        }
        jCExpression.setParent(this);
        this.prmList.add(jCExpression);
    }

    void swapOperatorParms() {
        if ((this.expID == 2 || this.expID == 16) && this.getParameterCount() == 2) {
            JCExpression jCExpression = (JCExpression)this.prmList.remove(0);
            this.prmList.add(jCExpression);
            jCExpression.swapOperatorParms();
            ((JCExpression)this.prmList.get(0)).swapOperatorParms();
        }
    }

    private static void appendSpaces(StringBuffer stringBuffer, int n) {
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
    }

    static String getIDName(int n) {
        switch (n) {
            case 0: {
                return "CONSTANT";
            }
            case 1: {
                return "VARIABLE";
            }
            case 2: {
                return "OPERATOR";
            }
            case 3: {
                return "UNARY_OPERATOR";
            }
            case 4: {
                return "DOT";
            }
            case 5: {
                return "DOT_OPEN";
            }
            case 7: {
                return "ARRAY";
            }
            case 6: {
                return "ARRAY_OPEN";
            }
            case 8: {
                return "PARENTHESIS_OPEN";
            }
            case 9: {
                return "PARENTHESIS";
            }
            case 10: {
                return "METHOD_OPEN";
            }
            case 11: {
                return "METHOD";
            }
            case 12: {
                return "CONSTRUCTOR";
            }
            case 13: {
                return "CONVERSION";
            }
            case 14: {
                return "TYPE";
            }
            case 15: {
                return "NEW";
            }
            case 16: {
                return "INSTANCEOF";
            }
            case 17: {
                return "GENERIC_TYPE";
            }
            case 18: {
                return "GENERIC_TYPE_OPEN";
            }
            case 19: {
                return "GENERIC_WILD_CHAR";
            }
            case 20: {
                return "ANNOTATION";
            }
            case 21: {
                return "ANNOTATION_OPEN";
            }
            case 22: {
                return "IMPORT";
            }
            case 23: {
                return "CASE";
            }
        }
        return "Unknown expID " + n;
    }

    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        JCExpression.appendSpaces(stringBuffer, n);
        stringBuffer.append("expID=" + JCExpression.getIDName(this.expID));
        if (this.type != null) {
            stringBuffer.append(", result type=");
            stringBuffer.append(this.type);
        }
        int n3 = this.getTokenCount();
        stringBuffer.append(", token count=");
        stringBuffer.append(n3);
        if (n3 > 0) {
            n2 = 0;
            while (n2 < this.tokenCountM3) {
                TokenID tokenID = (TokenID)this.tokenBlocks[n2++];
                int n4 = (Integer)this.tokenBlocks[n2++];
                String string = (String)this.tokenBlocks[n2++];
                stringBuffer.append(", token" + (n2 / 3 - 1) + "='" + EditorDebug.debugString(string) + "'");
            }
        }
        n2 = this.getParameterCount();
        stringBuffer.append(", parm count=");
        stringBuffer.append(n2);
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append('\n');
                JCExpression.appendSpaces(stringBuffer, n + 4);
                stringBuffer.append("parm" + i + "=[" + this.getParameter(i).toString(n + 4) + "]");
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    static {
        JCExpression.OP[17] = 34;
        JCExpression.OP[18] = 10;
        JCExpression.OP[19] = 10;
        JCExpression.OP[20] = 11;
        JCExpression.OP[21] = 11;
        JCExpression.OP[22] = 11;
        JCExpression.OP[23] = 12;
        JCExpression.OP[24] = 12;
        JCExpression.OP[25] = 13;
        JCExpression.OP[26] = 13;
        JCExpression.OP[27] = 8;
        JCExpression.OP[28] = 6;
        JCExpression.OP[29] = 7;
        JCExpression.OP[30] = 13;
        JCExpression.OP[31] = 14;
        JCExpression.OP[32] = 14;
        JCExpression.OP[33] = 9;
        JCExpression.OP[34] = 10;
        JCExpression.OP[35] = 10;
        JCExpression.OP[36] = 34;
        JCExpression.OP[37] = 34;
        JCExpression.OP[38] = 34;
        JCExpression.OP[39] = 34;
        JCExpression.OP[40] = 34;
        JCExpression.OP[41] = 34;
        JCExpression.OP[42] = 34;
        JCExpression.OP[43] = 34;
        JCExpression.OP[44] = 34;
        JCExpression.OP[45] = 34;
        JCExpression.OP[46] = 34;
        JCExpression.OP[47] = 9;
        JCExpression.OP[48] = 15;
        JCExpression.OP[50] = 35;
        JCExpression.OP[52] = 35;
        JCExpression.OP[55] = 15;
        JCExpression.OP[56] = 0;
        JCExpression.OP[59] = 15;
        JCExpression.OP[60] = 15;
        JCExpression.OP[61] = 5;
        JCExpression.OP[62] = 4;
        JCExpression.OP[49] = 0;
        JCExpression.OP[51] = 0;
        JCExpression.OP[53] = 16;
        JCExpression.OP[54] = 0;
        JCExpression.OP[57] = 0;
        JCExpression.OP[58] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + -1] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 0] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 1] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 3] = 15;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 4] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 5] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 6] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 7] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 8] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 9] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 10] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 11] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 12] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 13] = 1;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 14] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 15] = 0;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 16] = 10;
        JCExpression.OP[JCExpression.javaTokenIDsLength + 22] = 0;
        EMPTY_OBJECT_ARRAY = new Object[0];
    }
}

