/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;

public class XMLFormatter
extends TagBasedFormatter {
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private static final String TAG_CLOSED_SUFFIX = "/>";
    private static final String TAG_CLOSING_SUFFIX = "/>";
    private static final Pattern VALID_TAG_NAME = Pattern.compile("[\\w+|-]*");
    private static final int WORKUNITS_MAX = 100;

    public XMLFormatter(Class clazz) {
        super(clazz);
    }

    public FormatSupport createFormatSupport(FormatWriter formatWriter) {
        return new XMLFormatSupport(formatWriter);
    }

    @Override
    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    @Override
    protected void initFormatLayers() {
        this.addFormatLayer(new StripEndWhitespaceLayer());
    }

    @Override
    protected String extractTagName(TokenItem tokenItem) {
        String string = tokenItem.getImage();
        int n = -1;
        if (this.isOpeningTag(tokenItem)) {
            n = TAG_OPENING_PREFIX.length();
        } else if (this.isClosingTag(tokenItem)) {
            n = TAG_CLOSING_PREFIX.length();
        }
        if (n >= 0) {
            String string2 = string.substring(n);
            return string2;
        }
        return null;
    }

    @Override
    protected boolean isOpeningTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith(TAG_OPENING_PREFIX) && !tokenItem.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    @Override
    protected boolean isClosingTag(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    @Override
    protected int getTagEndOffset(TokenItem tokenItem) {
        TokenItem tokenItem2;
        for (tokenItem2 = tokenItem.getNext(); tokenItem2 != null && tokenItem2.getTokenID() != XMLTokenIDs.TAG; tokenItem2 = tokenItem2.getNext()) {
        }
        return tokenItem2 == null ? -1 : tokenItem2.getOffset();
    }

    @Override
    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument baseDocument) {
        return (XMLSyntaxSupport)baseDocument.getSyntaxSupport().get(XMLSyntaxSupport.class);
    }

    @Override
    protected boolean areTagNamesEqual(String string, String string2) {
        return string.equals(string2);
    }

    @Override
    protected boolean isClosingTagRequired(BaseDocument baseDocument, String string) {
        return true;
    }

    @Override
    protected int getOpeningSymbolOffset(TokenItem tokenItem) {
        return tokenItem.getOffset();
    }

    @Override
    protected TokenItem getTagTokenEndingAtPosition(BaseDocument baseDocument, int n) throws BadLocationException {
        ExtSyntaxSupport extSyntaxSupport;
        TokenItem tokenItem;
        if (n >= 0 && (tokenItem = (extSyntaxSupport = this.getSyntaxSupport(baseDocument)).getTokenChain(n, n + 1)).getTokenID() == XMLTokenIDs.TAG && tokenItem.getImage().equals(">")) {
            while ((tokenItem = tokenItem.getPrevious()) != null && !this.isOpeningTag(tokenItem) && !this.isClosingTag(tokenItem)) {
            }
            return tokenItem;
        }
        return null;
    }

    @Override
    protected boolean isUnformattableToken(TokenItem tokenItem) {
        return tokenItem.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || tokenItem.getTokenID() == XMLTokenIDs.CDATA_SECTION;
    }

    @Override
    protected boolean isUnformattableTag(String string) {
        return false;
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        @Override
        protected FormatSupport createFormatSupport(FormatWriter formatWriter) {
            return new XMLFormatSupport(formatWriter);
        }

        @Override
        public void format(FormatWriter formatWriter) {
            FormatTokenPosition formatTokenPosition;
            XMLFormatSupport xMLFormatSupport = (XMLFormatSupport)this.createFormatSupport(formatWriter);
            if (xMLFormatSupport.isLineStart(formatTokenPosition = xMLFormatSupport.getFormatStartPosition()) && !xMLFormatSupport.isIndentOnly()) {
                while (formatTokenPosition.getToken() != null) {
                    if ((formatTokenPosition = xMLFormatSupport.removeLineEndWhitespace(formatTokenPosition)).getToken() == null) continue;
                    formatTokenPosition = xMLFormatSupport.getNextPosition(formatTokenPosition);
                }
            }
        }
    }
}

