/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.google.inject.Inject;
import com.mathworks.install.command.DotNetFramework;
import com.mathworks.install.command.NativeDotNet;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.MWNativeLibraryLoader;
import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.logging.AppLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;

final class DotNetFrameworkImpl
implements DotNetFramework {
    private final Set<String> fAddedZones = new HashSet<String>();
    private final Set<String> fAddedParentSubGroupPairs = new HashSet<String>();
    private final ProcessExecutor processExecutor;
    private final AppLogger appLogger;
    private final MWNativeLibraryLoader nativeLibraryLoader;
    private final NativeDotNet nativeDotNet;
    private final ExecutorService executorService;

    @Inject
    DotNetFrameworkImpl(ProcessExecutor processExecutor, AppLogger appLogger, MWNativeLibraryLoader mWNativeLibraryLoader, ExecutorService executorService) {
        this(processExecutor, appLogger, mWNativeLibraryLoader, new MyNativeDotNet(), executorService);
    }

    DotNetFrameworkImpl(ProcessExecutor processExecutor, AppLogger appLogger, MWNativeLibraryLoader mWNativeLibraryLoader, NativeDotNet nativeDotNet, ExecutorService executorService) {
        this.processExecutor = processExecutor;
        this.appLogger = appLogger;
        this.nativeLibraryLoader = mWNativeLibraryLoader;
        this.nativeDotNet = nativeDotNet;
        this.executorService = executorService;
    }

    @Override
    public boolean registerAssembly(String string, File file) {
        try {
            if (!this.isAssemblyFrameworkAvailable()) {
                return false;
            }
            this.loadNativeLibrary();
            this.appLogger.logMsg("Calling getDotNetFrameworkLocation");
            String string2 = this.nativeDotNet.getDotNetFrameworkLocation();
            boolean bl = DotNetFrameworkImpl.isFrameworkLocationValid(string2);
            this.appLogger.logMsg("getDotNetFrameworkLocation: " + string2);
            return bl && this.createAssemblyGroupIfNecessary(string2, string) && this.registerAssemblyIfNecessary(string2, string, file);
        }
        catch (Throwable throwable) {
            this.appLogger.logMsg("Error: " + throwable.getMessage());
            return false;
        }
    }

    @Override
    public boolean isAssemblyFrameworkAvailable() {
        boolean bl = false;
        try {
            if (this.nativeDotNet.isDotNetFrameWorkVersionFourInstalled() || this.nativeDotNet.isDotNetFrameworkVersionTwoInstalled()) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return bl;
    }

    @Override
    public boolean installAssembly(File file, File file2) {
        try {
            if (!this.isAssemblyFrameworkAvailable()) {
                return true;
            }
            ArrayList arrayList = new ArrayList();
            String string = new File(file2, "GACInstaller.exe").getAbsolutePath();
            Object[] objectArray = new String[]{string, file.getAbsolutePath()};
            this.appLogger.logMsg("Running " + Arrays.toString(objectArray));
            long l = 20000L;
            int n = this.processExecutor.runtimeExecWithTimeout(arrayList, (String[])objectArray, l, this.executorService);
            this.appLogger.logMsg("Status: " + n);
            return true;
        }
        catch (Throwable throwable) {
            this.appLogger.logMsg("Status: " + throwable.toString());
            return true;
        }
    }

    private void loadNativeLibrary() throws JNIException {
        this.nativeLibraryLoader.load("dotnetinst");
    }

    private static native String getDotNetFrameworkLocation();

    private static native boolean doesMWSecurityZoneExist(String var0);

    private static native boolean doesCodeSubGroupExist(String var0, String var1);

    private static native boolean isDotNetFrameworkVersionTwoInstalled();

    private static native boolean isDotNetFrameworkVersionFourInstalled();

    private static boolean isFrameworkLocationValid(String string) {
        return string != null && string.length() > 0;
    }

    private boolean registerAssemblyIfNecessary(String string, String string2, File file) throws IOException, TimeoutException {
        String string3 = file.getAbsolutePath();
        String string4 = DotNetFrameworkImpl.getAssemblyName(file);
        return this.assemblyAlreadyRegistered(string2, string4) || this.registerAssembly(string, string2, string3, string4);
    }

    private static String getAssemblyName(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private boolean registerAssembly(String string, String string2, String string3, String string4) throws IOException, TimeoutException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string5 = new File(string, "caspol.exe").toString();
        arrayList.add(string5);
        arrayList.add("-q");
        arrayList.add("-machine");
        arrayList.add("-addgroup");
        arrayList.add(string2);
        arrayList.add("-strong");
        arrayList.add("-file");
        arrayList.add(string3);
        arrayList.add("-noname");
        arrayList.add("-noversion");
        arrayList.add("FullTrust");
        arrayList.add("-name");
        arrayList.add(string4);
        String string6 = Arrays.toString(arrayList.toArray());
        this.appLogger.logMsg("running command: " + string6);
        int n = this.processExecutor.executeWithTimeout(arrayList.toArray(new String[arrayList.size()]));
        if (n == 0) {
            this.assemblyRegistered(string2, string4);
        }
        return n == 0;
    }

    private boolean createAssemblyGroupIfNecessary(String string, String string2) throws IOException, TimeoutException {
        return this.assemblyGroupAlreadyExists(string2) || this.createAssemblyGroup(string, string2);
    }

    private boolean createAssemblyGroup(String string, String string2) throws IOException, TimeoutException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = new File(string, "caspol.exe").toString();
        arrayList.add(string3);
        arrayList.add("-q");
        arrayList.add("-machine");
        arrayList.add("-addgroup");
        arrayList.add("1.");
        arrayList.add("-zone");
        arrayList.add("Intranet");
        arrayList.add("LocalIntranet");
        arrayList.add("-name");
        arrayList.add(string2);
        String string4 = Arrays.toString(arrayList.toArray());
        this.appLogger.logMsg("running command: " + string4);
        String[] stringArray = arrayList.toArray(new String[1]);
        int n = this.processExecutor.executeWithTimeout(stringArray);
        if (n == 0) {
            this.assemblyGroupCreated(string2);
            this.appLogger.logMsg(string2 + " group created");
        }
        return n == 0;
    }

    private boolean assemblyGroupAlreadyExists(String string) {
        if (this.fAddedZones.contains(string)) {
            return true;
        }
        this.appLogger.logMsg("Calling doesMWSecurityZoneExist for " + string);
        boolean bl = this.nativeDotNet.doesMWSecurityZoneExist(string);
        this.appLogger.logMsg("doesMWSecurityZoneExist: " + bl);
        return bl;
    }

    private boolean assemblyAlreadyRegistered(String string, String string2) {
        if (this.fAddedParentSubGroupPairs.contains(DotNetFrameworkImpl.getAssemblyGroupNamePair(string, string2))) {
            return true;
        }
        this.appLogger.logMsg("Calling doesCodeSubGroupExist for " + string2 + " in code group " + string);
        boolean bl = this.nativeDotNet.doesCodeSubGroupExist(string, string2);
        this.appLogger.logMsg("doesCodeSubGroupExist: " + bl);
        return bl;
    }

    private void assemblyGroupCreated(String string) {
        this.fAddedZones.add(string);
    }

    private void assemblyRegistered(String string, String string2) {
        this.fAddedParentSubGroupPairs.add(DotNetFrameworkImpl.getAssemblyGroupNamePair(string, string2));
    }

    private static String getAssemblyGroupNamePair(String string, String string2) {
        return string + "/" + string2;
    }

    private static class MyNativeDotNet
    implements NativeDotNet {
        private MyNativeDotNet() {
        }

        @Override
        public boolean isDotNetFrameworkVersionTwoInstalled() {
            return DotNetFrameworkImpl.isDotNetFrameworkVersionTwoInstalled();
        }

        @Override
        public String getDotNetFrameworkLocation() {
            return DotNetFrameworkImpl.getDotNetFrameworkLocation();
        }

        @Override
        public boolean doesMWSecurityZoneExist(String string) {
            return DotNetFrameworkImpl.doesMWSecurityZoneExist(string);
        }

        @Override
        public boolean doesCodeSubGroupExist(String string, String string2) {
            return DotNetFrameworkImpl.doesCodeSubGroupExist(string, string2);
        }

        @Override
        public boolean isDotNetFrameWorkVersionFourInstalled() {
            boolean bl = DotNetFrameworkImpl.isDotNetFrameworkVersionFourInstalled();
            return bl;
        }
    }
}

