/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.remoting;

import com.mathworks.toolbox.javabuilder.Disposable;
import com.mathworks.toolbox.javabuilder.remoting.RemoteFactory;
import com.mathworks.toolbox.javabuilder.remoting.RemoteProxy;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class BasicRemoteFactory
implements RemoteFactory {
    private Class<? extends Disposable> fLocalImplClass;
    private Class<? extends Remote> fRemoteInterfaceClass;
    private boolean fMarshalOutputs;
    private Remote fStub = null;

    public BasicRemoteFactory(Class<? extends Disposable> clazz, Class<? extends Remote> clazz2, boolean bl) {
        this.fLocalImplClass = clazz;
        this.fRemoteInterfaceClass = clazz2;
        this.fMarshalOutputs = bl;
    }

    public Remote getStub() throws RemoteException {
        if (null == this.fStub) {
            this.fStub = UnicastRemoteObject.exportObject((Remote)this, 0);
        }
        return this.fStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (null != this.fStub) {
            try {
                UnicastRemoteObject.unexportObject(this, false);
            }
            catch (NoSuchObjectException noSuchObjectException) {
            }
            finally {
                this.fStub = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow() {
        if (null != this.fStub) {
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
            }
            finally {
                this.fStub = null;
            }
        }
    }

    private Disposable constructNewImpl(Object ... objectArray) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        for (Constructor<?> constructor : this.fLocalImplClass.getConstructors()) {
            try {
                return (Disposable)constructor.newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public Remote newInstance(Object ... objectArray) throws RemoteException {
        try {
            Disposable disposable = this.constructNewImpl(objectArray);
            if (null == disposable) {
                throw new IllegalArgumentException("A constructor could not be found for the given argument list.");
            }
            return RemoteProxy.newProxyFor(disposable, this.fRemoteInterfaceClass, this.fMarshalOutputs);
        }
        catch (Throwable throwable) {
            throw new RemoteException("Error constucting object", throwable);
        }
    }
}

