/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import java.rmi.RemoteException;
import javax.net.SocketFactory;
import javax.security.auth.x500.X500Principal;
import net.jini.jeri.ssl.ConfidentialityStrength;
import net.jini.jeri.ssl.HttpsEndpoint;
import net.jini.jeri.ssl.SslEndpoint;
import net.jini.security.TrustVerifier;

public final class SslTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
        SocketFactory socketFactory;
        if (object == null || context == null) {
            throw new NullPointerException();
        }
        if (object instanceof ConfidentialityStrength || object instanceof X500Principal) {
            return true;
        }
        if (object instanceof SslEndpoint) {
            socketFactory = ((SslEndpoint)object).getSocketFactory();
        } else if (object instanceof HttpsEndpoint) {
            socketFactory = ((HttpsEndpoint)object).getSocketFactory();
        } else {
            return false;
        }
        return socketFactory == null || context.isTrustedObject(socketFactory);
    }
}

