/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil.licensefiles;

import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.InstallerUtilities;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.licensefiles.ActivationEntry;
import com.mathworks.instutil.licensefiles.LicenseFileLocation;
import com.mathworks.instutil.licensefiles.MarkerFileSearchResult;
import com.mathworks.instutil.licensefiles.OverrideableLicenseLocationFactory;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class MarkerUtility {
    protected static final String MARKER_FILE_NAME = "license_info.xml";
    protected static final String ACTIVATION_ENTRY = "ActivationEntry";
    protected static final String ID_NUMBER = "idnumber";
    protected static final String USER_NAME = "user";
    protected static final String MLROOT = "matlabroot";
    protected static final String HOSTNAME = "hostname";
    protected static final String LIC_MODE = "licmode";
    protected static final String ROOT = "root";
    protected static final String LIC_MODE_ONLINE = "online";
    protected static final String LIC_MODE_FILE = "file";
    protected static final String LICENSE_NUMBER = "";
    protected final String releaseString = InstutilResourceKeys.RELEASE.getBundleString();
    protected final String username;
    protected final String hostname;
    protected final String matlabRoot;
    protected final String licModeValue;
    protected final Properties properties;

    public MarkerUtility(String string, String string2, String string3, String string4, Properties properties) {
        this.username = string;
        this.matlabRoot = string2;
        this.hostname = string3;
        this.licModeValue = string4;
        this.properties = properties;
    }

    public void installMarkerFile() throws Exception {
        MarkerFileSearchResult markerFileSearchResult = this.checkIfMatchFound();
        String string = this.getMarkerFileLocation();
        if (markerFileSearchResult.isFound() || !this.licModeValue.equals(LIC_MODE_FILE)) {
            Document document;
            if (this.checkMarkerFileExists(string)) {
                document = this.readXMLFile(string);
                if (string.equals(markerFileSearchResult.getFileLocation())) {
                    Node node = this.findNodeInDocument(document);
                    this.editRequiredEntry(node);
                } else {
                    this.addElementToDocument(document);
                }
            } else {
                document = this.createDocument();
            }
            this.printToFile(document, string);
        }
    }

    private void editRequiredEntry(Node node) {
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals(LIC_MODE)) continue;
                nodeList.item(i).setTextContent(this.licModeValue);
                return;
            }
        }
    }

    private boolean checkMarkerFileExists(String string) {
        try {
            return new File(string + File.separatorChar + MARKER_FILE_NAME).isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Document readXMLFile(String string) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(string + File.separatorChar + MARKER_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printToFile(Document document, String string) throws IOException {
        OutputFormat outputFormat = new OutputFormat(document);
        outputFormat.setIndenting(true);
        FileOutputStream fileOutputStream = null;
        try {
            if (!new File(string).isDirectory()) {
                new FolderUtilsImpl().mkdirs(string);
            }
            fileOutputStream = new FileOutputStream(new File(string, MARKER_FILE_NAME));
            XMLSerializer xMLSerializer = new XMLSerializer(fileOutputStream, outputFormat);
            xMLSerializer.serialize(document);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
    }

    private MarkerFileSearchResult checkIfMatchFound() throws IOException, SAXException, ParserConfigurationException {
        String string = this.getUserProfileLocation().getLicenseLocation();
        MarkerFileSearchResult markerFileSearchResult = this.lookUpInLocation(string);
        if (!markerFileSearchResult.isFound()) {
            String string2 = this.getMatlabrootLocation().getLicenseLocation();
            markerFileSearchResult = this.lookUpInLocation(string2);
        }
        return markerFileSearchResult;
    }

    private MarkerFileSearchResult lookUpInLocation(String string) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        MarkerFileSearchResult markerFileSearchResult = new MarkerFileSearchResult();
        if (this.checkMarkerFileExists(string) && this.findNodeInDocument(document = this.readXMLFile(string)) != null) {
            markerFileSearchResult.setFound(true);
            markerFileSearchResult.setFileLocation(string);
        }
        return markerFileSearchResult;
    }

    private Node findNodeInDocument(Document document) {
        String string = FilenameUtils.normalizeNoEndSeparator((String)this.matlabRoot);
        NodeList nodeList = document.getElementsByTagName(ACTIVATION_ENTRY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() <= 0 || !namedNodeMap.getNamedItem(USER_NAME).getNodeValue().equals(this.username) || !namedNodeMap.getNamedItem(HOSTNAME).getNodeValue().equals(this.hostname) || !FilenameUtils.equalsOnSystem((String)namedNodeMap.getNamedItem(MLROOT).getNodeValue(), (String)string)) continue;
            return node;
        }
        return null;
    }

    private Element createActivationEntry(ActivationEntry activationEntry, Document document) {
        Element element = document.createElement(ACTIVATION_ENTRY);
        element.setAttribute(ID_NUMBER, String.valueOf(activationEntry.getIdNumber()));
        element.setAttribute(USER_NAME, activationEntry.getLicensedUser());
        element.setAttribute(MLROOT, activationEntry.getMatlabRoot());
        element.setAttribute(HOSTNAME, activationEntry.getHostname());
        Element element2 = document.createElement(LIC_MODE);
        Text text = document.createTextNode(activationEntry.getLicMode());
        element2.appendChild(text);
        element.appendChild(element2);
        return element;
    }

    private Document createDocument() throws ParserConfigurationException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(ROOT);
        document.appendChild(element);
        this.addElementToDocument(document, element);
        return document;
    }

    private void addElementToDocument(Document document) throws IOException {
        Element element = document.getDocumentElement();
        this.addElementToDocument(document, element);
    }

    private void addElementToDocument(Document document, Element element) throws IOException {
        ActivationEntry activationEntry = new ActivationEntry(1, this.username, new File(this.matlabRoot).getCanonicalPath(), this.hostname, this.licModeValue);
        Element element2 = this.createActivationEntry(activationEntry, document);
        element.appendChild(element2);
    }

    private String getMarkerFileLocation() {
        LicenseFileLocation licenseFileLocation = System.getProperty("user.name").trim().toLowerCase(Locale.getDefault()).equals(this.username) ? this.getUserProfileLocation() : this.getMatlabrootLocation();
        return licenseFileLocation.getLicenseLocation();
    }

    private LicenseFileLocation getMatlabrootLocation() {
        return new OverrideableLicenseLocationFactory(this.properties).getOtherUserLicenseLocation(this.matlabRoot, this.releaseString, LICENSE_NUMBER);
    }

    private LicenseFileLocation getUserProfileLocation() {
        return new OverrideableLicenseLocationFactory(this.properties).getUserLicenseLocation(InstallerUtilities.getLibDirPath(this.matlabRoot), this.releaseString, LICENSE_NUMBER);
    }
}

