/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import [Ljava.lang.String;;
import [Ljava.net.NetworkInterface;;
import [Lnet.jini.core.discovery.LookupLocator;;
import [Lnet.jini.core.entry.Entry;;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.AdminProxy;
import com.sun.jini.reggie.ClassResolver;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.EventLease;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Matches;
import com.sun.jini.reggie.ProxyVerifier;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarEvent;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import com.sun.jini.reggie.RenewResults;
import com.sun.jini.reggie.ServiceLease;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reggie.Util;
import com.sun.jini.reggie.UuidGenerator;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.TaskManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.Constants;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalledInstance;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class RegistrarImpl
implements Registrar,
ProxyAccessor,
ServerProxyTrust {
    private static final long MAX_LEASE = 31536000000000L;
    private static final long MAX_RENEW = 31536000000L;
    private static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final int DEFAULT_MULTICAST_TTL = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final int LOG_VERSION = 2;
    private static final String COMPONENT = "com.sun.jini.reggie";
    private static final Uuid myLeaseID = UuidFactory.create((long)0L, (long)0L);
    private static final Logger logger = Logger.getLogger("com.sun.jini.reggie");
    private static final Entry[] baseAttrs = new Entry[]{new ServiceInfo("Lookup", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.0_002", "", ""), new BasicServiceType("Lookup")};
    private static final EntryRep[] emptyAttrs = new EntryRep[0];
    private RegistrarProxy proxy;
    private Exporter serverExporter;
    private Registrar myRef;
    private ServiceID myServiceID;
    private ActivationID activationID;
    private ActivationSystem activationSystem;
    private LookupLocator myLocator;
    private LoginContext loginContext;
    private LifeCycle lifeCycle;
    private final HashMap serviceByID;
    private final TreeMap serviceByTime;
    private final HashMap serviceByType;
    private final HashMap serviceByAttr;
    private final HashMap serviceByEmptyAttr;
    private final ArrayList entryClasses;
    private final HashMap eventByID;
    private final TreeMap eventByTime;
    private final HashMap subEventByService;
    private final HashMap subEventByID;
    private UuidGenerator resourceIdGenerator;
    private UuidGenerator serviceIdGenerator;
    private long eventID;
    private final Random random;
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredListenerPreparer;
    private ProxyPreparer locatorPreparer;
    private ProxyPreparer recoveredLocatorPreparer;
    private final ArrayList newNotifies;
    private long maxServiceLease;
    private long maxEventLease;
    private long minSvcExpiration;
    private long minEventExpiration;
    private DiscoveryManagement discoer;
    private JoinManager joiner;
    private TaskManager tasker;
    private Thread serviceExpirer;
    private Thread eventExpirer;
    private UnicastThread unicaster;
    private Thread multicaster;
    private Thread announcer;
    private Thread snapshotter;
    private final ReadersWriter concurrentObj;
    private final Object serviceNotifier;
    private final Object eventNotifier;
    private final Object snapshotNotifier;
    private final ClassResolver resolver;
    private ServiceType objectServiceType;
    private ReliableLog log;
    private boolean inRecovery;
    private boolean recoveredSnapshot;
    private int logFileSize;
    private int persistenceSnapshotThreshold;
    private float persistenceSnapshotWeight;
    private long minMaxServiceLease;
    private long minMaxEventLease;
    private long minRenewalInterval;
    private int unicastPort;
    private String[] memberGroups;
    private String[] lookupGroups;
    private LookupLocator[] lookupLocators;
    private Entry[] lookupAttrs;
    private long multicastAnnouncementInterval;
    private NetworkInterface[] multicastInterfaces;
    private boolean multicastInterfacesSpecified;
    private int multicastInterfaceRetryInterval;
    private Discovery protocol2;
    private DiscoveryConstraints multicastRequestConstraints;
    private DiscoveryConstraints multicastAnnouncementConstraints;
    private DiscoveryConstraints unicastDiscoveryConstraints;
    private ClientSubjectChecker multicastRequestSubjectChecker;
    private ClientSubjectChecker unicastDiscoverySubjectChecker;
    static /* synthetic */ Class class$com$sun$jini$reggie$RegistrarImpl;

    RegistrarImpl(String[] stringArray, final ActivationID activationID, final boolean bl, final LifeCycle lifeCycle) throws Exception {
        block9: {
            this.serviceByID = new HashMap();
            this.serviceByTime = new TreeMap();
            this.serviceByType = new HashMap();
            this.serviceByAttr = new HashMap(23);
            this.serviceByEmptyAttr = new HashMap(11);
            this.entryClasses = new ArrayList();
            this.eventByID = new HashMap(11);
            this.eventByTime = new TreeMap();
            this.subEventByService = new HashMap(11);
            this.subEventByID = new HashMap(11);
            this.serviceIdGenerator = this.resourceIdGenerator = new UuidGenerator();
            this.eventID = 0L;
            this.random = new Random();
            this.recoveredListenerPreparer = this.listenerPreparer = new BasicProxyPreparer();
            this.locatorPreparer = this.listenerPreparer;
            this.recoveredLocatorPreparer = this.listenerPreparer;
            this.newNotifies = new ArrayList();
            this.minSvcExpiration = Long.MAX_VALUE;
            this.minEventExpiration = Long.MAX_VALUE;
            this.concurrentObj = new ReadersWriter();
            this.serviceNotifier = new Object();
            this.eventNotifier = new Object();
            this.snapshotNotifier = new Object();
            this.resolver = new ClassResolver();
            this.recoveredSnapshot = false;
            this.logFileSize = 0;
            this.persistenceSnapshotThreshold = 200;
            this.persistenceSnapshotWeight = 10.0f;
            this.minMaxServiceLease = 300000L;
            this.minMaxEventLease = 1800000L;
            this.minRenewalInterval = 100L;
            this.unicastPort = 0;
            this.memberGroups = new String[]{""};
            this.lookupGroups = DiscoveryGroupManagement.NO_GROUPS;
            this.lookupLocators = new LookupLocator[0];
            this.multicastAnnouncementInterval = 120000L;
            this.multicastInterfaceRetryInterval = 300000;
            if (activationID != null && !bl) {
                throw new IllegalArgumentException();
            }
            try {
                final Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray, (ClassLoader)this.getClass().getClassLoader());
                try {
                    this.loginContext = (LoginContext)Config.getNonNullEntry(configuration, COMPONENT, "loginContext", LoginContext.class);
                }
                catch (NoSuchEntryException noSuchEntryException) {
                    // empty catch block
                }
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        RegistrarImpl.this.init(configuration, activationID, bl, lifeCycle);
                        return null;
                    }
                };
                if (this.loginContext != null) {
                    this.loginContext.login();
                    try {
                        Subject.doAsPrivileged(this.loginContext.getSubject(), privilegedExceptionAction, null);
                        break block9;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getCause();
                    }
                }
                privilegedExceptionAction.run();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Reggie initialization failed", throwable);
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw (Error)throwable;
            }
        }
    }

    public Object getServiceProxy() throws RemoteException {
        return this.proxy;
    }

    public Object getProxy() {
        return this.myRef;
    }

    public TrustVerifier getProxyVerifier() {
        return new ProxyVerifier(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration register(Item item, long l) {
        this.concurrentObj.writeLock();
        try {
            ServiceRegistration serviceRegistration = this.registerDo(item, l);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered instance of {0} as {1}", new Object[]{item.serviceType.name, serviceRegistration.getServiceID()});
            }
            ServiceRegistration serviceRegistration2 = serviceRegistration;
            Object var7_5 = null;
            this.concurrentObj.writeUnlock();
            return serviceRegistration2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledWrapper lookup(Template template) {
        this.concurrentObj.readLock();
        try {
            MarshalledWrapper marshalledWrapper = this.lookupDo(template);
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            return marshalledWrapper;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matches lookup(Template template, int n) {
        this.concurrentObj.readLock();
        try {
            Matches matches = this.lookupDo(template, n);
            Object var5_4 = null;
            this.concurrentObj.readUnlock();
            return matches;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventRegistration notify(Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            EventRegistration eventRegistration = this.notifyDo(template, n, remoteEventListener, marshalledObject, l);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered event listener {0} as {1}", new Object[]{remoteEventListener, ((ReferentUuid)eventRegistration.getLease()).getReferentUuid()});
            }
            EventRegistration eventRegistration2 = eventRegistration;
            Object var10_8 = null;
            this.concurrentObj.writeUnlock();
            return eventRegistration2;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryClassBase[] getEntryClasses(Template template) {
        this.concurrentObj.readLock();
        try {
            EntryClassBase[] entryClassBaseArray = this.getEntryClassesDo(template);
            Object var4_3 = null;
            this.concurrentObj.readUnlock();
            return entryClassBaseArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getFieldValues(Template template, int n, int n2) {
        this.concurrentObj.readLock();
        try {
            Object[] objectArray = this.getFieldValuesDo(template, n, n2);
            Object var6_5 = null;
            this.concurrentObj.readUnlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceTypeBase[] getServiceTypes(Template template, String string) {
        this.concurrentObj.readLock();
        try {
            ServiceTypeBase[] serviceTypeBaseArray = this.getServiceTypesDo(template, string);
            Object var5_4 = null;
            this.concurrentObj.readUnlock();
            return serviceTypeBaseArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    public LookupLocator getLocator() {
        return this.myLocator;
    }

    public Object getAdmin() throws RemoteException {
        return AdminProxy.getInstance(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttributes(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.addAttributesDo(serviceID, uuid, entryRepArray);
            this.addLogRecord(new AttrsAddedLogObj(serviceID, uuid, entryRepArray));
            this.queueEvents();
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyAttributes(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.modifyAttributesDo(serviceID, uuid, entryRepArray, entryRepArray2);
            this.addLogRecord(new AttrsModifiedLogObj(serviceID, uuid, entryRepArray, entryRepArray2));
            this.queueEvents();
            Object var6_5 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        this.concurrentObj.writeLock();
        try {
            this.setAttributesDo(serviceID, uuid, entryRepArray);
            this.addLogRecord(new AttrsSetLogObj(serviceID, uuid, entryRepArray));
            this.queueEvents();
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServiceLease(ServiceID serviceID, Uuid uuid) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.cancelServiceLeaseDo(serviceID, uuid);
            this.addLogRecord(new ServiceLeaseCancelledLogObj(serviceID, uuid));
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{serviceID});
            }
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewServiceLease(ServiceID serviceID, Uuid uuid, long l) throws UnknownLeaseException {
        this.concurrentObj.priorityWriteLock();
        try {
            long l2 = this.renewServiceLeaseDo(serviceID, uuid, l);
            Object var8_5 = null;
            this.concurrentObj.writeUnlock();
            return l2;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelEventLease(long l, Uuid uuid) throws UnknownLeaseException {
        this.concurrentObj.writeLock();
        try {
            this.cancelEventLeaseDo(l, uuid);
            this.addLogRecord(new EventLeaseCancelledLogObj(l, uuid));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{uuid});
            }
            Object var5_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long renewEventLease(long l, Uuid uuid, long l2) throws UnknownLeaseException {
        this.concurrentObj.priorityWriteLock();
        try {
            long l3 = this.renewEventLeaseDo(l, uuid, l2);
            Object var9_5 = null;
            this.concurrentObj.writeUnlock();
            return l3;
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenewResults renewLeases(Object[] objectArray, Uuid[] uuidArray, long[] lArray) {
        this.concurrentObj.priorityWriteLock();
        try {
            RenewResults renewResults = this.renewLeasesDo(objectArray, uuidArray, lArray);
            Object var6_5 = null;
            this.concurrentObj.writeUnlock();
            return renewResults;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception[] cancelLeases(Object[] objectArray, Uuid[] uuidArray) {
        this.concurrentObj.writeLock();
        try {
            Exception[] exceptionArray = this.cancelLeasesDo(objectArray, uuidArray);
            this.addLogRecord(new LeasesCancelledLogObj(objectArray, uuidArray));
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (exceptionArray != null && exceptionArray[i] != null) continue;
                    if (objectArray[i] instanceof ServiceID) {
                        logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{objectArray[i]});
                        continue;
                    }
                    logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{uuidArray[i]});
                }
            }
            Exception[] exceptionArray2 = exceptionArray;
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
            return exceptionArray2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getLookupAttributes() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            Entry[] entryArray = this.lookupAttrs;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return entryArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupAttributes(Entry[] entryArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joiner.addAttributes(entryArray, true);
            this.lookupAttrs = this.joiner.getAttributes();
            EntryRep[] entryRepArray = EntryRep.toEntryRep(entryArray, true);
            try {
                this.addAttributesDo(this.myServiceID, myLeaseID, entryRepArray);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
            this.addLogRecord(new AttrsAddedLogObj(this.myServiceID, myLeaseID, entryRepArray));
            this.queueEvents();
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyLookupAttributes(Entry[] entryArray, Entry[] entryArray2) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.joiner.modifyAttributes(entryArray, entryArray2, true);
            this.lookupAttrs = this.joiner.getAttributes();
            EntryRep[] entryRepArray = EntryRep.toEntryRep(entryArray, false);
            EntryRep[] entryRepArray2 = EntryRep.toEntryRep(entryArray2, false);
            try {
                this.modifyAttributesDo(this.myServiceID, myLeaseID, entryRepArray, entryRepArray2);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
            this.addLogRecord(new AttrsModifiedLogObj(this.myServiceID, myLeaseID, entryRepArray, entryRepArray2));
            this.queueEvents();
            Object var7_6 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLookupGroups() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.lookupGroups;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)this.discoer);
            try {
                discoveryGroupManagement.addGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.lookupGroups = discoveryGroupManagement.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup groups {0}", new Object[]{Arrays.asList(stringArray)});
            }
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)this.discoer);
            discoveryGroupManagement.removeGroups(stringArray);
            this.lookupGroups = discoveryGroupManagement.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup groups {0}", new Object[]{Arrays.asList(stringArray)});
            }
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            DiscoveryGroupManagement discoveryGroupManagement = (DiscoveryGroupManagement)((Object)this.discoer);
            try {
                discoveryGroupManagement.setGroups(stringArray);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            this.lookupGroups = discoveryGroupManagement.getGroups();
            this.addLogRecord(new LookupGroupsChangedLogObj(this.lookupGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup groups {0}", new Object[]{stringArray != null ? Arrays.asList(stringArray) : null});
            }
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupLocator[] getLookupLocators() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            LookupLocator[] lookupLocatorArray = this.lookupLocators;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return lookupLocatorArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        lookupLocatorArray = RegistrarImpl.prepareLocators(lookupLocatorArray, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)this.discoer);
            discoveryLocatorManagement.addLocators(lookupLocatorArray);
            this.lookupLocators = discoveryLocatorManagement.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup locators {0}", new Object[]{Arrays.asList(lookupLocatorArray)});
            }
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        lookupLocatorArray = RegistrarImpl.prepareLocators(lookupLocatorArray, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)this.discoer);
            discoveryLocatorManagement.removeLocators(lookupLocatorArray);
            this.lookupLocators = discoveryLocatorManagement.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup locators {0}", new Object[]{Arrays.asList(lookupLocatorArray)});
            }
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupLocators(LookupLocator[] lookupLocatorArray) throws RemoteException {
        lookupLocatorArray = RegistrarImpl.prepareLocators(lookupLocatorArray, this.locatorPreparer, false);
        this.concurrentObj.writeLock();
        try {
            DiscoveryLocatorManagement discoveryLocatorManagement = (DiscoveryLocatorManagement)((Object)this.discoer);
            discoveryLocatorManagement.setLocators(lookupLocatorArray);
            this.lookupLocators = discoveryLocatorManagement.getLocators();
            this.addLogRecord(new LookupLocatorsChangedLogObj(this.lookupLocators));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup locators {0}", new Object[]{Arrays.asList(lookupLocatorArray)});
            }
            Object var4_3 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (RegistrarImpl.indexOf(this.memberGroups, stringArray[i]) >= 0) continue;
                this.memberGroups = (String[])RegistrarImpl.arrayAdd(this.memberGroups, stringArray[i]);
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added member groups {0}", new Object[]{Arrays.asList(stringArray)});
            }
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                int n = RegistrarImpl.indexOf(this.memberGroups, stringArray[i]);
                if (n < 0) continue;
                this.memberGroups = (String[])RegistrarImpl.arrayDel(this.memberGroups, n);
            }
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed member groups {0}", new Object[]{Arrays.asList(stringArray)});
            }
            Object var6_6 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMemberGroups() {
        this.concurrentObj.readLock();
        try {
            String[] stringArray = this.memberGroups;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemberGroups(String[] stringArray) throws RemoteException {
        this.concurrentObj.writeLock();
        try {
            this.memberGroups = (String[])RegistrarImpl.removeDups(stringArray);
            this.addLogRecord(new MemberGroupsChangedLogObj(this.memberGroups));
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set member groups {0}", new Object[]{Arrays.asList(stringArray)});
            }
            Object var5_4 = null;
            this.concurrentObj.writeUnlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnicastPort() throws RemoteException {
        this.concurrentObj.readLock();
        try {
            int n = this.unicastPort;
            Object var3_2 = null;
            this.concurrentObj.readUnlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.concurrentObj.readUnlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicastPort(int n) throws IOException, RemoteException {
        if (n == this.unicastPort) {
            return;
        }
        this.concurrentObj.writeLock();
        try {
            if (n == 0 && this.unicaster.port == 4160 || n == this.unicaster.port) {
                this.unicastPort = n;
                this.addLogRecord(new UnicastPortSetLogObj(n));
                Object var6_2 = null;
                this.concurrentObj.writeUnlock();
                return;
            }
            UnicastThread unicastThread = new UnicastThread(n);
            this.unicaster.interrupt();
            try {
                this.unicaster.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.unicaster = unicastThread;
            this.unicaster.start();
            this.unicastPort = n;
            this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator(this.myLocator.getHost(), this.unicaster.port, null) : new LookupLocator(this.myLocator.getHost(), this.unicaster.port);
            Thread thread = this.announcer;
            synchronized (thread) {
                this.announcer.notify();
            }
            this.addLogRecord(new UnicastPortSetLogObj(n));
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "changed unicast discovery port to {0}", new Object[]{new Integer(this.unicaster.port)});
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.concurrentObj.writeUnlock();
            throw throwable;
        }
        Object var6_3 = null;
        this.concurrentObj.writeUnlock();
    }

    public void destroy() {
        logger.info("starting Reggie shutdown");
        new DestroyThread().start();
    }

    private static Object[] arrayAdd(Object[] objectArray, Object object) {
        int n = objectArray.length;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n + 1);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        objectArray2[n] = object;
        return objectArray2;
    }

    private static Object[] arrayDel(Object[] objectArray, int n) {
        int n2 = objectArray.length - 1;
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        System.arraycopy(objectArray, n + 1, objectArray2, n, n2 - n);
        return objectArray2;
    }

    private static int indexOf(Object[] objectArray, Object object) {
        return RegistrarImpl.indexOf(objectArray, objectArray.length, object);
    }

    private static int indexOf(Object[] objectArray, int n, Object object) {
        for (int i = 0; i < n; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean overlap(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (RegistrarImpl.indexOf(objectArray2, objectArray[n]) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean allNull(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (objectArray[n] == null) continue;
            return false;
        }
        return true;
    }

    private static Object[] removeDups(Object[] objectArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            if (RegistrarImpl.indexOf(objectArray, n, objectArray[n]) < 0) continue;
            objectArray = RegistrarImpl.arrayDel(objectArray, n);
        }
        return objectArray;
    }

    private static EntryRep[] deleteSet(Item item, int n) {
        item.attributeSets = (EntryRep[])RegistrarImpl.arrayDel(item.attributeSets, n);
        return item.attributeSets;
    }

    private static Item copyItem(Item item) {
        item = (Item)item.clone();
        item.serviceType = null;
        item.codebase = null;
        EntryRep[] entryRepArray = item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            entryRepArray[n].eclass = entryRepArray[n].eclass.getReplacement();
        }
        return item;
    }

    private static EntryClass getDefiningClass(EntryClass entryClass, int n) {
        EntryClass entryClass2;
        while ((entryClass2 = entryClass.getSuperclass()).getNumFields() > n) {
            entryClass = entryClass2;
        }
        return entryClass;
    }

    private static void addConcreteClass(ServiceType serviceType, ServiceType serviceType2) {
        Object[] objectArray = serviceType.getConcreteClasses();
        if (RegistrarImpl.indexOf(objectArray, serviceType2) >= 0) {
            return;
        }
        serviceType.setConcreteClasses((ServiceType[])RegistrarImpl.arrayAdd(objectArray, serviceType2));
        ServiceType[] serviceTypeArray = serviceType.getInterfaces();
        int n = serviceTypeArray.length;
        while (--n >= 0) {
            RegistrarImpl.addConcreteClass(serviceTypeArray[n], serviceType2);
        }
        ServiceType serviceType3 = serviceType.getSuperclass();
        if (serviceType3 != null) {
            RegistrarImpl.addConcreteClass(serviceType3, serviceType2);
        }
    }

    private static void deleteConcreteClass(ServiceType serviceType, ServiceType serviceType2) {
        Object[] objectArray = serviceType.getConcreteClasses();
        int n = RegistrarImpl.indexOf(objectArray, serviceType2);
        if (n >= 0) {
            serviceType.setConcreteClasses((ServiceType[])RegistrarImpl.arrayDel(objectArray, n));
            ServiceType[] serviceTypeArray = serviceType.getInterfaces();
            int n2 = serviceTypeArray.length;
            while (--n2 >= 0) {
                RegistrarImpl.deleteConcreteClass(serviceTypeArray[n2], serviceType2);
            }
            ServiceType serviceType3 = serviceType.getSuperclass();
            if (serviceType3 != null) {
                RegistrarImpl.deleteConcreteClass(serviceType3, serviceType2);
            }
        }
    }

    private static boolean matchItem(Template template, Item item) {
        return (template.serviceID == null || template.serviceID.equals((Object)item.serviceID)) && RegistrarImpl.matchType(template.serviceTypes, item.serviceType) && RegistrarImpl.matchAttributes(template, item);
    }

    private static boolean matchType(ServiceType[] serviceTypeArray, ServiceType serviceType) {
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                if (serviceTypeArray[n].isAssignableFrom(serviceType)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchEntry(EntryRep entryRep, EntryRep entryRep2) {
        if (!entryRep.eclass.isAssignableFrom(entryRep2.eclass) || entryRep.fields.length > entryRep2.fields.length) {
            return false;
        }
        int n = entryRep.fields.length;
        while (--n >= 0) {
            if (entryRep.fields[n] == null || entryRep.fields[n].equals(entryRep2.fields[n])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAttributes(Template template, Item item) {
        EntryRep[] entryRepArray = template.attributeSetTemplates;
        if (entryRepArray != null) {
            EntryRep[] entryRepArray2 = item.attributeSets;
            int n = entryRepArray.length;
            block0: while (--n >= 0) {
                EntryRep entryRep = entryRepArray[n];
                int n2 = entryRepArray2.length;
                while (--n2 >= 0) {
                    if (!RegistrarImpl.matchEntry(entryRep, entryRepArray2[n2])) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean attrMatch(EntryRep[] entryRepArray, EntryRep entryRep) {
        boolean bl = true;
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                EntryRep entryRep2 = entryRepArray[n];
                if (!RegistrarImpl.matchEntry(entryRep2, entryRep)) continue;
                if (entryRep2.eclass.isAssignableFrom(entryRep.eclass) && !entryRep2.eclass.equals(entryRep.eclass)) {
                    return true;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static boolean hasAttr(SvcReg svcReg, EntryClass entryClass, int n, Object object) {
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n2 = entryRepArray.length;
        while (--n2 >= 0) {
            EntryRep entryRep = entryRepArray[n2];
            if (!entryClass.isAssignableFrom(entryRep.eclass) || (object != null || entryRep.fields[n] != null) && (object == null || !object.equals(entryRep.fields[n]))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEmptyAttr(SvcReg svcReg, EntryClass entryClass) {
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            if (!entryClass.equals(entryRepArray[n].eclass)) continue;
            return true;
        }
        return false;
    }

    private static void addTypes(ArrayList arrayList, ArrayList arrayList2, ServiceType[] serviceTypeArray, String string, ServiceType serviceType, String string2) {
        if (arrayList.contains(serviceType)) {
            return;
        }
        if (serviceTypeArray != null) {
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                if (!serviceType.isAssignableFrom(serviceTypeArray[n])) continue;
                return;
            }
        }
        if (string == null || serviceType.getName().startsWith(string)) {
            arrayList.add(serviceType);
            arrayList2.add(string2);
            return;
        }
        ServiceType[] serviceTypeArray2 = serviceType.getInterfaces();
        int n = serviceTypeArray2.length;
        while (--n >= 0) {
            RegistrarImpl.addTypes(arrayList, arrayList2, serviceTypeArray, string, serviceTypeArray2[n], string2);
        }
        ServiceType serviceType2 = serviceType.getSuperclass();
        if (serviceType2 != null) {
            RegistrarImpl.addTypes(arrayList, arrayList2, serviceTypeArray, string, serviceType2, string2);
        }
    }

    private static long limitDuration(long l, long l2) {
        if (l == -1L || l > l2) {
            l = l2;
        } else if (l < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return l;
    }

    private static void marshalLocators(LookupLocator[] lookupLocatorArray, ObjectOutputStream objectOutputStream) throws IOException {
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            objectOutputStream.writeObject(new MarshalledInstance((Object)lookupLocatorArray[i]));
        }
        objectOutputStream.writeObject(null);
    }

    private static LookupLocator[] unmarshalLocators(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        MarshalledInstance marshalledInstance;
        ArrayList<LookupLocator> arrayList = new ArrayList<LookupLocator>();
        while ((marshalledInstance = (MarshalledInstance)objectInputStream.readObject()) != null) {
            try {
                arrayList.add((LookupLocator)marshalledInstance.get(false));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error && ThrowableConstants.retryable(throwable) == 2) {
                    throw (Error)throwable;
                }
                logger.log(Level.WARNING, "failed to recover lookup locator", throwable);
            }
        }
        return arrayList.toArray(new LookupLocator[arrayList.size()]);
    }

    private static LookupLocator[] prepareLocators(LookupLocator[] lookupLocatorArray, ProxyPreparer proxyPreparer, boolean bl) throws RemoteException {
        ArrayList<LookupLocator> arrayList = new ArrayList<LookupLocator>();
        for (int i = 0; i < lookupLocatorArray.length; ++i) {
            try {
                arrayList.add((LookupLocator)proxyPreparer.prepareProxy((Object)lookupLocatorArray[i]));
                continue;
            }
            catch (Exception exception) {
                if (!bl) {
                    if (exception instanceof RemoteException) {
                        throw (RemoteException)exception;
                    }
                    throw (RuntimeException)exception;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                RegistrarImpl.logThrow(Level.WARNING, (class$com$sun$jini$reggie$RegistrarImpl == null ? RegistrarImpl.class$("com.sun.jini.reggie.RegistrarImpl") : class$com$sun$jini$reggie$RegistrarImpl).getName(), "prepareLocators", "failed to prepare lookup locator {0}", new Object[]{lookupLocatorArray[i]}, exception);
            }
        }
        return arrayList.toArray(new LookupLocator[arrayList.size()]);
    }

    private static void logThrow(Level level, String string, String string2, String string3, Object[] objectArray, Throwable throwable) {
        java.util.logging.LogRecord logRecord = new java.util.logging.LogRecord(level, string3);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(throwable);
        logger.log(logRecord);
    }

    private void addService(SvcReg svcReg) {
        this.serviceByID.put(svcReg.item.serviceID, svcReg);
        this.serviceByTime.put(svcReg, svcReg);
        ServiceType serviceType = svcReg.item.serviceType;
        ArrayList<SvcReg> arrayList = (ArrayList<SvcReg>)this.serviceByType.get(serviceType);
        if (arrayList == null) {
            arrayList = new ArrayList<SvcReg>(3);
            this.serviceByType.put(serviceType, arrayList);
            RegistrarImpl.addConcreteClass(serviceType, serviceType);
        }
        arrayList.add(svcReg);
        EntryRep[] entryRepArray = svcReg.item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            this.addAttrs(svcReg, entryRepArray[n]);
        }
        this.computeMaxLeases();
    }

    private void deleteService(SvcReg svcReg, long l) {
        Item item = svcReg.item;
        this.generateEvents(item, null, l);
        this.serviceByID.remove(item.serviceID);
        this.serviceByTime.remove(svcReg);
        ServiceType serviceType = item.serviceType;
        ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceType);
        arrayList.remove(arrayList.indexOf(svcReg));
        if (arrayList.isEmpty()) {
            this.serviceByType.remove(serviceType);
            RegistrarImpl.deleteConcreteClass(serviceType, serviceType);
        }
        EntryRep[] entryRepArray = item.attributeSets;
        int n = entryRepArray.length;
        while (--n >= 0) {
            this.deleteAttrs(svcReg, entryRepArray[n], false);
        }
        this.computeMaxLeases();
    }

    private void addEvent(EventReg eventReg) {
        Object object;
        if (eventReg.listener == null) {
            return;
        }
        EntryRep[] entryRepArray = eventReg.tmpl.attributeSetTemplates;
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                object = entryRepArray[n].eclass;
                object.setNumTemplates(object.getNumTemplates() + 1);
            }
        }
        Long l = new Long(eventReg.eventID);
        this.eventByID.put(l, eventReg);
        this.eventByTime.put(eventReg, eventReg);
        if (eventReg.tmpl.serviceID != null) {
            object = this.subEventByService.get(eventReg.tmpl.serviceID);
            object = object == null ? eventReg : (object instanceof EventReg ? new EventReg[]{(EventReg)object, eventReg} : RegistrarImpl.arrayAdd((EventReg[])object, eventReg));
            this.subEventByService.put(eventReg.tmpl.serviceID, object);
        } else {
            this.subEventByID.put(l, eventReg);
        }
        this.computeMaxLeases();
    }

    private void deleteEvent(EventReg eventReg) {
        Object object;
        EntryRep[] entryRepArray = eventReg.tmpl.attributeSetTemplates;
        if (entryRepArray != null) {
            int n = entryRepArray.length;
            while (--n >= 0) {
                object = entryRepArray[n].eclass;
                object.setNumTemplates(object.getNumTemplates() - 1);
            }
        }
        Long l = new Long(eventReg.eventID);
        this.eventByID.remove(l);
        this.eventByTime.remove(eventReg);
        if (eventReg.tmpl.serviceID != null) {
            object = this.subEventByService.get(eventReg.tmpl.serviceID);
            if (object == eventReg) {
                this.subEventByService.remove(eventReg.tmpl.serviceID);
            } else {
                Object[] objectArray = (EventReg[])object;
                object = (objectArray = RegistrarImpl.arrayDel(objectArray, RegistrarImpl.indexOf(objectArray, eventReg))).length == 1 ? objectArray[0] : objectArray;
                this.subEventByService.put(eventReg.tmpl.serviceID, object);
            }
        } else {
            this.subEventByID.remove(l);
        }
        this.computeMaxLeases();
    }

    private void addAttrs(SvcReg svcReg, EntryRep entryRep) {
        EntryClass entryClass = entryRep.eclass;
        this.addInstance(entryClass);
        Object[] objectArray = entryRep.fields;
        if (objectArray.length > 0) {
            int n = objectArray.length;
            while (--n >= 0) {
                entryClass = RegistrarImpl.getDefiningClass(entryClass, n);
                this.addAttr(svcReg, entryClass, n, objectArray[n]);
            }
            return;
        }
        ArrayList<SvcReg> arrayList = (ArrayList<SvcReg>)this.serviceByEmptyAttr.get(entryClass);
        if (arrayList == null) {
            arrayList = new ArrayList<SvcReg>(2);
            arrayList.add(svcReg);
            this.serviceByEmptyAttr.put(entryClass, arrayList);
        } else if (!arrayList.contains(svcReg)) {
            arrayList.add(svcReg);
        }
    }

    private void deleteAttrs(SvcReg svcReg, EntryRep entryRep, boolean bl) {
        EntryClass entryClass = entryRep.eclass;
        this.deleteInstance(entryClass);
        Object[] objectArray = entryRep.fields;
        if (objectArray.length == 0) {
            ArrayList arrayList = (ArrayList)this.serviceByEmptyAttr.get(entryClass);
            if (arrayList == null || bl && RegistrarImpl.hasEmptyAttr(svcReg, entryClass)) {
                return;
            }
            int n = arrayList.indexOf(svcReg);
            if (n >= 0) {
                arrayList.remove(n);
                if (arrayList.isEmpty()) {
                    this.serviceByEmptyAttr.remove(entryClass);
                }
            }
            return;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            int n2;
            Object object;
            HashMap hashMap;
            ArrayList arrayList;
            Object[] objectArray2 = (HashMap[])this.serviceByAttr.get(entryClass = RegistrarImpl.getDefiningClass(entryClass, n));
            if (objectArray2 == null || objectArray2[n] == null || bl && RegistrarImpl.hasAttr(svcReg, entryClass, n, objectArray[n]) || (arrayList = (ArrayList)(hashMap = objectArray2[n]).get(object = objectArray[n])) == null || (n2 = arrayList.indexOf(svcReg)) < 0) continue;
            arrayList.remove(n2);
            if (!arrayList.isEmpty()) continue;
            hashMap.remove(object);
            if (!hashMap.isEmpty()) continue;
            objectArray2[n] = null;
            if (!RegistrarImpl.allNull(objectArray2)) continue;
            this.serviceByAttr.remove(entryClass);
        }
    }

    private void updateAttrs(SvcReg svcReg, EntryRep entryRep, Object[] objectArray) {
        EntryClass entryClass = entryRep.eclass;
        int n = objectArray.length;
        while (--n >= 0) {
            Object object = entryRep.fields[n];
            Object object2 = objectArray[n];
            if (object2 == null || object2.equals(object)) continue;
            entryClass = RegistrarImpl.getDefiningClass(entryClass, n);
            HashMap hashMap = this.addAttr(svcReg, entryClass, n, object2);
            entryRep.fields[n] = object2;
            if (RegistrarImpl.hasAttr(svcReg, entryClass, n, object)) continue;
            ArrayList arrayList = (ArrayList)hashMap.get(object);
            arrayList.remove(arrayList.indexOf(svcReg));
            if (!arrayList.isEmpty()) continue;
            hashMap.remove(object);
        }
    }

    private HashMap addAttr(SvcReg svcReg, EntryClass entryClass, int n, Object object) {
        ArrayList<SvcReg> arrayList;
        HashMap hashMap;
        HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(entryClass);
        if (hashMapArray == null) {
            hashMapArray = new HashMap[entryClass.getNumFields()];
            this.serviceByAttr.put(entryClass, hashMapArray);
        }
        if ((hashMap = hashMapArray[n]) == null) {
            hashMapArray[n] = hashMap = new HashMap(11);
        }
        if ((arrayList = (ArrayList<SvcReg>)hashMap.get(object)) == null) {
            arrayList = new ArrayList<SvcReg>(3);
            hashMap.put(object, arrayList);
        } else if (arrayList.contains(svcReg)) {
            return hashMap;
        }
        arrayList.add(svcReg);
        return hashMap;
    }

    private void addInstance(EntryClass entryClass) {
        int n = entryClass.getNumInstances();
        if (n == 0) {
            this.entryClasses.add(entryClass);
        }
        entryClass.setNumInstances(n + 1);
    }

    private void deleteInstance(EntryClass entryClass) {
        int n = entryClass.getNumInstances() - 1;
        if (n == 0) {
            this.entryClasses.remove(this.entryClasses.indexOf(entryClass));
        }
        entryClass.setNumInstances(n);
    }

    private ItemIter matchingItems(Template template) {
        if (template.serviceID != null) {
            return new IDItemIter(template);
        }
        if (!RegistrarImpl.isEmpty(template.serviceTypes)) {
            return new TypeItemIter(template);
        }
        Object[] objectArray = template.attributeSetTemplates;
        if (RegistrarImpl.isEmpty(objectArray)) {
            return new AllItemIter();
        }
        int n = objectArray.length;
        while (--n >= 0) {
            Object[] objectArray2 = ((EntryRep)objectArray[n]).fields;
            if (objectArray2.length == 0) {
                EntryClass entryClass = this.getEmptyEntryClass(((EntryRep)objectArray[n]).eclass);
                if (entryClass == null) continue;
                return new EmptyAttrItemIter(template, entryClass);
            }
            int n2 = objectArray2.length;
            while (--n2 >= 0) {
                if (objectArray2[n2] == null) continue;
                return new AttrItemIter(template, n, n2);
            }
        }
        return new ClassItemIter(template);
    }

    private EntryClass getEmptyEntryClass(EntryClass entryClass) {
        EntryClass entryClass2 = null;
        int n = this.entryClasses.size();
        while (--n >= 0) {
            EntryClass entryClass3 = (EntryClass)this.entryClasses.get(n);
            if (!entryClass.isAssignableFrom(entryClass3)) continue;
            if (entryClass3.getNumFields() != 0 || entryClass2 != null) {
                return null;
            }
            entryClass2 = entryClass3;
        }
        return entryClass2;
    }

    private ServiceType[] matchingConcreteClasses(ServiceType[] serviceTypeArray) {
        if (RegistrarImpl.isEmpty(serviceTypeArray)) {
            return this.objectServiceType.getConcreteClasses();
        }
        Object[] objectArray = serviceTypeArray[0].getConcreteClasses();
        if (serviceTypeArray.length > 1) {
            int n = objectArray.length;
            while (--n >= 0) {
                if (RegistrarImpl.matchType(serviceTypeArray, objectArray[n])) continue;
                objectArray = (ServiceType[])RegistrarImpl.arrayDel(objectArray, n);
            }
        }
        return objectArray;
    }

    private String pickCodebase(EntryClass entryClass, long l) throws ClassNotFoundException {
        if (entryClass.getNumFields() == 0) {
            return this.pickCodebase(entryClass, (ArrayList)this.serviceByEmptyAttr.get(entryClass), l);
        }
        int n = entryClass.getNumFields() - 1;
        HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(RegistrarImpl.getDefiningClass(entryClass, n));
        Iterator iterator = hashMapArray[n].values().iterator();
        while (iterator.hasNext()) {
            try {
                return this.pickCodebase(entryClass, (ArrayList)iterator.next(), l);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(EntryClass entryClass, ArrayList arrayList, long l) throws ClassNotFoundException {
        int n = arrayList.size();
        while (--n >= 0) {
            SvcReg svcReg = (SvcReg)arrayList.get(n);
            if (svcReg.leaseExpiration <= l) continue;
            EntryRep[] entryRepArray = svcReg.item.attributeSets;
            int n2 = entryRepArray.length;
            while (--n2 >= 0) {
                if (!entryClass.equals(entryRepArray[n2].eclass)) continue;
                return entryRepArray[n2].codebase;
            }
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(ServiceType serviceType, long l) throws ClassNotFoundException {
        ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceType);
        int n = arrayList.size();
        while (--n >= 0) {
            SvcReg svcReg = (SvcReg)arrayList.get(n);
            if (svcReg.leaseExpiration <= l) continue;
            return svcReg.item.codebase;
        }
        throw new ClassNotFoundException();
    }

    private void computeMaxLeases() {
        if (this.inRecovery) {
            return;
        }
        this.maxServiceLease = Math.max(this.minMaxServiceLease, this.minRenewalInterval * ((long)this.serviceByID.size() + (long)this.eventByID.size() * this.minMaxServiceLease / this.minMaxEventLease));
        this.maxEventLease = Math.max(this.minMaxEventLease, this.maxServiceLease * this.minMaxEventLease / this.minMaxServiceLease);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void respond(Socket socket) {
        block9: {
            socket.setSoTimeout(this.unicastDiscoveryConstraints.getUnicastSocketTimeout(60000));
            int n = new DataInputStream(socket.getInputStream()).readInt();
            this.unicastDiscoveryConstraints.checkProtocolVersion(n);
            this.getDiscovery(n).handleUnicastDiscovery(new UnicastResponse(this.myLocator.getHost(), this.myLocator.getPort(), this.memberGroups, (ServiceRegistrar)this.proxy), socket, this.unicastDiscoveryConstraints.getUnfulfilledConstraints(), this.unicastDiscoverySubjectChecker, (Collection)Collections.EMPTY_LIST);
            Object var4_4 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {
                logger.log(Levels.HANDLED, "exception closing socket", iOException);
            }
            break block9;
            {
                catch (Exception exception) {
                    if (logger.isLoggable(Levels.HANDLED)) {
                        RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "respond", "exception handling unicast discovery from {0}:{1}", new Object[]{socket.getInetAddress(), new Integer(socket.getPort())}, exception);
                    }
                    Object var4_5 = null;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        logger.log(Levels.HANDLED, "exception closing socket", iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    logger.log(Levels.HANDLED, "exception closing socket", iOException);
                }
                throw throwable;
            }
        }
    }

    private Discovery getDiscovery(int n) throws DiscoveryProtocolException {
        switch (n) {
            case 1: {
                return Discovery.getProtocol1();
            }
            case 2: {
                return this.protocol2;
            }
        }
        throw new DiscoveryProtocolException("unsupported protocol version: " + n);
    }

    private void closeRequestSockets(ArrayList arrayList) {
        int n = arrayList.size();
        while (--n >= 0) {
            Object e = arrayList.get(n);
            if (!(e instanceof SocketTask)) continue;
            try {
                ((SocketTask)e).socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void init(Configuration configuration, ActivationID activationID, boolean bl, LifeCycle lifeCycle) throws IOException, ConfigurationException, ActivationException {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        BasicMethodConstraints basicMethodConstraints;
        this.lifeCycle = lifeCycle;
        if (bl) {
            this.persistenceSnapshotThreshold = Config.getIntEntry(configuration, COMPONENT, "persistenceSnapshotThreshold", this.persistenceSnapshotThreshold, 0, Integer.MAX_VALUE);
            basicMethodConstraints = (String)configuration.getEntry(COMPONENT, "persistenceDirectory", String.class);
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "recoveredListenerPreparer", ProxyPreparer.class, this.recoveredListenerPreparer);
            this.recoveredLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "recoveredLocatorPreparer", ProxyPreparer.class, this.recoveredLocatorPreparer);
            this.persistenceSnapshotWeight = Config.getFloatEntry(configuration, COMPONENT, "persistenceSnapshotWeight", this.persistenceSnapshotWeight, 0.0f, Float.MAX_VALUE);
            this.log = new ReliableLog((String)basicMethodConstraints, new LocalLogHandler());
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "using persistence directory {0}", new Object[]{basicMethodConstraints});
            }
            this.inRecovery = true;
            this.resolver.setInRecovery(true);
            this.log.recover();
            this.resolver.setInRecovery(false);
            this.inRecovery = false;
        } else {
            this.log = null;
        }
        if (activationID != null) {
            basicMethodConstraints = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            object3 = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.activationID = (ActivationID)basicMethodConstraints.prepareProxy((Object)activationID);
            this.activationSystem = (ActivationSystem)object3.prepareProxy((Object)ActivationGroup.getSystem());
            this.serverExporter = (Exporter)Config.getNonNullEntry(configuration, COMPONENT, "serverExporter", Exporter.class, new ActivationExporter(this.activationID, (Exporter)new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory())), this.activationID);
        } else {
            this.activationID = null;
            this.activationSystem = null;
            this.serverExporter = (Exporter)Config.getNonNullEntry(configuration, COMPONENT, "serverExporter", Exporter.class, new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory()));
        }
        if (!this.recoveredSnapshot) {
            basicMethodConstraints = (BasicMethodConstraints)configuration.getEntry(COMPONENT, "initialLookupAttributes", Entry;.class, (Object)new Entry[0]);
            this.lookupGroups = (String[])configuration.getEntry(COMPONENT, "initialLookupGroups", String;.class, (Object)this.lookupGroups);
            this.lookupLocators = (LookupLocator[])configuration.getEntry(COMPONENT, "initialLookupLocators", LookupLocator;.class, (Object)this.lookupLocators);
            this.memberGroups = (String[])configuration.getEntry(COMPONENT, "initialMemberGroups", String;.class, (Object)this.memberGroups);
            if (this.memberGroups == null) {
                throw new ConfigurationException("member groups cannot be ALL_GROUPS (null)");
            }
            this.memberGroups = (String[])RegistrarImpl.removeDups(this.memberGroups);
            this.unicastPort = Config.getIntEntry(configuration, COMPONENT, "initialUnicastDiscoveryPort", this.unicastPort, 0, 65535);
            if (basicMethodConstraints != null && ((BasicMethodConstraints)basicMethodConstraints).length > 0) {
                object3 = new ArrayList<Entry>(Arrays.asList(baseAttrs));
                object3.addAll(Arrays.asList(basicMethodConstraints));
                this.lookupAttrs = object3.toArray(new Entry[object3.size()]);
            } else {
                this.lookupAttrs = baseAttrs;
            }
        }
        if ((basicMethodConstraints = (MethodConstraints)configuration.getEntry(COMPONENT, "discoveryConstraints", MethodConstraints.class, null)) == null) {
            basicMethodConstraints = new BasicMethodConstraints(InvocationConstraints.EMPTY);
        }
        try {
            this.discoer = (DiscoveryManagement)configuration.getEntry(COMPONENT, "discoveryManager", DiscoveryManagement.class);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            this.discoer = new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, null, null, configuration);
        }
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "listenerPreparer", ProxyPreparer.class, this.listenerPreparer);
        this.locatorPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, COMPONENT, "locatorPreparer", ProxyPreparer.class, this.locatorPreparer);
        this.minMaxEventLease = Config.getLongEntry(configuration, COMPONENT, "minMaxEventLease", this.minMaxEventLease, 1L, 31536000000000L);
        this.minMaxServiceLease = Config.getLongEntry(configuration, COMPONENT, "minMaxServiceLease", this.minMaxServiceLease, 1L, 31536000000000L);
        this.minRenewalInterval = Config.getLongEntry(configuration, COMPONENT, "minRenewalInterval", this.minRenewalInterval, 0L, 31536000000L);
        this.multicastAnnouncementInterval = Config.getLongEntry(configuration, COMPONENT, "multicastAnnouncementInterval", this.multicastAnnouncementInterval, 1L, Long.MAX_VALUE);
        this.multicastInterfaceRetryInterval = Config.getIntEntry(configuration, COMPONENT, "multicastInterfaceRetryInterval", this.multicastInterfaceRetryInterval, 1, Integer.MAX_VALUE);
        try {
            this.multicastInterfaces = (NetworkInterface[])configuration.getEntry(COMPONENT, "multicastInterfaces", NetworkInterface;.class);
            this.multicastInterfacesSpecified = true;
        }
        catch (NoSuchEntryException noSuchEntryException) {
            object2 = NetworkInterface.getNetworkInterfaces();
            serializable = object2 != null ? Collections.list(object2) : Collections.EMPTY_LIST;
            this.multicastInterfaces = serializable.toArray(new NetworkInterface[serializable.size()]);
            this.multicastInterfacesSpecified = false;
        }
        if (this.multicastInterfaces == null) {
            logger.config("using system default interface for multicast");
        } else if (this.multicastInterfaces.length == 0) {
            if (this.multicastInterfacesSpecified) {
                logger.config("multicast disabled");
            } else {
                logger.severe("no network interfaces detected");
            }
        } else if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "multicasting on interfaces {0}", new Object[]{Arrays.asList(this.multicastInterfaces)});
        }
        try {
            this.multicastRequestSubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry(configuration, COMPONENT, "multicastRequestSubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            // empty catch block
        }
        this.resourceIdGenerator = (UuidGenerator)Config.getNonNullEntry(configuration, COMPONENT, "resourceIdGenerator", UuidGenerator.class, this.resourceIdGenerator);
        this.serviceIdGenerator = (UuidGenerator)Config.getNonNullEntry(configuration, COMPONENT, "serviceIdGenerator", UuidGenerator.class, this.serviceIdGenerator);
        this.tasker = (TaskManager)Config.getNonNullEntry(configuration, COMPONENT, "taskManager", TaskManager.class, new TaskManager(10, 15000L, 1.0f));
        try {
            object3 = (String)Config.getNonNullEntry(configuration, COMPONENT, "unicastDiscoveryHost", String.class);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            object3 = InetAddress.getLocalHost().getCanonicalHostName();
        }
        try {
            this.unicastDiscoverySubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry(configuration, COMPONENT, "unicastDiscoverySubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException noSuchEntryException) {
            // empty catch block
        }
        this.objectServiceType = this.resolver.resolve(new ServiceType(Object.class, null, null));
        this.computeMaxLeases();
        this.protocol2 = Discovery.getProtocol2(null);
        this.multicastRequestConstraints = DiscoveryConstraints.process((InvocationConstraints)basicMethodConstraints.getConstraints(DiscoveryConstraints.multicastRequestMethod));
        this.multicastAnnouncementConstraints = DiscoveryConstraints.process((InvocationConstraints)basicMethodConstraints.getConstraints(DiscoveryConstraints.multicastAnnouncementMethod));
        this.unicastDiscoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)basicMethodConstraints.getConstraints(DiscoveryConstraints.unicastDiscoveryMethod));
        this.serviceExpirer = new ServiceExpireThread();
        this.eventExpirer = new EventExpireThread();
        this.unicaster = new UnicastThread(this.unicastPort);
        this.multicaster = new MulticastThread();
        this.announcer = new AnnounceThread();
        this.snapshotter = new SnapshotThread();
        if (this.myServiceID == null) {
            this.myServiceID = this.newServiceID();
        }
        this.myRef = (Registrar)this.serverExporter.export((Remote)this);
        this.proxy = RegistrarProxy.getInstance(this.myRef, this.myServiceID);
        ConstrainableLookupLocator constrainableLookupLocator = this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator((String)object3, this.unicaster.port, null) : new LookupLocator((String)object3, this.unicaster.port);
        if (this.serviceByID.isEmpty()) {
            object2 = new Item(new ServiceItem(this.myServiceID, (Object)this.proxy, this.lookupAttrs));
            this.resolver.resolve((Item)object2);
            serializable = new SvcReg((Item)object2, myLeaseID, Long.MAX_VALUE);
            this.addService((SvcReg)serializable);
        } else {
            object2 = (SvcReg)this.serviceByID.get(this.myServiceID);
            this.lookupAttrs = EntryRep.toEntry(((SvcReg)object2).item.attributeSets);
            int n = this.lookupAttrs.length;
            while (--n >= 0) {
                if (this.lookupAttrs[n] != null) continue;
                this.lookupAttrs = (Entry[])RegistrarImpl.arrayDel(this.lookupAttrs, n);
                object = ((SvcReg)object2).item.attributeSets[n];
                RegistrarImpl.deleteSet(((SvcReg)object2).item, n);
                this.deleteAttrs((SvcReg)object2, (EntryRep)object, true);
            }
        }
        if (this.log != null) {
            this.log.snapshot();
        }
        try {
            object2 = (DiscoveryGroupManagement)((Object)this.discoer);
            String[] stringArray = object2.getGroups();
            if (stringArray == null || stringArray.length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no groups");
            }
            object = (DiscoveryLocatorManagement)((Object)this.discoer);
            if (object.getLocators().length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no locators");
            }
            object2.setGroups(this.lookupGroups);
            object.setLocators(this.lookupLocators);
        }
        catch (ClassCastException classCastException) {
            throw new ConfigurationException(null, (Throwable)classCastException);
        }
        this.joiner = new JoinManager((Object)this.proxy, this.lookupAttrs, this.myServiceID, this.discoer, null, configuration);
        this.serviceExpirer.start();
        this.eventExpirer.start();
        this.unicaster.start();
        this.multicaster.start();
        this.announcer.start();
        this.snapshotter.start();
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "started Reggie: {0}, {1}, {2}", new Object[]{this.myServiceID, Arrays.asList(this.memberGroups), this.myLocator});
        }
    }

    private ServiceRegistration registerDo(Item item, long l) {
        Serializable serializable;
        this.resolver.resolve(item);
        if (item.service == null) {
            throw new NullPointerException("null service");
        }
        if (this.myServiceID.equals((Object)item.serviceID)) {
            throw new IllegalArgumentException("reserved service id");
        }
        item.attributeSets = item.attributeSets == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(item.attributeSets);
        l = RegistrarImpl.limitDuration(l, this.maxServiceLease);
        long l2 = System.currentTimeMillis();
        if (item.serviceID == null) {
            serializable = (ArrayList)this.serviceByType.get(item.serviceType);
            if (serializable != null) {
                int n = ((ArrayList)serializable).size();
                while (--n >= 0) {
                    SvcReg svcReg = (SvcReg)((ArrayList)serializable).get(n);
                    if (!item.service.equals(svcReg.item.service)) continue;
                    item.serviceID = svcReg.item.serviceID;
                    this.deleteService(svcReg, l2);
                    break;
                }
            }
            if (item.serviceID == null) {
                item.serviceID = this.newServiceID();
            }
        } else {
            serializable = (SvcReg)this.serviceByID.get(item.serviceID);
            if (serializable != null) {
                this.deleteService((SvcReg)serializable, l2);
            }
        }
        Util.checkRegistrantServiceID(item.serviceID, logger, Level.FINE);
        serializable = new SvcReg(item, this.newLeaseID(), l2 + l);
        this.addService((SvcReg)serializable);
        this.generateEvents(null, item, l2);
        this.addLogRecord(new SvcRegisteredLogObj((SvcReg)serializable));
        this.queueEvents();
        if (((SvcReg)serializable).leaseExpiration < this.minSvcExpiration) {
            this.minSvcExpiration = ((SvcReg)serializable).leaseExpiration;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return Registration.getInstance(this.myRef, ServiceLease.getInstance(this.myRef, this.myServiceID, item.serviceID, ((SvcReg)serializable).leaseID, ((SvcReg)serializable).leaseExpiration));
    }

    private MarshalledWrapper lookupDo(Template template) {
        this.resolver.resolve(template);
        if (RegistrarImpl.isEmpty(template.serviceTypes) || template.serviceID != null) {
            ItemIter itemIter = this.matchingItems(template);
            if (itemIter.hasNext()) {
                return itemIter.next().service;
            }
            return null;
        }
        ServiceType[] serviceTypeArray = this.matchingConcreteClasses(template.serviceTypes);
        long l = System.currentTimeMillis();
        int n = serviceTypeArray.length;
        if (n == 0) {
            return null;
        }
        int n2 = Math.abs(this.random.nextInt()) % n;
        for (int i = 0; i < n; ++i) {
            ArrayList arrayList = (ArrayList)this.serviceByType.get(serviceTypeArray[(i + n2) % n]);
            int n3 = arrayList.size();
            int n4 = Math.abs(this.random.nextInt()) % n3;
            for (int j = 0; j < n3; ++j) {
                SvcReg svcReg = (SvcReg)arrayList.get((j + n4) % n3);
                if (svcReg.leaseExpiration <= l || !RegistrarImpl.matchAttributes(template, svcReg.item)) continue;
                return svcReg.item.service;
            }
        }
        return null;
    }

    private Matches lookupDo(Template template, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative maxMatches");
        }
        this.resolver.resolve(template);
        int n2 = 0;
        ArrayList<Item> arrayList = null;
        ItemIter itemIter = this.matchingItems(template);
        if (n > 0 || itemIter.dupsPossible) {
            arrayList = new ArrayList<Item>();
        }
        if (itemIter.dupsPossible) {
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                if (arrayList.contains(item)) continue;
                arrayList.add(item);
            }
            n2 = arrayList.size();
            if (n > 0) {
                int n3 = arrayList.size();
                while (--n3 >= n) {
                    arrayList.remove(n3);
                }
                n3 = arrayList.size();
                while (--n3 >= 0) {
                    arrayList.set(n3, RegistrarImpl.copyItem((Item)arrayList.get(n3)));
                }
            } else {
                arrayList = null;
            }
        } else {
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                ++n2;
                if (--n < 0) continue;
                arrayList.add(RegistrarImpl.copyItem(item));
            }
        }
        return new Matches(arrayList, n2);
    }

    private EventRegistration notifyDo(Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        this.resolver.resolve(template);
        if (n == 0 || n != (n & 7)) {
            throw new IllegalArgumentException("invalid transitions");
        }
        if (remoteEventListener == null) {
            throw new NullPointerException("listener");
        }
        remoteEventListener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)remoteEventListener);
        l = RegistrarImpl.limitDuration(l, this.maxEventLease);
        long l2 = System.currentTimeMillis();
        EventReg eventReg = new EventReg(this.eventID, this.newLeaseID(), template, n, remoteEventListener, marshalledObject, l2 + l);
        ++this.eventID;
        this.addEvent(eventReg);
        this.addLogRecord(new EventRegisteredLogObj(eventReg));
        if (eventReg.leaseExpiration < this.minEventExpiration) {
            this.minEventExpiration = eventReg.leaseExpiration;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return new EventRegistration(eventReg.eventID, (Object)this.proxy, (Lease)EventLease.getInstance(this.myRef, this.myServiceID, eventReg.eventID, eventReg.leaseID, eventReg.leaseExpiration), eventReg.seqNo);
    }

    private EntryClassBase[] getEntryClassesDo(Template template) {
        Serializable serializable;
        int n;
        this.resolver.resolve(template);
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.serviceTypes) && RegistrarImpl.isEmpty(template.attributeSetTemplates)) {
            long l = System.currentTimeMillis();
            n = this.entryClasses.size();
            while (--n >= 0) {
                serializable = (EntryClass)this.entryClasses.get(n);
                try {
                    arrayList2.add(this.pickCodebase((EntryClass)serializable, l));
                    arrayList.add(serializable);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                n = item.attributeSets.length;
                while (--n >= 0) {
                    serializable = item.attributeSets[n];
                    if (!RegistrarImpl.attrMatch(template.attributeSetTemplates, serializable) || arrayList.contains(serializable.eclass)) continue;
                    arrayList.add(serializable.eclass);
                    arrayList2.add(serializable.codebase);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        EntryClassBase[] entryClassBaseArray = new EntryClassBase[arrayList.size()];
        int n2 = entryClassBaseArray.length;
        while (--n2 >= 0) {
            entryClassBaseArray[n2] = new EntryClassBase(((EntryClass)arrayList.get(n2)).getReplacement(), (String)arrayList2.get(n2));
        }
        return entryClassBaseArray;
    }

    private Object[] getFieldValuesDo(Template template, int n, int n2) {
        this.resolver.resolve(template);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        EntryRep entryRep = template.attributeSetTemplates[n];
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.serviceTypes) && template.attributeSetTemplates.length == 1 && RegistrarImpl.allNull(entryRep.fields)) {
            long l = System.currentTimeMillis();
            EntryClass entryClass = RegistrarImpl.getDefiningClass(entryRep.eclass, n2);
            boolean bl = !entryClass.equals(entryRep.eclass);
            HashMap[] hashMapArray = (HashMap[])this.serviceByAttr.get(entryClass);
            if (hashMapArray != null && hashMapArray[n2] != null) {
                Iterator iterator = hashMapArray[n2].entrySet().iterator();
                block0: while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ArrayList arrayList2 = (ArrayList)entry.getValue();
                    Object k = entry.getKey();
                    int n3 = arrayList2.size();
                    while (--n3 >= 0) {
                        SvcReg svcReg = (SvcReg)arrayList2.get(n3);
                        if (svcReg.leaseExpiration <= l || bl && !RegistrarImpl.hasAttr(svcReg, entryRep.eclass, n2, k)) continue;
                        arrayList.add(k);
                        continue block0;
                    }
                }
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                int n4 = item.attributeSets.length;
                while (--n4 >= 0) {
                    Object object;
                    if (!RegistrarImpl.matchEntry(entryRep, item.attributeSets[n4]) || arrayList.contains(object = item.attributeSets[n4].fields[n2])) continue;
                    arrayList.add(object);
                }
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray();
    }

    private ServiceTypeBase[] getServiceTypesDo(Template template, String string) {
        this.resolver.resolve(template);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        if (template.serviceID == null && RegistrarImpl.isEmpty(template.attributeSetTemplates)) {
            long l = System.currentTimeMillis();
            ServiceType[] serviceTypeArray = this.matchingConcreteClasses(template.serviceTypes);
            int n = serviceTypeArray.length;
            while (--n >= 0) {
                try {
                    RegistrarImpl.addTypes(arrayList, arrayList2, template.serviceTypes, string, serviceTypeArray[n], this.pickCodebase(serviceTypeArray[n], l));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ItemIter itemIter = this.matchingItems(template);
            while (itemIter.hasNext()) {
                Item item = itemIter.next();
                RegistrarImpl.addTypes(arrayList, arrayList2, template.serviceTypes, string, item.serviceType, item.codebase);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        ServiceTypeBase[] serviceTypeBaseArray = new ServiceTypeBase[arrayList.size()];
        int n = serviceTypeBaseArray.length;
        while (--n >= 0) {
            serviceTypeBaseArray[n] = new ServiceTypeBase(((ServiceType)arrayList.get(n)).getReplacement(), (String)arrayList2.get(n));
        }
        return serviceTypeBaseArray;
    }

    private void addAttributesDo(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) throws UnknownLeaseException {
        EntryRep[] entryRepArray2;
        int n;
        this.resolver.resolve(entryRepArray);
        long l = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid) || svcReg.leaseExpiration <= l) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        Object[] objectArray = svcReg.item.attributeSets;
        int n2 = 0;
        for (n = 0; n < entryRepArray.length; ++n) {
            entryRepArray2 = entryRepArray[n];
            if (RegistrarImpl.indexOf(objectArray, entryRepArray2) >= 0 || RegistrarImpl.indexOf(entryRepArray, n, entryRepArray2) >= 0) continue;
            entryRepArray[n2++] = entryRepArray2;
            this.addAttrs(svcReg, (EntryRep)entryRepArray2);
        }
        if (n2 > 0) {
            n = objectArray.length;
            entryRepArray2 = new EntryRep[n + n2];
            System.arraycopy(objectArray, 0, entryRepArray2, 0, n);
            System.arraycopy(entryRepArray, 0, entryRepArray2, n, n2);
            svcReg.item.attributeSets = entryRepArray2;
        }
        this.generateEvents(item, svcReg.item, l);
    }

    private void modifyAttributesDo(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) throws UnknownLeaseException {
        EntryRep entryRep;
        this.resolver.resolve(entryRepArray);
        this.resolver.resolveWithNulls(entryRepArray2);
        if (entryRepArray.length != entryRepArray2.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int n = entryRepArray2.length;
        while (--n >= 0) {
            if (entryRepArray2[n] == null || entryRepArray2[n].eclass.isAssignableFrom(entryRepArray[n].eclass)) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        long l = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid) || svcReg.leaseExpiration <= l) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        EntryRep[] entryRepArray3 = item.attributeSets;
        Object[] objectArray = svcReg.item.attributeSets;
        int n2 = entryRepArray3.length;
        block1: while (--n2 >= 0) {
            entryRep = entryRepArray3[n2];
            EntryRep entryRep2 = objectArray[n2];
            int n3 = entryRepArray.length;
            while (--n3 >= 0) {
                if (!RegistrarImpl.matchEntry(entryRepArray[n3], entryRep)) continue;
                EntryRep entryRep3 = entryRepArray2[n3];
                if (entryRep3 == null) {
                    objectArray = RegistrarImpl.deleteSet(svcReg.item, n2);
                    this.deleteAttrs(svcReg, entryRep2, true);
                    continue block1;
                }
                this.updateAttrs(svcReg, entryRep2, entryRep3.fields);
            }
        }
        n2 = objectArray.length;
        while (--n2 >= 0) {
            entryRep = objectArray[n2];
            if (RegistrarImpl.indexOf(objectArray, n2, entryRep) < 0) continue;
            objectArray = RegistrarImpl.deleteSet(svcReg.item, n2);
            this.deleteInstance(entryRep.eclass);
        }
        svcReg.item.attributeSets = objectArray;
        this.generateEvents(item, svcReg.item, l);
    }

    private void setAttributesDo(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) throws UnknownLeaseException {
        this.resolver.resolve(entryRepArray);
        entryRepArray = entryRepArray == null ? emptyAttrs : (EntryRep[])RegistrarImpl.removeDups(entryRepArray);
        long l = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid) || svcReg.leaseExpiration <= l) {
            throw new UnknownLeaseException();
        }
        Item item = (Item)svcReg.item.clone();
        EntryRep[] entryRepArray2 = svcReg.item.attributeSets;
        int n = entryRepArray2.length;
        while (--n >= 0) {
            this.deleteAttrs(svcReg, entryRepArray2[n], false);
        }
        svcReg.item.attributeSets = entryRepArray;
        n = entryRepArray.length;
        while (--n >= 0) {
            this.addAttrs(svcReg, entryRepArray[n]);
        }
        this.generateEvents(item, svcReg.item, l);
    }

    private void cancelServiceLeaseDo(ServiceID serviceID, Uuid uuid) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        long l = System.currentTimeMillis();
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid) || svcReg.leaseExpiration <= l) {
            throw new UnknownLeaseException();
        }
        this.deleteService(svcReg, l);
        if (svcReg.leaseExpiration == this.minSvcExpiration) {
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
    }

    private long renewServiceLeaseDo(ServiceID serviceID, Uuid uuid, long l) throws UnknownLeaseException {
        long l2 = System.currentTimeMillis();
        long l3 = this.renewServiceLeaseInt(serviceID, uuid, l, l2);
        this.addLogRecord(new ServiceLeaseRenewedLogObj(serviceID, uuid, l3));
        return l3 - l2;
    }

    private long renewServiceLeaseInt(ServiceID serviceID, Uuid uuid, long l, long l2) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        if (l == -1L) {
            l = this.maxServiceLease;
        } else if (l < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid) || svcReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        if (l > this.maxServiceLease && l > svcReg.leaseExpiration - l2) {
            l = Math.max(svcReg.leaseExpiration - l2, this.maxServiceLease);
        }
        long l3 = l2 + l;
        this.serviceByTime.remove(svcReg);
        svcReg.leaseExpiration = l3;
        this.serviceByTime.put(svcReg, svcReg);
        if (l3 < this.minSvcExpiration) {
            this.minSvcExpiration = l3;
            this.concurrentObj.waiterNotify(this.serviceNotifier);
        }
        return l3;
    }

    private void renewServiceLeaseAbs(ServiceID serviceID, Uuid uuid, long l) {
        SvcReg svcReg = (SvcReg)this.serviceByID.get(serviceID);
        if (svcReg == null || !svcReg.leaseID.equals((Object)uuid)) {
            return;
        }
        this.serviceByTime.remove(svcReg);
        svcReg.leaseExpiration = l;
        this.serviceByTime.put(svcReg, svcReg);
    }

    private void cancelEventLeaseDo(long l, Uuid uuid) throws UnknownLeaseException {
        long l2 = System.currentTimeMillis();
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || eventReg.leaseExpiration <= l2) {
            throw new UnknownLeaseException();
        }
        this.deleteEvent(eventReg);
        if (eventReg.leaseExpiration == this.minEventExpiration) {
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
    }

    private long renewEventLeaseDo(long l, Uuid uuid, long l2) throws UnknownLeaseException {
        long l3 = System.currentTimeMillis();
        long l4 = this.renewEventLeaseInt(l, uuid, l2, l3);
        this.addLogRecord(new EventLeaseRenewedLogObj(l, uuid, l4));
        return l4 - l3;
    }

    private long renewEventLeaseInt(long l, Uuid uuid, long l2, long l3) throws UnknownLeaseException {
        if (l2 == -1L) {
            l2 = this.maxEventLease;
        } else if (l2 < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || !eventReg.leaseID.equals((Object)uuid) || eventReg.leaseExpiration <= l3) {
            throw new UnknownLeaseException();
        }
        if (l2 > this.maxEventLease && l2 > eventReg.leaseExpiration - l3) {
            l2 = Math.max(eventReg.leaseExpiration - l3, this.maxEventLease);
        }
        long l4 = l3 + l2;
        this.eventByTime.remove(eventReg);
        eventReg.leaseExpiration = l4;
        this.eventByTime.put(eventReg, eventReg);
        if (l4 < this.minEventExpiration) {
            this.minEventExpiration = l4;
            this.concurrentObj.waiterNotify(this.eventNotifier);
        }
        return l4;
    }

    private void renewEventLeaseAbs(long l, Uuid uuid, long l2) {
        EventReg eventReg = (EventReg)this.eventByID.get(new Long(l));
        if (eventReg == null || !eventReg.leaseID.equals((Object)uuid)) {
            return;
        }
        this.eventByTime.remove(eventReg);
        eventReg.leaseExpiration = l2;
        this.eventByTime.put(eventReg, eventReg);
    }

    private RenewResults renewLeasesDo(Object[] objectArray, Uuid[] uuidArray, long[] lArray) {
        int n;
        long l = System.currentTimeMillis();
        Exception[] exceptionArray = null;
        for (n = 0; n < objectArray.length; ++n) {
            Object object = objectArray[n];
            try {
                if (object instanceof ServiceID) {
                    lArray[n] = this.renewServiceLeaseInt((ServiceID)object, uuidArray[n], lArray[n], l);
                    continue;
                }
                lArray[n] = this.renewEventLeaseInt((Long)object, uuidArray[n], lArray[n], l);
                continue;
            }
            catch (Exception exception) {
                lArray[n] = -1L;
                exceptionArray = exceptionArray == null ? new Exception[]{exception} : (Exception[])RegistrarImpl.arrayAdd(exceptionArray, exception);
            }
        }
        this.addLogRecord(new LeasesRenewedLogObj(objectArray, uuidArray, lArray));
        n = objectArray.length;
        while (--n >= 0) {
            if (lArray[n] < 0L) continue;
            int n2 = n;
            lArray[n2] = lArray[n2] - l;
        }
        return new RenewResults(lArray, exceptionArray);
    }

    private void renewLeasesAbs(Object[] objectArray, Uuid[] uuidArray, long[] lArray) {
        int n = objectArray.length;
        while (--n >= 0) {
            long l = lArray[n];
            if (l < 0L) continue;
            Object object = objectArray[n];
            if (object instanceof ServiceID) {
                this.renewServiceLeaseAbs((ServiceID)object, uuidArray[n], l);
                continue;
            }
            this.renewEventLeaseAbs((Long)object, uuidArray[n], l);
        }
    }

    private Exception[] cancelLeasesDo(Object[] objectArray, Uuid[] uuidArray) {
        Exception[] exceptionArray = null;
        int n = objectArray.length;
        while (--n >= 0) {
            Object object = objectArray[n];
            try {
                if (object instanceof ServiceID) {
                    this.cancelServiceLeaseDo((ServiceID)object, uuidArray[n]);
                    continue;
                }
                this.cancelEventLeaseDo((Long)object, uuidArray[n]);
            }
            catch (Exception exception) {
                if (exceptionArray == null) {
                    exceptionArray = new Exception[objectArray.length];
                }
                exceptionArray[n] = exception;
            }
        }
        return exceptionArray;
    }

    private void generateEvents(Item item, Item item2, long l) {
        Object object;
        if (this.inRecovery) {
            return;
        }
        ServiceID serviceID = item != null ? item.serviceID : item2.serviceID;
        Object v = this.subEventByService.get(serviceID);
        if (v instanceof EventReg) {
            this.generateEvent((EventReg)v, item, item2, serviceID, l);
        } else if (v != null) {
            object = (EventReg[])v;
            int n = ((EventReg[])object).length;
            while (--n >= 0) {
                this.generateEvent((EventReg)object[n], item, item2, serviceID, l);
            }
        }
        object = this.subEventByID.values().iterator();
        while (object.hasNext()) {
            this.generateEvent((EventReg)object.next(), item, item2, serviceID, l);
        }
    }

    private void generateEvent(EventReg eventReg, Item item, Item item2, ServiceID serviceID, long l) {
        if (eventReg.leaseExpiration <= l) {
            return;
        }
        if ((eventReg.transitions & 2) != 0 && (item == null || !RegistrarImpl.matchItem(eventReg.tmpl, item)) && item2 != null && RegistrarImpl.matchItem(eventReg.tmpl, item2)) {
            this.pendingEvent(eventReg, serviceID, item2, 2);
        } else if ((eventReg.transitions & 1) != 0 && item != null && RegistrarImpl.matchItem(eventReg.tmpl, item) && (item2 == null || !RegistrarImpl.matchItem(eventReg.tmpl, item2))) {
            this.pendingEvent(eventReg, serviceID, item2, 1);
        } else if ((eventReg.transitions & 4) != 0 && item != null && RegistrarImpl.matchItem(eventReg.tmpl, item) && item2 != null && RegistrarImpl.matchItem(eventReg.tmpl, item2)) {
            this.pendingEvent(eventReg, serviceID, item2, 4);
        }
    }

    private void pendingEvent(EventReg eventReg, ServiceID serviceID, Item item, int n) {
        if (item != null) {
            item = RegistrarImpl.copyItem(item);
        }
        this.newNotifies.add(new EventTask(eventReg, serviceID, item, n));
    }

    private void queueEvents() {
        if (!this.newNotifies.isEmpty()) {
            this.tasker.addAll(this.newNotifies);
            this.newNotifies.clear();
        }
    }

    private ServiceID newServiceID() {
        Uuid uuid = this.serviceIdGenerator.generate();
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private Uuid newLeaseID() {
        return this.resourceIdGenerator.generate();
    }

    private void takeSnapshot(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeUTF(this.getClass().getName());
        objectOutputStream.writeInt(2);
        objectOutputStream.writeObject(this.myServiceID);
        objectOutputStream.writeLong(this.eventID);
        objectOutputStream.writeInt(this.unicastPort);
        objectOutputStream.writeObject(this.memberGroups);
        objectOutputStream.writeObject(this.lookupGroups);
        RegistrarImpl.marshalLocators(this.lookupLocators, objectOutputStream);
        Iterator iterator = this.serviceByID.values().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
        objectOutputStream.writeObject(null);
        iterator = this.eventByID.values().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.flush();
        logger.finer("wrote state snapshot");
    }

    private void recoverSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException {
        EventReg eventReg;
        SvcReg svcReg;
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        if (!this.getClass().getName().equals(objectInputStream.readUTF())) {
            throw new IOException("log from wrong implementation");
        }
        if (objectInputStream.readInt() != 2) {
            throw new IOException("wrong log format version");
        }
        this.myServiceID = (ServiceID)objectInputStream.readObject();
        this.eventID = objectInputStream.readLong();
        this.unicastPort = objectInputStream.readInt();
        this.memberGroups = (String[])objectInputStream.readObject();
        this.lookupGroups = (String[])objectInputStream.readObject();
        this.lookupLocators = RegistrarImpl.prepareLocators(RegistrarImpl.unmarshalLocators(objectInputStream), this.recoveredLocatorPreparer, true);
        while ((svcReg = (SvcReg)objectInputStream.readObject()) != null) {
            this.resolver.resolve(svcReg.item);
            this.addService(svcReg);
        }
        while ((eventReg = (EventReg)objectInputStream.readObject()) != null) {
            this.resolver.resolve(eventReg.tmpl);
            eventReg.prepareListener(this.recoveredListenerPreparer);
            eventReg.seqNo += Integer.MAX_VALUE;
            this.addEvent(eventReg);
        }
        this.recoveredSnapshot = true;
        logger.finer("recovered state from snapshot");
    }

    private void addLogRecord(LogRecord logRecord) {
        block5: {
            if (this.log == null) {
                return;
            }
            try {
                int n;
                this.log.update(logRecord, true);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "wrote log record {0}", new Object[]{logRecord});
                }
                if (++this.logFileSize >= this.persistenceSnapshotThreshold && (float)this.logFileSize >= this.persistenceSnapshotWeight * (float)(n = this.serviceByID.size() + this.eventByID.size())) {
                    this.concurrentObj.waiterNotify(this.snapshotNotifier);
                }
            }
            catch (Exception exception) {
                if (Thread.currentThread().isInterrupted()) break block5;
                logger.log(Level.WARNING, "log update failed", exception);
            }
        }
    }

    static /* synthetic */ String[] access$2002(RegistrarImpl registrarImpl, String[] stringArray) {
        registrarImpl.lookupGroups = stringArray;
        return stringArray;
    }

    static /* synthetic */ LookupLocator[] access$2102(RegistrarImpl registrarImpl, LookupLocator[] lookupLocatorArray) {
        registrarImpl.lookupLocators = lookupLocatorArray;
        return lookupLocatorArray;
    }

    static /* synthetic */ String[] access$2602(RegistrarImpl registrarImpl, String[] stringArray) {
        registrarImpl.memberGroups = stringArray;
        return stringArray;
    }

    static /* synthetic */ Object access$7700(RegistrarImpl registrarImpl) {
        return registrarImpl.snapshotNotifier;
    }

    static /* synthetic */ int access$7802(RegistrarImpl registrarImpl, int n) {
        registrarImpl.logFileSize = n;
        return registrarImpl.logFileSize;
    }

    private class SnapshotThread
    extends Thread {
        private boolean interrupted;

        public SnapshotThread() {
            super("snapshot thread");
            this.interrupted = false;
            this.setDaemon(true);
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class AnnounceThread
    extends Thread {
        private final MulticastSocket socket;

        public AnnounceThread() throws IOException {
            super("discovery announcement");
            this.setDaemon(true);
            if (RegistrarImpl.this.multicastInterfaces == null || RegistrarImpl.this.multicastInterfaces.length > 0) {
                this.socket = new MulticastSocket();
                this.socket.setTimeToLive(RegistrarImpl.this.multicastAnnouncementConstraints.getMulticastTimeToLive(15));
            } else {
                this.socket = null;
            }
        }

        public synchronized void run() {
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                return;
            }
            try {
                while (!this.isInterrupted() && this.announce(RegistrarImpl.this.memberGroups)) {
                    this.wait(RegistrarImpl.this.multicastAnnouncementInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (RegistrarImpl.this.memberGroups.length > 0) {
                this.announce(new String[0]);
            }
            this.socket.close();
        }

        private boolean announce(String[] stringArray) {
            Discovery discovery;
            ArrayList<DatagramPacket> arrayList = new ArrayList<DatagramPacket>();
            try {
                discovery = RegistrarImpl.this.getDiscovery(RegistrarImpl.this.multicastAnnouncementConstraints.chooseProtocolVersion());
            }
            catch (DiscoveryProtocolException discoveryProtocolException) {
                throw new AssertionError((Object)discoveryProtocolException);
            }
            EncodeIterator encodeIterator = discovery.encodeMulticastAnnouncement(new MulticastAnnouncement(System.currentTimeMillis(), RegistrarImpl.this.myLocator.getHost(), RegistrarImpl.this.myLocator.getPort(), stringArray, RegistrarImpl.this.myServiceID), RegistrarImpl.this.multicastAnnouncementConstraints.getMulticastMaxPacketSize(512), RegistrarImpl.this.multicastAnnouncementConstraints.getUnfulfilledConstraints());
            while (encodeIterator.hasNext()) {
                try {
                    arrayList.addAll(Arrays.asList(encodeIterator.next()));
                }
                catch (Exception exception) {
                    logger.log(exception instanceof UnsupportedConstraintException ? Levels.HANDLED : Level.INFO, "exception encoding multicast announcement", exception);
                }
            }
            try {
                this.send(arrayList.toArray(new DatagramPacket[arrayList.size()]));
            }
            catch (InterruptedIOException interruptedIOException) {
                return false;
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, "exception sending multicast announcement", iOException);
            }
            return true;
        }

        private void send(DatagramPacket[] datagramPacketArray) throws InterruptedIOException {
            if (RegistrarImpl.this.multicastInterfaces != null) {
                Level level = RegistrarImpl.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                for (int i = 0; i < RegistrarImpl.this.multicastInterfaces.length; ++i) {
                    this.send(datagramPacketArray, RegistrarImpl.this.multicastInterfaces[i], level);
                }
            } else {
                this.send(datagramPacketArray, null, Level.WARNING);
            }
        }

        private void send(DatagramPacket[] datagramPacketArray, NetworkInterface networkInterface, Level level) throws InterruptedIOException {
            if (networkInterface != null) {
                try {
                    this.socket.setNetworkInterface(networkInterface);
                }
                catch (SocketException socketException) {
                    if (logger.isLoggable(level)) {
                        RegistrarImpl.logThrow(level, this.getClass().getName(), "send", "exception setting {0}", new Object[]{networkInterface}, socketException);
                    }
                    return;
                }
            }
            for (int i = 0; i < datagramPacketArray.length; ++i) {
                try {
                    this.socket.send(datagramPacketArray[i]);
                    continue;
                }
                catch (InterruptedIOException interruptedIOException) {
                    throw interruptedIOException;
                }
                catch (IOException iOException) {
                    if (networkInterface != null) {
                        if (!logger.isLoggable(level)) continue;
                        RegistrarImpl.logThrow(level, this.getClass().getName(), "send", "exception sending packet on {0}", new Object[]{networkInterface}, iOException);
                        continue;
                    }
                    logger.log(level, "exception sending packet on default interface", iOException);
                }
            }
        }
    }

    private class UnicastThread
    extends Thread {
        private ServerSocket listen;
        public int port;
        private boolean interrupted;

        public UnicastThread(int n) throws IOException {
            super("unicast request");
            this.interrupted = false;
            this.setDaemon(true);
            if (n == 0) {
                try {
                    this.listen = new ServerSocket(4160);
                }
                catch (IOException iOException) {
                    logger.log(Levels.HANDLED, "failed to bind to default port", iOException);
                }
            }
            if (this.listen == null) {
                this.listen = new ServerSocket(n);
            }
            this.port = this.listen.getLocalPort();
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            try {
                new Socket(InetAddress.getLocalHost(), this.port).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Socket socket = this.listen.accept();
                    if (this.isInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {
                            logger.log(Levels.HANDLED, "exception closing socket", iOException);
                        }
                        break;
                    }
                    RegistrarImpl.this.tasker.add(new SocketTask(socket));
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    logger.log(Levels.HANDLED, "exception listening on socket", exception);
                }
            }
            try {
                this.listen.close();
            }
            catch (IOException iOException) {
                logger.log(Levels.HANDLED, "exception closing server socket", iOException);
            }
        }
    }

    private class MulticastThread
    extends Thread {
        private final InetAddress requestAddr;
        private final MulticastSocket socket;
        private final List failedInterfaces;
        private boolean interrupted;

        public MulticastThread() throws IOException {
            super("multicast request");
            this.failedInterfaces = new ArrayList();
            this.interrupted = false;
            this.setDaemon(true);
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                this.requestAddr = null;
                this.socket = null;
                return;
            }
            this.requestAddr = Constants.getRequestAddress();
            this.socket = new MulticastSocket(4160);
            if (RegistrarImpl.this.multicastInterfaces != null) {
                Level level = RegistrarImpl.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                for (int i = 0; i < RegistrarImpl.this.multicastInterfaces.length; ++i) {
                    NetworkInterface networkInterface = RegistrarImpl.this.multicastInterfaces[i];
                    try {
                        this.socket.setNetworkInterface(networkInterface);
                        this.socket.joinGroup(this.requestAddr);
                        continue;
                    }
                    catch (IOException iOException) {
                        this.failedInterfaces.add(networkInterface);
                        if (!logger.isLoggable(level)) continue;
                        RegistrarImpl.logThrow(level, this.getClass().getName(), "<init>", "exception enabling {0}", new Object[]{networkInterface}, iOException);
                    }
                }
            } else {
                try {
                    this.socket.joinGroup(this.requestAddr);
                }
                catch (IOException iOException) {
                    this.failedInterfaces.add(null);
                    logger.log(Level.WARNING, "exception enabling default interface", iOException);
                }
            }
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            this.socket.close();
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        public void run() {
            if (RegistrarImpl.this.multicastInterfaces != null && RegistrarImpl.this.multicastInterfaces.length == 0) {
                return;
            }
            byte[] byArray = new byte[RegistrarImpl.this.multicastRequestConstraints.getMulticastMaxPacketSize(512)];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            long l = System.currentTimeMillis() + (long)RegistrarImpl.this.multicastInterfaceRetryInterval;
            while (!this.isInterrupted()) {
                try {
                    int n;
                    int n2 = 0;
                    if (!this.failedInterfaces.isEmpty() && (n2 = (int)(l - System.currentTimeMillis())) <= 0) {
                        this.retryFailedInterfaces();
                        if (this.failedInterfaces.isEmpty()) {
                            n2 = 0;
                        } else {
                            n2 = RegistrarImpl.this.multicastInterfaceRetryInterval;
                            l = System.currentTimeMillis() + (long)n2;
                        }
                    }
                    this.socket.setSoTimeout(n2);
                    datagramPacket.setLength(byArray.length);
                    try {
                        this.socket.receive(datagramPacket);
                    }
                    catch (NullPointerException nullPointerException) {
                        break;
                    }
                    try {
                        n = ByteBuffer.wrap(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength()).getInt();
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        throw new DiscoveryProtocolException(null, (Throwable)bufferUnderflowException);
                    }
                    RegistrarImpl.this.multicastRequestConstraints.checkProtocolVersion(n);
                    RegistrarImpl.this.tasker.add(new DecodeRequestTask(datagramPacket, RegistrarImpl.this.getDiscovery(n)));
                    byArray = new byte[byArray.length];
                    datagramPacket = new DatagramPacket(byArray, byArray.length);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (Exception exception) {
                    if (this.isInterrupted()) break;
                    logger.log(Levels.HANDLED, "exception receiving multicast request", exception);
                }
            }
            this.socket.close();
        }

        private void retryFailedInterfaces() {
            Iterator iterator = this.failedInterfaces.iterator();
            while (iterator.hasNext()) {
                NetworkInterface networkInterface = (NetworkInterface)iterator.next();
                try {
                    Level level;
                    if (networkInterface != null) {
                        this.socket.setNetworkInterface(networkInterface);
                    }
                    this.socket.joinGroup(this.requestAddr);
                    iterator.remove();
                    Level level2 = level = RegistrarImpl.this.multicastInterfacesSpecified ? Level.INFO : Level.FINE;
                    if (!logger.isLoggable(level)) continue;
                    if (networkInterface != null) {
                        logger.log(level, "enabled {0}", new Object[]{networkInterface});
                        continue;
                    }
                    logger.log(level, "enabled default interface");
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class DestroyThread
    extends Thread {
        private static final long MAX_UNEXPORT_DELAY = 120000L;

        public DestroyThread() {
            super("destroy");
            this.setDaemon(false);
        }

        public void run() {
            if (RegistrarImpl.this.activationID != null) {
                try {
                    RegistrarImpl.this.activationSystem.unregisterObject(RegistrarImpl.this.activationID);
                }
                catch (RemoteException remoteException) {
                    logger.log(Level.WARNING, "aborting shutdown", remoteException);
                    return;
                }
                catch (ActivationException activationException) {
                    logger.log(Level.INFO, "exception unregistering activation ID", activationException);
                }
            }
            long l = System.currentTimeMillis() + 120000L;
            boolean bl = false;
            while (!bl && System.currentTimeMillis() < l) {
                bl = RegistrarImpl.this.serverExporter.unexport(false);
                if (bl) continue;
                Thread.yield();
            }
            if (!bl) {
                RegistrarImpl.this.serverExporter.unexport(true);
            }
            RegistrarImpl.this.serviceExpirer.interrupt();
            RegistrarImpl.this.eventExpirer.interrupt();
            RegistrarImpl.this.unicaster.interrupt();
            RegistrarImpl.this.multicaster.interrupt();
            RegistrarImpl.this.announcer.interrupt();
            RegistrarImpl.this.snapshotter.interrupt();
            RegistrarImpl.this.tasker.terminate();
            RegistrarImpl.this.joiner.terminate();
            RegistrarImpl.this.discoer.terminate();
            try {
                RegistrarImpl.this.serviceExpirer.join();
                RegistrarImpl.this.eventExpirer.join();
                RegistrarImpl.this.unicaster.join();
                RegistrarImpl.this.multicaster.join();
                RegistrarImpl.this.announcer.join();
                RegistrarImpl.this.snapshotter.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            RegistrarImpl.this.closeRequestSockets(RegistrarImpl.this.tasker.getPending());
            if (RegistrarImpl.this.log != null) {
                RegistrarImpl.this.log.deletePersistentStore();
                logger.finer("deleted persistence directory");
            }
            if (RegistrarImpl.this.activationID != null) {
                try {
                    ActivationGroup.inactive((ActivationID)RegistrarImpl.this.activationID, (Exporter)RegistrarImpl.this.serverExporter);
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "exception going inactive", exception);
                }
            }
            if (RegistrarImpl.this.lifeCycle != null) {
                RegistrarImpl.this.lifeCycle.unregister(RegistrarImpl.this);
            }
            if (RegistrarImpl.this.loginContext != null) {
                try {
                    RegistrarImpl.this.loginContext.logout();
                }
                catch (LoginException loginException) {
                    logger.log(Level.INFO, "logout failed", loginException);
                }
            }
            logger.info("Reggie shutdown completed");
        }
    }

    private class EventExpireThread
    extends Thread {
        public EventExpireThread() {
            super("event expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (!this.isInterrupted()) {
                    long l = System.currentTimeMillis();
                    RegistrarImpl.this.minEventExpiration = Long.MAX_VALUE;
                    while (!RegistrarImpl.this.eventByTime.isEmpty()) {
                        EventReg eventReg = (EventReg)RegistrarImpl.this.eventByTime.firstKey();
                        if (eventReg.leaseExpiration > l) {
                            RegistrarImpl.this.minEventExpiration = eventReg.leaseExpiration;
                            break;
                        }
                        RegistrarImpl.this.deleteEvent(eventReg);
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "expired event registration {0} for {1}", new Object[]{eventReg.leaseID, eventReg.listener});
                    }
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.eventNotifier, RegistrarImpl.this.minEventExpiration - l);
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var5_5 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
                Object var5_6 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }
    }

    private class ServiceExpireThread
    extends Thread {
        private boolean interrupted;

        public ServiceExpireThread() {
            super("service expire");
            this.interrupted = false;
            this.setDaemon(true);
        }

        public synchronized void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }

        public synchronized boolean isInterrupted() {
            return this.interrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                RegistrarImpl.this.concurrentObj.writeLock();
            }
            catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                return;
            }
            try {
                while (!this.isInterrupted()) {
                    long l = System.currentTimeMillis();
                    while (true) {
                        SvcReg svcReg = (SvcReg)RegistrarImpl.this.serviceByTime.firstKey();
                        RegistrarImpl.this.minSvcExpiration = svcReg.leaseExpiration;
                        if (RegistrarImpl.this.minSvcExpiration > l) break;
                        RegistrarImpl.this.deleteService(svcReg, l);
                        RegistrarImpl.this.addLogRecord(new ServiceLeaseCancelledLogObj(svcReg.item.serviceID, svcReg.leaseID));
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "expired service registration {0}", new Object[]{svcReg.item.serviceID});
                    }
                    RegistrarImpl.this.queueEvents();
                    try {
                        RegistrarImpl.this.concurrentObj.writerWait(RegistrarImpl.this.serviceNotifier, RegistrarImpl.this.minSvcExpiration - l);
                    }
                    catch (ReadersWriter.ConcurrentLockException concurrentLockException) {
                        Object var5_5 = null;
                        RegistrarImpl.this.concurrentObj.writeUnlock();
                        return;
                    }
                }
                Object var5_6 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                RegistrarImpl.this.concurrentObj.writeUnlock();
                throw throwable;
            }
        }
    }

    private final class SocketTask
    implements TaskManager.Task {
        public final Socket socket;

        public SocketTask(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            RegistrarImpl.this.respond(this.socket);
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class AddressTask
    implements TaskManager.Task {
        public final InetAddress addr;
        public final int port;

        public AddressTask(InetAddress inetAddress, int n) {
            this.addr = inetAddress;
            this.port = n;
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof AddressTask)) {
                return false;
            }
            AddressTask addressTask = (AddressTask)object;
            return this.addr.equals(addressTask.addr) && this.port == addressTask.port;
        }

        public void run() {
            block2: {
                try {
                    RegistrarImpl.this.respond(new Socket(this.addr, this.port));
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(Level.INFO)) break block2;
                    RegistrarImpl.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to connect to {0}:{1}", new Object[]{this.addr, new Integer(this.port)}, exception);
                }
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class DecodeRequestTask
    implements TaskManager.Task {
        private final DatagramPacket datagram;
        private final Discovery decoder;

        public DecodeRequestTask(DatagramPacket datagramPacket, Discovery discovery) {
            this.datagram = datagramPacket;
            this.decoder = discovery;
        }

        public void run() {
            block6: {
                MulticastRequest multicastRequest;
                try {
                    multicastRequest = this.decoder.decodeMulticastRequest(this.datagram, RegistrarImpl.this.multicastRequestConstraints.getUnfulfilledConstraints(), RegistrarImpl.this.multicastRequestSubjectChecker);
                }
                catch (Exception exception) {
                    if (!(exception instanceof InterruptedIOException) && logger.isLoggable(Levels.HANDLED)) {
                        RegistrarImpl.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception decoding multicast request from {0}:{1}", new Object[]{this.datagram.getAddress(), new Integer(this.datagram.getPort())}, exception);
                    }
                    return;
                }
                Object[] objectArray = multicastRequest.getGroups();
                if ((objectArray.length == 0 || RegistrarImpl.overlap(RegistrarImpl.this.memberGroups, objectArray)) && RegistrarImpl.indexOf(multicastRequest.getServiceIDs(), RegistrarImpl.this.myServiceID) < 0) {
                    try {
                        RegistrarImpl.this.tasker.addIfNew(new AddressTask(InetAddress.getByName(multicastRequest.getHost()), multicastRequest.getPort()));
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!logger.isLoggable(Level.INFO)) break block6;
                        RegistrarImpl.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to resolve host {0}", new Object[]{multicastRequest.getHost()}, unknownHostException);
                    }
                }
            }
        }

        public boolean runAfter(List list, int n) {
            return false;
        }
    }

    private final class EventTask
    implements TaskManager.Task {
        public final EventReg reg;
        public final long seqNo;
        public final ServiceID sid;
        public final Item item;
        public final int transition;

        public EventTask(EventReg eventReg, ServiceID serviceID, Item item, int n) {
            this.reg = eventReg;
            this.seqNo = ++eventReg.seqNo;
            this.sid = serviceID;
            this.item = item;
            this.transition = n;
        }

        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "notifying listener {0} of event {1}", new Object[]{this.reg.listener, new Long(this.reg.eventID)});
            }
            try {
                this.reg.listener.notify((RemoteEvent)new RegistrarEvent(RegistrarImpl.this.proxy, this.reg.eventID, this.seqNo, this.reg.handback, this.sid, this.transition, this.item));
            }
            catch (Throwable throwable) {
                switch (ThrowableConstants.retryable(throwable)) {
                    case 2: {
                        if (throwable instanceof Error) {
                            logger.log(Levels.HANDLED, "exception sending event", throwable);
                            throw (Error)throwable;
                        }
                    }
                    case 1: 
                    case 3: {
                        logger.log(Level.INFO, "exception sending event", throwable);
                        try {
                            RegistrarImpl.this.cancelEventLease(this.reg.eventID, this.reg.leaseID);
                            break;
                        }
                        catch (UnknownLeaseException unknownLeaseException) {
                            logger.log(Levels.HANDLED, "exception canceling event lease", throwable);
                        }
                    }
                }
            }
        }

        public boolean runAfter(List list, int n) {
            int n2 = n;
            while (--n2 >= 0) {
                Object e = list.get(n2);
                if (!(e instanceof EventTask) || !this.reg.listener.equals(((EventTask)e).reg.listener)) continue;
                return true;
            }
            return false;
        }
    }

    private class IDItemIter
    extends ItemIter {
        public IDItemIter(Template template) {
            super(template);
            this.reg = (SvcReg)RegistrarImpl.this.serviceByID.get(template.serviceID);
            if (!(this.reg == null || this.reg.leaseExpiration > this.now && RegistrarImpl.matchItem(template, this.reg.item))) {
                this.reg = null;
            }
        }

        protected void step() {
            this.reg = null;
        }
    }

    private class ClassItemIter
    extends ItemIter {
        private final EntryClass eclass;
        private int classidx;
        private Iterator iter;
        private ArrayList svcs;
        private int svcidx;

        public ClassItemIter(Template template) {
            super(template);
            this.svcidx = 0;
            this.dupsPossible = true;
            this.eclass = template.attributeSetTemplates[0].eclass;
            this.classidx = RegistrarImpl.this.entryClasses.size();
            this.step();
        }

        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepValue()) break;
            }
            this.reg = null;
        }

        private boolean stepValue() {
            do {
                if (this.iter != null && this.iter.hasNext()) {
                    this.svcs = (ArrayList)this.iter.next();
                    this.svcidx = this.svcs.size();
                    return true;
                }
                if (this.stepClass()) continue;
                return false;
            } while (this.iter != null);
            return true;
        }

        private boolean stepClass() {
            while (--this.classidx >= 0) {
                EntryClass entryClass = (EntryClass)RegistrarImpl.this.entryClasses.get(this.classidx);
                if (!this.eclass.isAssignableFrom(entryClass)) continue;
                if (entryClass.getNumFields() > 0) {
                    entryClass = RegistrarImpl.getDefiningClass(entryClass, entryClass.getNumFields() - 1);
                    HashMap[] hashMapArray = (HashMap[])RegistrarImpl.this.serviceByAttr.get(entryClass);
                    this.iter = hashMapArray[hashMapArray.length - 1].values().iterator();
                } else {
                    this.iter = null;
                    this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(entryClass);
                    this.svcidx = this.svcs.size();
                }
                return true;
            }
            return false;
        }
    }

    private class EmptyAttrItemIter
    extends AttrItemIter {
        public EmptyAttrItemIter(Template template, EntryClass entryClass) {
            super(template);
            this.svcs = (ArrayList)RegistrarImpl.this.serviceByEmptyAttr.get(entryClass);
            if (this.svcs != null) {
                this.svcidx = this.svcs.size();
                this.step();
            }
        }
    }

    private class AttrItemIter
    extends ItemIter {
        protected ArrayList svcs;
        protected int svcidx;

        public AttrItemIter(Template template, int n, int n2) {
            super(template);
            EntryRep entryRep = template.attributeSetTemplates[n];
            HashMap[] hashMapArray = (HashMap[])RegistrarImpl.this.serviceByAttr.get(RegistrarImpl.getDefiningClass(entryRep.eclass, n2));
            if (hashMapArray != null && hashMapArray[n2] != null) {
                this.svcs = (ArrayList)hashMapArray[n2].get(entryRep.fields[n2]);
                if (this.svcs != null) {
                    this.svcidx = this.svcs.size();
                    this.step();
                }
            }
        }

        protected AttrItemIter(Template template) {
            super(template);
        }

        protected void step() {
            while (--this.svcidx >= 0) {
                this.reg = (SvcReg)this.svcs.get(this.svcidx);
                if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                return;
            }
            this.reg = null;
        }
    }

    private class TypeItemIter
    extends ItemIter {
        private final ServiceType[] types;
        private int typeidx;
        private ArrayList svcs;
        private int svcidx;

        public TypeItemIter(Template template) {
            super(template);
            this.svcidx = 0;
            this.types = RegistrarImpl.this.matchingConcreteClasses(template.serviceTypes);
            this.typeidx = this.types.length;
            this.step();
        }

        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !RegistrarImpl.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepType()) break;
            }
            this.reg = null;
        }

        private boolean stepType() {
            if (--this.typeidx < 0) {
                return false;
            }
            this.svcs = (ArrayList)RegistrarImpl.this.serviceByType.get(this.types[this.typeidx]);
            this.svcidx = this.svcs.size();
            return true;
        }
    }

    private class AllItemIter
    extends ItemIter {
        private final Iterator iter;

        public AllItemIter() {
            super(null);
            this.iter = RegistrarImpl.this.serviceByID.values().iterator();
            this.step();
        }

        protected void step() {
            while (this.iter.hasNext()) {
                this.reg = (SvcReg)this.iter.next();
                if (this.reg.leaseExpiration <= this.now) continue;
                return;
            }
            this.reg = null;
        }
    }

    private abstract class ItemIter {
        public final long now = System.currentTimeMillis();
        public boolean dupsPossible = false;
        protected final Template tmpl;
        protected SvcReg reg;

        protected ItemIter(Template template) {
            this.tmpl = template;
        }

        public boolean hasNext() {
            return this.reg != null;
        }

        public Item next() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            Item item = this.reg.item;
            this.step();
            return item;
        }

        public SvcReg nextReg() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            SvcReg svcReg = this.reg;
            this.step();
            return svcReg;
        }

        protected abstract void step();
    }

    private class LocalLogHandler
    extends LogHandler {
        public void snapshot(OutputStream outputStream) throws IOException {
            RegistrarImpl.this.takeSnapshot(outputStream);
        }

        public void recover(InputStream inputStream) throws IOException, ClassNotFoundException {
            RegistrarImpl.this.recoverSnapshot(inputStream);
        }

        public void applyUpdate(Object object) {
            ((LogRecord)object).apply(RegistrarImpl.this);
        }
    }

    private static class MemberGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private String[] groups;

        public MemberGroupsChangedLogObj(String[] stringArray) {
            this.groups = stringArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            RegistrarImpl.access$2602(registrarImpl, this.groups);
        }
    }

    private static class LookupLocatorsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private transient LookupLocator[] locators;

        public LookupLocatorsChangedLogObj(LookupLocator[] lookupLocatorArray) {
            this.locators = lookupLocatorArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                RegistrarImpl.access$2102(registrarImpl, RegistrarImpl.prepareLocators(this.locators, registrarImpl.recoveredLocatorPreparer, true));
            }
            catch (RemoteException remoteException) {
                throw new AssertionError((Object)remoteException);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            RegistrarImpl.marshalLocators(this.locators, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.locators = RegistrarImpl.unmarshalLocators(objectInputStream);
        }
    }

    private static class LookupGroupsChangedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private String[] groups;

        public LookupGroupsChangedLogObj(String[] stringArray) {
            this.groups = stringArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            RegistrarImpl.access$2002(registrarImpl, this.groups);
        }
    }

    private static class UnicastPortSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private int newPort;

        public UnicastPortSetLogObj(int n) {
            this.newPort = n;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.unicastPort = this.newPort;
        }
    }

    private static class LeasesCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Object[] regIDs;
        private Uuid[] leaseIDs;

        public LeasesCancelledLogObj(Object[] objectArray, Uuid[] uuidArray) {
            this.regIDs = objectArray;
            this.leaseIDs = uuidArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.cancelLeasesDo(this.regIDs, this.leaseIDs);
        }
    }

    private static class LeasesRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private Object[] regIDs;
        private Uuid[] leaseIDs;
        private long[] leaseExpTimes;

        public LeasesRenewedLogObj(Object[] objectArray, Uuid[] uuidArray, long[] lArray) {
            this.regIDs = objectArray;
            this.leaseIDs = uuidArray;
            this.leaseExpTimes = lArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewLeasesAbs(this.regIDs, this.leaseIDs, this.leaseExpTimes);
        }
    }

    private static class EventLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private long eventID;
        private Uuid leaseID;
        private long leaseExpTime;

        public EventLeaseRenewedLogObj(long l, Uuid uuid, long l2) {
            this.eventID = l;
            this.leaseID = uuid;
            this.leaseExpTime = l2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewEventLeaseAbs(this.eventID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class EventLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private long eventID;
        private Uuid leaseID;

        public EventLeaseCancelledLogObj(long l, Uuid uuid) {
            this.eventID = l;
            this.leaseID = uuid;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.cancelEventLeaseDo(this.eventID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class ServiceLeaseRenewedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private long leaseExpTime;

        public ServiceLeaseRenewedLogObj(ServiceID serviceID, Uuid uuid, long l) {
            this.serviceID = serviceID;
            this.leaseID = uuid;
            this.leaseExpTime = l;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.renewServiceLeaseAbs(this.serviceID, this.leaseID, this.leaseExpTime);
        }
    }

    private static class ServiceLeaseCancelledLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;

        public ServiceLeaseCancelledLogObj(ServiceID serviceID, Uuid uuid) {
            this.serviceID = serviceID;
            this.leaseID = uuid;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.cancelServiceLeaseDo(this.serviceID, this.leaseID);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class EventRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private EventReg eventReg;

        public EventRegisteredLogObj(EventReg eventReg) {
            this.eventReg = eventReg;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.resolver.resolve(this.eventReg.tmpl);
            this.eventReg.prepareListener(registrarImpl.recoveredListenerPreparer);
            this.eventReg.seqNo += Integer.MAX_VALUE;
            registrarImpl.addEvent(this.eventReg);
            registrarImpl.eventID++;
        }
    }

    private static class AttrsSetLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSets;

        public AttrsSetLogObj(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) {
            this.serviceID = serviceID;
            this.leaseID = uuid;
            this.attrSets = entryRepArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.setAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class AttrsModifiedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSetTmpls;
        private EntryRep[] attrSets;

        public AttrsModifiedLogObj(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray, EntryRep[] entryRepArray2) {
            this.serviceID = serviceID;
            this.leaseID = uuid;
            this.attrSetTmpls = entryRepArray;
            this.attrSets = entryRepArray2;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.modifyAttributesDo(this.serviceID, this.leaseID, this.attrSetTmpls, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class AttrsAddedLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private ServiceID serviceID;
        private Uuid leaseID;
        private EntryRep[] attrSets;

        public AttrsAddedLogObj(ServiceID serviceID, Uuid uuid, EntryRep[] entryRepArray) {
            this.serviceID = serviceID;
            this.leaseID = uuid;
            this.attrSets = entryRepArray;
        }

        public void apply(RegistrarImpl registrarImpl) {
            try {
                registrarImpl.addAttributesDo(this.serviceID, this.leaseID, this.attrSets);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }
    }

    private static class SvcRegisteredLogObj
    implements LogRecord {
        private static final long serialVersionUID = 2L;
        private SvcReg reg;

        public SvcRegisteredLogObj(SvcReg svcReg) {
            this.reg = svcReg;
        }

        public void apply(RegistrarImpl registrarImpl) {
            registrarImpl.resolver.resolve(this.reg.item);
            SvcReg svcReg = (SvcReg)registrarImpl.serviceByID.get(this.reg.item.serviceID);
            if (svcReg != null) {
                registrarImpl.deleteService(svcReg, 0L);
            }
            registrarImpl.addService(this.reg);
        }
    }

    private static interface LogRecord
    extends Serializable {
        public void apply(RegistrarImpl var1);
    }

    private static final class EventReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final long eventID;
        public final Uuid leaseID;
        public final Template tmpl;
        public final int transitions;
        public long seqNo;
        public transient RemoteEventListener listener;
        public final MarshalledObject handback;
        public long leaseExpiration;

        public EventReg(long l, Uuid uuid, Template template, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l2) {
            this.eventID = l;
            this.leaseID = uuid;
            this.tmpl = template;
            this.transitions = n;
            this.seqNo = 0L;
            this.listener = remoteEventListener;
            this.handback = marshalledObject;
            this.leaseExpiration = l2;
        }

        public int compareTo(Object object) {
            EventReg eventReg = (EventReg)object;
            if (this == eventReg) {
                return 0;
            }
            if (this.leaseExpiration < eventReg.leaseExpiration || this.leaseExpiration == eventReg.leaseExpiration && this.eventID < eventReg.eventID) {
                return -1;
            }
            return 1;
        }

        public void prepareListener(ProxyPreparer proxyPreparer) {
            if (this.listener != null) {
                try {
                    this.listener = (RemoteEventListener)proxyPreparer.prepareProxy((Object)this.listener);
                }
                catch (Exception exception) {
                    if (logger.isLoggable(Level.WARNING)) {
                        RegistrarImpl.logThrow(Level.WARNING, this.getClass().getName(), "prepareListener", "failed to prepare event listener {0}", new Object[]{this.listener}, exception);
                    }
                    this.listener = null;
                }
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(new MarshalledInstance((Object)this.listener));
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MarshalledInstance marshalledInstance = (MarshalledInstance)objectInputStream.readObject();
            try {
                this.listener = (RemoteEventListener)marshalledInstance.get(false);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error && ThrowableConstants.retryable(throwable) == 2) {
                    throw (Error)throwable;
                }
                logger.log(Level.WARNING, "failed to recover event listener", throwable);
            }
        }
    }

    private static final class SvcReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final Item item;
        public final Uuid leaseID;
        public long leaseExpiration;

        public SvcReg(Item item, Uuid uuid, long l) {
            this.item = item;
            this.leaseID = uuid;
            this.leaseExpiration = l;
        }

        public int compareTo(Object object) {
            SvcReg svcReg = (SvcReg)object;
            if (this == svcReg) {
                return 0;
            }
            int n = SvcReg.compare(this.leaseExpiration, svcReg.leaseExpiration);
            if (n != 0) {
                return n;
            }
            n = SvcReg.compare(this.leaseID.getMostSignificantBits(), svcReg.leaseID.getMostSignificantBits());
            if (n != 0) {
                return n;
            }
            return SvcReg.compare(this.leaseID.getLeastSignificantBits(), svcReg.leaseID.getLeastSignificantBits());
        }

        private static int compare(long l, long l2) {
            return l < l2 ? -1 : (l > l2 ? 1 : 0);
        }
    }
}

