/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.ConstrainableRegistrarProxy;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reggie.Util;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

class RegistrarProxy
implements ServiceRegistrar,
Administrable,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.reggie");
    final Registrar server;
    transient ServiceID registrarID;

    static RegistrarProxy getInstance(Registrar registrar, ServiceID serviceID) {
        return registrar instanceof RemoteMethodControl ? new ConstrainableRegistrarProxy(registrar, serviceID, null) : new RegistrarProxy(registrar, serviceID);
    }

    RegistrarProxy(Registrar registrar, ServiceID serviceID) {
        this.server = registrar;
        this.registrarID = serviceID;
    }

    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    public ServiceRegistration register(ServiceItem serviceItem, long l) throws RemoteException {
        Item item = new Item(serviceItem);
        if (item.serviceID != null) {
            Util.checkRegistrantServiceID(item.serviceID, logger, Level.WARNING);
        }
        return this.server.register(item, l);
    }

    public Object lookup(ServiceTemplate serviceTemplate) throws RemoteException {
        MarshalledWrapper marshalledWrapper = this.server.lookup(new Template(serviceTemplate));
        if (marshalledWrapper == null) {
            return null;
        }
        try {
            return marshalledWrapper.get();
        }
        catch (IOException iOException) {
            throw new UnmarshalException("error unmarshalling return", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnmarshalException("error unmarshalling return", classNotFoundException);
        }
    }

    public ServiceMatches lookup(ServiceTemplate serviceTemplate, int n) throws RemoteException {
        return this.server.lookup(new Template(serviceTemplate), n).get();
    }

    public EventRegistration notify(ServiceTemplate serviceTemplate, int n, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        return this.server.notify(new Template(serviceTemplate), n, remoteEventListener, marshalledObject, l);
    }

    public Class[] getEntryClasses(ServiceTemplate serviceTemplate) throws RemoteException {
        return EntryClassBase.toClass(this.server.getEntryClasses(new Template(serviceTemplate)));
    }

    public Object[] getFieldValues(ServiceTemplate serviceTemplate, int n, String string) throws NoSuchFieldException, RemoteException {
        ClassMapper.EntryField[] entryFieldArray = ClassMapper.getFields(serviceTemplate.attributeSetTemplates[n].getClass());
        int n2 = entryFieldArray.length;
        while (--n2 >= 0 && !string.equals(entryFieldArray[n2].field.getName())) {
        }
        if (n2 < 0) {
            throw new NoSuchFieldException(string);
        }
        Object[] objectArray = this.server.getFieldValues(new Template(serviceTemplate), n, n2);
        if (objectArray != null && entryFieldArray[n2].marshal) {
            int n3 = objectArray.length;
            while (--n3 >= 0) {
                try {
                    objectArray[n3] = ((MarshalledWrapper)objectArray[n3]).get();
                }
                catch (Throwable throwable) {
                    RegistrarProxy.handleException(throwable);
                    objectArray[n3] = null;
                }
            }
        }
        return objectArray;
    }

    static void handleException(Throwable throwable) {
        if (throwable instanceof Error && !(throwable instanceof LinkageError) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof StackOverflowError)) {
            throw (Error)throwable;
        }
        logger.log(Level.INFO, "unmarshalling failure", throwable);
    }

    public Class[] getServiceTypes(ServiceTemplate serviceTemplate, String string) throws RemoteException {
        return ServiceTypeBase.toClass(this.server.getServiceTypes(new Template(serviceTemplate), string));
    }

    public ServiceID getServiceID() {
        return this.registrarID;
    }

    public LookupLocator getLocator() throws RemoteException {
        return this.server.getLocator();
    }

    public String[] getGroups() throws RemoteException {
        return this.server.getMemberGroups();
    }

    public Uuid getReferentUuid() {
        return UuidFactory.create((long)this.registrarID.getMostSignificantBits(), (long)this.registrarID.getLeastSignificantBits());
    }

    public int hashCode() {
        return this.registrarID.hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        this.registrarID.writeBytes((DataOutput)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.registrarID = new ServiceID((DataInput)objectInputStream);
        if (this.server == null) {
            throw new InvalidObjectException("null server");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

