/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder;

import com.mathworks.toolbox.javabuilder.MWClassID;
import com.mathworks.toolbox.javabuilder.internal.MWMCR;
import com.mathworks.toolbox.javabuilder.internal.NativePtr;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

class NativeArray
extends NativePtr
implements Serializable {
    private transient boolean fDisposed = false;
    private transient byte[] fSerialized = null;
    private transient Runnable disposeArrayRunnable = this.getShutdownRunnable();
    static final long serialVersionUID = -7339025305151942750L;

    NativeArray() {
        super(NativePtr.NULL);
    }

    NativeArray(NativePtr nativePtr) {
        super(nativePtr);
    }

    private NativeArray(byte[] byArray) {
        this.fSerialized = byArray;
    }

    NativeArray deepCopy() {
        if (null != this.fSerialized) {
            return new NativeArray((byte[])this.fSerialized.clone());
        }
        if (NativePtr.NULL.equals(this)) {
            return new NativeArray(NativePtr.NULL);
        }
        return new NativeArray(MWMCR.getNativeMCR().mxDuplicateArray(this));
    }

    NativeArray sharedCopy() {
        if (NativePtr.NULL.equals(this)) {
            return new NativeArray(NativePtr.NULL);
        }
        return new NativeArray(MWMCR.getNativeMCR().mxCreateSharedCopy(this));
    }

    @Override
    protected long get() {
        if (null != this.fSerialized) {
            if (0 == this.fSerialized.length) {
                this.set(NativePtr.NULL);
            } else {
                this.set(MWMCR.getNativeMCR().mxDeserialize(this.fSerialized));
            }
            this.fSerialized = null;
        }
        if (this.fDisposed) {
            throw new IllegalStateException("Attempt to use an MWArray that has been disposed");
        }
        return super.get();
    }

    void dispose() {
        this.disposeArrayRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    byte[] serialize() {
        if (this.fSerialized != null) {
            return this.fSerialized;
        }
        if (NativePtr.NULL.equals(this)) {
            return new byte[0];
        }
        return MWMCR.getNativeMCR().mxSerialize(this);
    }

    static NativeArray deserialize(byte[] byArray) {
        return new NativeArray(byArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            byte[] byArray;
            byte[] byArray2 = byArray = this.fSerialized != null ? this.fSerialized : this.serialize();
            if (byArray == null) {
                byArray = new byte[]{};
            }
            objectOutputStream.writeObject(byArray);
        }
        catch (Exception exception) {
            throw new InvalidObjectException(exception.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.fSerialized = null == byArray ? new byte[]{} : byArray;
        this.disposeArrayRunnable = this.getShutdownRunnable();
    }

    private Runnable getShutdownRunnable() {
        return MWMCR.scheduleShutdownTask(new Runnable(){

            @Override
            public void run() {
                NativeArray.this.disposeInternal();
            }
        });
    }

    private void disposeInternal() {
        if (this.fDisposed) {
            return;
        }
        if (null != this.fSerialized) {
            this.fSerialized = null;
        } else if (!NativePtr.NULL.equals(this)) {
            MWMCR.getNativeMCR().mxDestroyArray(this);
        }
        this.fDisposed = true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public MWClassID classID() {
        return MWClassID.valueOf(MWMCR.getNativeMCR().mxGetClassID(this));
    }

    public boolean dataEquals(NativeArray nativeArray) {
        if (this.fSerialized != null && nativeArray.fSerialized != null) {
            return Arrays.equals(this.fSerialized, nativeArray.fSerialized);
        }
        return MWMCR.getNativeMCR().mxIsIdentical(this, nativeArray);
    }
}

