/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.chromium;

import com.teamdev.jxbrowser.chromium.AuthDialogParams;
import com.teamdev.jxbrowser.chromium.CloseStatus;
import com.teamdev.jxbrowser.chromium.DialogHandler;
import com.teamdev.jxbrowser.chromium.DialogParams;
import com.teamdev.jxbrowser.chromium.FileChooserMode;
import com.teamdev.jxbrowser.chromium.FileChooserParams;
import com.teamdev.jxbrowser.chromium.PromptDialogParams;
import com.teamdev.jxbrowser.chromium.UnloadDialogParams;
import com.teamdev.jxbrowser.chromium.h;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DefaultDialogHandler
implements DialogHandler {
    public void onAlert(DialogParams object) {
        Object object2 = ((DialogParams)object).getURL();
        object2 = "The page at " + (String)object2 + " says:";
        String string = ((DialogParams)object).getMessage();
        object = ((DialogParams)object).getBrowser().getView().getComponent();
        JOptionPane.showMessageDialog((Component)object, string, (String)object2, -1);
    }

    public CloseStatus onConfirmation(DialogParams object) {
        Object object2 = ((DialogParams)object).getURL();
        object2 = "The page at " + (String)object2 + " says:";
        String string = ((DialogParams)object).getMessage();
        int n2 = JOptionPane.showConfirmDialog((Component)(object = ((DialogParams)object).getBrowser().getView().getComponent()), string, (String)object2, 2, -1);
        if (n2 == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onPrompt(PromptDialogParams promptDialogParams) {
        Object object = promptDialogParams.getURL();
        object = "The page at " + (String)object + " says:";
        Object[] objectArray = promptDialogParams.getMessage();
        JTextField jTextField = new JTextField(promptDialogParams.getPromptText());
        objectArray = new Object[]{new JLabel((String)objectArray), jTextField};
        JComponent jComponent = promptDialogParams.getBrowser().getView().getComponent();
        int n2 = JOptionPane.showConfirmDialog(jComponent, objectArray, (String)object, 2, -1);
        if (n2 == 0) {
            promptDialogParams.setPromptText(jTextField.getText());
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onAuthRequired(AuthDialogParams authDialogParams) {
        Object[] objectArray = authDialogParams.getURL();
        String string = "Authentication Required";
        objectArray = "The server " + (String)objectArray + " requires a username and password.";
        JTextField jTextField = new JTextField();
        JPasswordField jPasswordField = new JPasswordField();
        objectArray = new Object[]{new JLabel((String)objectArray), Box.createVerticalStrut(10), new JLabel("User Name:"), jTextField, new JLabel("Password:"), jPasswordField};
        JComponent jComponent = authDialogParams.getBrowser().getView().getComponent();
        int n2 = JOptionPane.showConfirmDialog(jComponent, objectArray, string, 2, -1);
        if (n2 == 0) {
            authDialogParams.setUsername(jTextField.getText());
            authDialogParams.setPassword(new String(jPasswordField.getPassword()));
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onFileChooser(FileChooserParams fileChooserParams) {
        if (fileChooserParams.getMode() == FileChooserMode.Open) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Open");
            JComponent jComponent = fileChooserParams.getBrowser().getView().getComponent();
            AtomicInteger atomicInteger = new AtomicInteger(1);
            try {
                SwingUtilities.invokeAndWait(new h((DefaultDialogHandler)((Object)file), atomicInteger, jFileChooser, jComponent));
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            if (atomicInteger.get() == 0) {
                File file = jFileChooser.getSelectedFile();
                fileChooserParams.setSelectedFile(file.getAbsolutePath());
                return CloseStatus.OK;
            }
        }
        return CloseStatus.CANCEL;
    }

    public CloseStatus onBeforeUnload(UnloadDialogParams unloadDialogParams) {
        int n2;
        Object object = "Confirm Navigation";
        String string = unloadDialogParams.getMessage();
        JComponent jComponent = unloadDialogParams.getBrowser().getView().getComponent();
        Object[] objectArray = new Object[]{"Leave this Page", "Stay on this Page"};
        if (unloadDialogParams.isReload()) {
            object = "Confirm Reload";
            objectArray = new Object[]{"Reload this Page", "Don't Reload"};
        }
        if ((n2 = JOptionPane.showOptionDialog(jComponent, string, (String)object, 2, -1, null, objectArray, objectArray[0])) == 0) {
            return CloseStatus.OK;
        }
        return CloseStatus.CANCEL;
    }
}

