/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.computils.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class ChecksumGenerator {
    private ChecksumGenerator() {
    }

    public static Map<File, Long> getCRC32CheckSums(Collection<File> collection) throws IOException {
        collection = ChecksumGenerator.stripOutDirectories(collection);
        HashMap<File, Long> hashMap = new HashMap<File, Long>();
        for (File file : collection) {
            hashMap.put(file, ChecksumGenerator.getCRC32Checksum(file));
        }
        return hashMap;
    }

    private static Collection<File> stripOutDirectories(Collection<File> collection) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : collection) {
            if (!file.isFile()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static long getCRC32Checksum(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            long l = ChecksumGenerator.getCRC32Checksum(fileInputStream);
            return l;
        }
    }

    private static long getCRC32Checksum(InputStream inputStream) throws IOException {
        try (CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, new CRC32());){
            byte[] byArray = new byte[1024];
            while (checkedInputStream.read(byArray, 0, byArray.length) != -1) {
            }
            long l = checkedInputStream.getChecksum().getValue();
            return l;
        }
    }

    public static long getCRC32Checksum(String string) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            long l = ChecksumGenerator.getCRC32Checksum(byteArrayInputStream);
            return l;
        }
    }
}

