/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.api;

import com.mathworks.matlabserver.connector.api.DirectLoadURLClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;

public class FilteredClassLoader
extends ClassLoader {
    private String[] whitelist;
    private String[] directLoading;
    private static boolean disableWhitelist = false;
    private ClassLoader delegate;
    private ClassLoader parent;

    protected FilteredClassLoader(String[] jarPaths, String[] whitelist, String[] directLoading, ClassLoader parent) {
        super(parent);
        this.whitelist = whitelist;
        this.directLoading = directLoading;
        this.parent = parent;
        this.updateDelegate(jarPaths);
    }

    private void updateDelegate(String[] newJarPaths) {
        URL[] urls = new URL[newJarPaths.length];
        for (int i = 0; i < newJarPaths.length; ++i) {
            File file = new File(newJarPaths[i]);
            try {
                urls[i] = file.toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        this.delegate = new DirectLoadURLClassLoader(this.directLoading, urls, this.parent);
    }

    public static void disableWhitelist(boolean disable) {
        disableWhitelist = disable;
    }

    private boolean isAllowedAccess(String name) {
        if (disableWhitelist) {
            return true;
        }
        for (String filtered : this.whitelist) {
            if (!name.startsWith(filtered) && !name.startsWith("[L" + filtered)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.isAllowedAccess(name)) {
            return this.delegate.loadClass(name);
        }
        throw new ClassNotFoundException();
    }

    @Override
    public URL getResource(String name) {
        if (this.isAllowedAccess(name)) {
            return this.delegate.getResource(name);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isAllowedAccess(name)) {
            return this.delegate.getResources(name);
        }
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.isAllowedAccess(name)) {
            return this.delegate.getResourceAsStream(name);
        }
        return null;
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }
}

