/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.api.matlab;

import com.mathworks.matlabserver.connector.api.matlab.AutoStartRunnable;
import com.mathworks.matlabserver.connector.api.matlab.RunOnInputRequestEvent;
import com.mathworks.services.Prefs;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class AutoStartHelper {
    private static final String AUTOSTART_FEATUREON = "MATLAB_CONNECTOR_AUTOSTART_FEATUREON";
    private static final boolean AUTOSTART_FEATUREON_DEFAULT = true;
    private static final String AUTOSTART_ENABLED = "MATLAB_CONNECTOR_AUTOSTART_ENABLED";
    private static final boolean AUTOSTART_ENABLED_DEFAULT = true;
    private static final int AUTOSTART_EVENT_RETRYINTERVAL_DEFAULT = 1000;
    private static final int AUTOSTART_EVENT_MAXRETRIES_DEFAULT = 180;
    private static final int AUTOSTART_ISTARTING_MAX_WAIT_TIME = 180;
    public static final AtomicBoolean invokedStartServiceIfApplicable = new AtomicBoolean(false);
    private static Date startingSince = null;

    public static boolean getIsFeatureOn() {
        return Prefs.getBooleanPref((String)AUTOSTART_FEATUREON, (boolean)true);
    }

    public static void setIsFeatureOn(boolean featureOn) {
        Prefs.setBooleanPref((String)AUTOSTART_FEATUREON, (boolean)featureOn);
    }

    public static boolean getAutoStartEnabled() {
        return Prefs.getBooleanPref((String)AUTOSTART_ENABLED, (boolean)true);
    }

    public static void setAutoStartEnabled(boolean enable) {
        Prefs.setBooleanPref((String)AUTOSTART_ENABLED, (boolean)enable);
    }

    protected static void startServiceIfApplicable() {
        if (!invokedStartServiceIfApplicable.getAndSet(true) && !AutoStartHelper.isStarting() && AutoStartHelper.getIsFeatureOn() && AutoStartHelper.getAutoStartEnabled()) {
            RunOnInputRequestEvent.invoke(new AutoStartRunnable(), 1000, 180);
        }
    }

    public static void setStartingSince(Date time) {
        startingSince = time;
    }

    public static synchronized boolean isStarting() {
        if (startingSince != null) {
            long diff = new Date().getTime() - startingSince.getTime();
            if (diff / 1000L <= 180L) {
                return true;
            }
            startingSince = null;
        }
        return false;
    }
}

