/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.NoAuthorisedUserFoundException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.UnauthorisedUserException;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ChangePasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.NewPasswordReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderLocal;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

public abstract class InvocationChangePassword
extends AbstractInvocationWithAuth<Object> {
    private final UserIdentity fInvokingUser;
    private CredentialProviderLocal fTokenProvider;

    public InvocationChangePassword(UserIdentity userIdentity, UserIdentity userIdentity2) {
        super(userIdentity);
        this.fInvokingUser = userIdentity2;
    }

    public CredentialProviderLocal getTokenProvider() {
        return this.fTokenProvider;
    }

    public void setTokenProvider(CredentialProviderLocal credentialProviderLocal) {
        this.fTokenProvider = credentialProviderLocal;
    }

    @Override
    public Object makeInvocation(CredentialStore<AuthenticationToken> credentialStore, RemoteAuthorisationModule remoteAuthorisationModule) throws AuthorisationFailedException, RemoteException, MJSException {
        CredentialProviderImpl credentialProviderImpl = this.makeCredentialProvider();
        this.setTokenProvider(credentialProviderImpl.getProxy());
        CredentialProviderImpl credentialProviderImpl2 = this.makeCredentialProvider();
        this.setCredentialProvider(credentialProviderImpl2.getProxy());
        NewPasswordReturn newPasswordReturn = null;
        while (true) {
            try {
                Object t = this.invoke();
                return t;
            }
            catch (NoAuthorisedUserFoundException noAuthorisedUserFoundException) {
                if (!noAuthorisedUserFoundException.hasUserBeenChecked(this.fInvokingUser)) {
                    throw new UnauthorisedUserException(this.fInvokingUser);
                }
                newPasswordReturn = remoteAuthorisationModule.promptForChangePassword(this.getUserIdentity(), this.fInvokingUser);
                if (newPasswordReturn == null) continue;
                credentialProviderImpl2.getCredentialStore().putCredentials(newPasswordReturn.getNewCredentials());
                credentialProviderImpl.getCredentialStore().putCredentials(((ChangePasswordReturn)newPasswordReturn).getCurrentToken());
                continue;
            }
            break;
        }
        finally {
            if (newPasswordReturn != null) {
                credentialStore.removeUser(this.getUserIdentity());
                credentialStore.putCredentials(newPasswordReturn.getNewToken(), newPasswordReturn.getRememberChoice());
                newPasswordReturn.getNewCredentials().erase();
            }
            credentialProviderImpl.unexport();
            credentialProviderImpl2.unexport();
        }
    }
}

