/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth;

import com.mathworks.jmi.MatlabMCRFactory;
import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.AuthorisationFailedException;
import com.mathworks.toolbox.distcomp.auth.NoAuthorisedUserFoundException;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.UnauthorisedUserException;
import com.mathworks.toolbox.distcomp.auth.UnknownUserException;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CurrentTokenReturn;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialProviderImpl;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialTransferException;
import com.mathworks.toolbox.distcomp.auth.credentials.store.NoCredentialsException;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.util.MCRShutdownHandler;
import java.rmi.RemoteException;

public abstract class InvocationWithAuth<T>
extends AbstractInvocationWithAuth<T> {
    public static final int MAX_ATTEMPTS = 3;
    private static CredentialProviderImpl<AuthenticationToken> sCachedCredentialProvider;

    public InvocationWithAuth(UserIdentity userIdentity) {
        super(userIdentity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized T makeInvocation(CredentialStore<AuthenticationToken> credentialStore, RemoteAuthorisationModule remoteAuthorisationModule) throws AuthorisationFailedException, RemoteException, MJSException {
        int n = this.isInteractive() ? 3 : 0;
        CredentialProviderImpl<AuthenticationToken> credentialProviderImpl = InvocationWithAuth.getCachedProvider(this);
        credentialProviderImpl.getCredentialStore().removeAllCredentials();
        credentialProviderImpl.getCredentialStore().putAllCredentials(credentialStore.getAllCredentials());
        this.setCredentialProvider(credentialProviderImpl.getProxy());
        CurrentTokenReturn currentTokenReturn = null;
        UserIdentity userIdentity = this.getUserIdentity();
        while (true) {
            try {
                Object t = this.invoke();
                return t;
            }
            catch (NoAuthorisedUserFoundException noAuthorisedUserFoundException) {
                currentTokenReturn = null;
                if (!noAuthorisedUserFoundException.hasUserBeenChecked(userIdentity)) {
                    if (!this.isInteractive()) throw new UnauthorisedUserException(userIdentity);
                    currentTokenReturn = remoteAuthorisationModule.promptForTemporaryUserSwitch(noAuthorisedUserFoundException.getOwner());
                    userIdentity = currentTokenReturn.getCurrentToken().getUserIdentity();
                } else {
                    AuthorisationFailedException authorisationFailedException = noAuthorisedUserFoundException.getUserException(userIdentity);
                    if (authorisationFailedException instanceof UnknownUserException || authorisationFailedException instanceof CredentialTransferException) {
                        throw authorisationFailedException;
                    }
                    if (n < 1) {
                        throw authorisationFailedException;
                    }
                    --n;
                    if (authorisationFailedException instanceof NoCredentialsException) {
                        authorisationFailedException = null;
                    }
                    currentTokenReturn = remoteAuthorisationModule.promptForCurrentPassword(userIdentity, authorisationFailedException);
                }
                credentialProviderImpl.getCredentialStore().putCredentials(currentTokenReturn.getCurrentToken());
                continue;
            }
            break;
        }
        finally {
            if (currentTokenReturn != null) {
                credentialStore.putCredentials(currentTokenReturn.getCurrentToken(), currentTokenReturn.getRememberChoice());
            }
        }
    }

    private static <T> CredentialProviderImpl<AuthenticationToken> getCachedProvider(InvocationWithAuth<T> invocationWithAuth) throws RemoteException {
        if (sCachedCredentialProvider == null) {
            sCachedCredentialProvider = invocationWithAuth.makeCredentialProvider();
            MCRShutdownHandler.addShutdownHook(MatlabMCRFactory.getForCurrentMCR(), new Thread(){

                @Override
                public void run() {
                    sCachedCredentialProvider.unexport();
                }
            });
        }
        return sCachedCredentialProvider;
    }
}

