/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials;

import com.mathworks.toolbox.distcomp.auth.CryptoException;
import com.mathworks.toolbox.distcomp.auth.CryptoModule;
import com.mathworks.toolbox.distcomp.auth.EncryptedObject;
import com.mathworks.toolbox.distcomp.auth.Erasable;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.DecryptFailedException;
import com.mathworks.toolbox.distcomp.auth.credentials.TransferableCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.WebLicenseCredentials;

public class EncryptedWebLicenseCredentials
implements TransferableCredentials {
    private final UserIdentity fUserIdentity;
    private final EncryptedObject fEncryptedWebUserName;
    private final EncryptedObject fEncryptedLicenseInfo;
    private final EncryptedObject fEncryptedLicenseID;
    private final EncryptedObject fEncryptedLicenseNumber;
    private final byte[] fSalt;
    private final boolean fEncrypted;

    public EncryptedWebLicenseCredentials(UserIdentity userIdentity, EncryptedObject encryptedObject, EncryptedObject encryptedObject2, EncryptedObject encryptedObject3, EncryptedObject encryptedObject4, byte[] byArray) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedWebUserName = encryptedObject;
        this.fEncryptedLicenseInfo = encryptedObject2;
        this.fEncryptedLicenseID = encryptedObject3;
        this.fEncryptedLicenseNumber = encryptedObject4;
        this.fSalt = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.fSalt, 0, byArray.length);
        this.fEncrypted = true;
    }

    public EncryptedWebLicenseCredentials(UserIdentity userIdentity, Erasable erasable, Erasable erasable2, Erasable erasable3, Erasable erasable4) {
        this.fUserIdentity = userIdentity;
        this.fEncryptedWebUserName = new EncryptedObject(erasable.get());
        this.fEncryptedLicenseInfo = new EncryptedObject(erasable2.get());
        this.fEncryptedLicenseID = new EncryptedObject(erasable3.get());
        this.fEncryptedLicenseNumber = new EncryptedObject(erasable4.get());
        this.fSalt = new byte[0];
        this.fEncrypted = false;
    }

    @Override
    public WebLicenseCredentials unpack(byte[] byArray, CryptoModule.Decryptor decryptor) throws CredentialCreationException {
        if (!this.fEncrypted) {
            return new WebLicenseCredentials(this.fUserIdentity, new Erasable(this.fEncryptedWebUserName.get()), new Erasable(this.fEncryptedLicenseInfo.get()), new Erasable(this.fEncryptedLicenseID.get()), new Erasable(this.fEncryptedLicenseNumber.get()));
        }
        try {
            Erasable erasable = decryptor.decryptWithSalt(this.fEncryptedWebUserName, byArray);
            Erasable erasable2 = decryptor.decryptWithSalt(this.fEncryptedLicenseInfo, byArray);
            Erasable erasable3 = decryptor.decryptWithSalt(this.fEncryptedLicenseID, byArray);
            Erasable erasable4 = decryptor.decryptWithSalt(this.fEncryptedLicenseNumber, byArray);
            return new WebLicenseCredentials(this.fUserIdentity, erasable, erasable2, erasable3, erasable4);
        }
        catch (CryptoException cryptoException) {
            throw new DecryptFailedException(this.fUserIdentity, (Throwable)cryptoException);
        }
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.fUserIdentity;
    }
}

