/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.credentials.consumer;

import com.mathworks.jmi.Support;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.GraphicalCredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.MatlabCommandWindowPrompt;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.TextualCredentialConsumer;
import javax.swing.JFrame;

public class MatlabCredentialConsumerFactory
extends CredentialConsumerFactory {
    private static final boolean DEFAULT_GRAPHICAL = true;
    private static final boolean DEFAULT_INTERACTIVE = true;
    private static CredentialConsumerFactory sDefaultFactory = null;
    private CredentialConsumer fCachedConsumer = null;
    private CredentialConsumerConfig fCachedConfig = null;
    private boolean fGraphical;
    private boolean fInteractive;

    public MatlabCredentialConsumerFactory(boolean bl, boolean bl2) {
        this.setGraphical(bl);
        this.setInteractive(bl2);
    }

    public MatlabCredentialConsumerFactory() {
        this(true, true);
    }

    @Override
    public CredentialConsumer create(CredentialConsumerConfig credentialConsumerConfig) throws ConsumerCreationException {
        assert (credentialConsumerConfig != null);
        if (this.fCachedConsumer == null || !credentialConsumerConfig.equals(this.fCachedConfig)) {
            this.fCachedConsumer = this.fGraphical ? this.createGraphicalConsumer(credentialConsumerConfig) : this.createTextualConsumer(credentialConsumerConfig);
            this.fCachedConfig = credentialConsumerConfig;
        }
        return this.fCachedConsumer;
    }

    @Override
    public boolean getGraphical() {
        return this.fGraphical;
    }

    @Override
    public void setGraphical(boolean bl) {
        if (bl != this.fGraphical) {
            this.fGraphical = bl;
            this.fCachedConsumer = null;
        }
    }

    @Override
    public boolean isInteractive() {
        return this.fInteractive;
    }

    @Override
    public void setInteractive(boolean bl) {
        this.fInteractive = bl;
    }

    @Override
    public MatlabCredentialConsumerFactory copy() {
        return new MatlabCredentialConsumerFactory(this.fGraphical, this.fInteractive);
    }

    public static CredentialConsumerFactory getDefault() {
        if (sDefaultFactory == null) {
            boolean bl = Support.useAWT() && Support.useSwing();
            boolean bl2 = true;
            sDefaultFactory = new MatlabCredentialConsumerFactory(bl, bl2);
        }
        return sDefaultFactory.copy();
    }

    public static void setDefault(CredentialConsumerFactory credentialConsumerFactory) {
        sDefaultFactory = credentialConsumerFactory;
    }

    private GraphicalCredentialConsumer createGraphicalConsumer(CredentialConsumerConfig credentialConsumerConfig) throws ConsumerCreationException {
        try {
            JFrame jFrame = null;
            return new GraphicalCredentialConsumer(jFrame, credentialConsumerConfig);
        }
        catch (Throwable throwable) {
            throw new NoDialogsException();
        }
    }

    private TextualCredentialConsumer createTextualConsumer(CredentialConsumerConfig credentialConsumerConfig) throws ConsumerCreationException {
        return new TextualCredentialConsumer(new MatlabCommandWindowPrompt(), credentialConsumerConfig);
    }

    private static final class NoDialogsException
    extends ConsumerCreationException {
        private final BaseMsgID fBaseMsgID = new mjs.NoDialogs();

        private NoDialogsException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

