/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.JobNotMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.LastMirrorFilesChore;
import com.mathworks.toolbox.distcomp.clusteraccess.Log;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesHelper;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.RemoteMachineChore;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

final class MirrorFilesChore
implements RemoteMachineChore {
    private final MirrorFilesHelper fHelper;
    private final FileMirrorControl fFileMirrorControl;
    private static final long fMinInterval = 100L;
    private static final long fMaxActiveInterval = 60000L;
    private static final long fMaxInactiveInterval = 300000L;
    private final Lock fLock = new ReentrantLock();
    private final Condition fCompleted = this.fLock.newCondition();
    private long fInterval = 100L;
    private boolean fOKToRun = false;
    private boolean fStartedOnce = false;
    private boolean fIsRunning = false;
    private boolean fSuccessful = true;
    private boolean fCanceled = false;
    private final List<Throwable> fThrowables = new ArrayList<Throwable>();

    MirrorFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        this.fHelper = new MirrorFilesHelper(mirrorFilesInfo, string, parameterMap);
        this.fFileMirrorControl = fileMirrorControl;
        this.fOKToRun = true;
    }

    String getHostname() {
        return this.fHelper.getHostname();
    }

    ParameterMap getParameterMap() {
        return this.fHelper.getParameterMap();
    }

    int getJobId() {
        return this.fHelper.getJobFileInfo().getJobId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LastMirrorFilesChore createLastFileMirrorChore() {
        try {
            this.fLock.lock();
            LastMirrorFilesChore lastMirrorFilesChore = new LastMirrorFilesChore(this, this.fFileMirrorControl);
            return lastMirrorFilesChore;
        }
        finally {
            this.fLock.unlock();
        }
    }

    MirrorFilesHelper copyHelper() throws InterruptedException {
        this.awaitSafePoint();
        return this.fHelper.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addThrowable(Throwable throwable) {
        try {
            this.fLock.lock();
            this.fThrowables.add(throwable);
            Log.LOGGER.log(Level.WARNING, this.logPrefix() + " caught exception", throwable);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        try {
            this.fLock.lock();
            this.fOKToRun = false;
            this.fCanceled = true;
            this.fHelper.cancel();
            Log.LOGGER.finest(this.logPrefix() + " fCompleted signaled");
            this.fCompleted.signalAll();
        }
        finally {
            this.fLock.unlock();
        }
        Log.LOGGER.fine(this.logPrefix() + "Canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitEnd() throws InterruptedException {
        Log.LOGGER.finest(this.logPrefix() + "Started awaiting end of mirroring");
        try {
            this.fLock.lock();
            while (!(!this.fIsRunning && this.fStartedOnce || this.fCanceled)) {
                this.fCompleted.await();
            }
            Log.LOGGER.finest(this.logPrefix() + "Finished awaiting end of mirroring");
            boolean bl = this.fSuccessful;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitSafePoint() throws InterruptedException {
        Log.LOGGER.finest(this.logPrefix() + "Started awaiting safe point in mirroring");
        try {
            this.fLock.lock();
            while (this.fIsRunning && !this.fCanceled) {
                this.fCompleted.await();
            }
            Log.LOGGER.finest(this.logPrefix() + "Finished awaiting safe point in mirroring");
            boolean bl = this.fSuccessful;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        try {
            this.fLock.lock();
            boolean bl = this.fStartedOnce && !this.fIsRunning || this.fCanceled;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> getProblems() {
        try {
            this.fLock.lock();
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>(this.fThrowables);
            return arrayList;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void run() {
        this.startedRun();
        if (this.isOKToRun()) {
            Log.LOGGER.fine(this.logPrefix() + "Started.");
            try {
                boolean bl = this.fHelper.runChore();
                this.completedRun(bl);
            }
            catch (JobNotMirroredException jobNotMirroredException) {
                this.completedRun(false);
                this.addThrowable(jobNotMirroredException);
            }
            catch (RuntimeException runtimeException) {
                this.completedRun(false);
                this.addThrowable(runtimeException);
            }
        } else {
            Log.LOGGER.finest(this.logPrefix() + " canceled before doing anything.");
            this.completedRun(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOKToRun() {
        try {
            this.fLock.lock();
            boolean bl = this.fOKToRun;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        try {
            this.fLock.lock();
            this.fOKToRun = false;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startedRun() {
        try {
            this.fLock.lock();
            this.fIsRunning = true;
            this.fStartedOnce = true;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completedRun(boolean bl) {
        try {
            this.fLock.lock();
            this.fIsRunning = false;
            this.fSuccessful = bl;
            if (this.isOKToRun()) {
                this.scheduleNextMirror();
            }
            this.fCompleted.signalAll();
            Log.LOGGER.fine(this.logPrefix() + "Completed and signaled. Successful? " + this.fSuccessful);
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextMirror() {
        long l;
        try {
            this.fLock.lock();
            boolean bl = this.fHelper.getAndResetReduceInterval();
            if (bl) {
                this.fInterval = 100L;
            } else {
                this.fInterval = 2L * this.fInterval;
                if (this.fInterval > 60000L) {
                    this.fInterval = 60000L;
                }
            }
            if (!this.fSuccessful) {
                this.fInterval = 300000L;
            }
            l = this.fInterval;
            Log.LOGGER.finest(this.logPrefix() + "interval is " + this.fInterval);
        }
        finally {
            this.fLock.unlock();
        }
        this.fFileMirrorControl.rescheduleMirrorChore(this, l);
    }

    @Override
    public String logPrefix() {
        return "Mirror files for job " + this.fHelper.getJobFileInfo().getJobId() + " on " + this.fHelper.getHostname() + ": ";
    }
}

