/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.clusteraccess;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.clusteraccess.CouldNotSendJobFilesException;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControl;
import com.mathworks.toolbox.distcomp.clusteraccess.FileMirrorControlException;
import com.mathworks.toolbox.distcomp.clusteraccess.JobAlreadyMirroredException;
import com.mathworks.toolbox.distcomp.clusteraccess.Log;
import com.mathworks.toolbox.distcomp.clusteraccess.MirrorFilesInfo;
import com.mathworks.toolbox.distcomp.clusteraccess.OneTimeChore;
import com.mathworks.toolbox.distcomp.clusteraccess.SharedPath;
import com.mathworks.toolbox.distcomp.remote.CopyToRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FileSystemManipulatorFuture;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.MakeDirectoryCommand;
import com.mathworks.toolbox.distcomp.remote.NoSuchProtocolException;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolProvider;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.spi.FileSystemManipulator;
import java.io.File;
import java.util.Set;

final class UploadFilesChore
extends OneTimeChore {
    private final MirrorFilesInfo fMirrorFilesInfo;

    UploadFilesChore(MirrorFilesInfo mirrorFilesInfo, String string, ParameterMap parameterMap, FileMirrorControl fileMirrorControl) {
        super(string, parameterMap, fileMirrorControl);
        this.fMirrorFilesInfo = mirrorFilesInfo;
    }

    @Override
    public boolean runChore() throws CouldNotSendJobFilesException, CouldNotMakeRemoteDataLocationException, JobAlreadyMirroredException {
        this.sendFiles();
        if (!this.hasBeenCanceled()) {
            this.getFileMirrorControl().startMirrorForJob(this.fMirrorFilesInfo);
            return true;
        }
        return false;
    }

    @Override
    FileSystemManipulatorFuture getFuture() throws InterruptedException {
        return (FileSystemManipulatorFuture)super.getFuture();
    }

    private void sendFiles() throws CouldNotSendJobFilesException, CouldNotMakeRemoteDataLocationException {
        try {
            FileSystemManipulator fileSystemManipulator = (FileSystemManipulator)ProtocolProvider.getInstance().getProtocolByType("sftp");
            if (this.fMirrorFilesInfo.getMakeRemoteDataLocationOnFirstUse()) {
                this.makeRemoteDataLocation(fileSystemManipulator);
            }
            for (SharedPath sharedPath : this.fMirrorFilesInfo.getDataFilePaths()) {
                this.sendFile(sharedPath, fileSystemManipulator);
            }
            for (SharedPath sharedPath : this.fMirrorFilesInfo.getStateFilePaths()) {
                this.sendFile(sharedPath, fileSystemManipulator);
            }
        }
        catch (NoSuchProtocolException noSuchProtocolException) {
            AssertionError assertionError = new AssertionError((Object)"Someone's removed sftp from the ProtocolProvider");
            ((Throwable)((Object)assertionError)).initCause(noSuchProtocolException);
            throw assertionError;
        }
    }

    private void makeRemoteDataLocation(FileSystemManipulator fileSystemManipulator) throws CouldNotMakeRemoteDataLocationException {
        if (!this.hasBeenCanceled()) {
            MakeDirectoryCommand makeDirectoryCommand = new MakeDirectoryCommand(this.fMirrorFilesInfo.getRemoteDataLocation(), true);
            Log.LOGGER.finest(this.logPrefix() + "About to make " + this.fMirrorFilesInfo.getRemoteDataLocation() + " if it does not exist");
            try {
                this.performRemoteCommand(makeDirectoryCommand, fileSystemManipulator, "Started making " + this.fMirrorFilesInfo.getRemoteDataLocation() + " for job " + this.fMirrorFilesInfo.getJobId());
            }
            catch (DispatchException dispatchException) {
                throw new CouldNotMakeRemoteDataLocationDispatchException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), dispatchException);
            }
            this.awaitEndOfMakingDirectory();
        }
    }

    private void awaitEndOfMakingDirectory() throws CouldNotMakeRemoteDataLocationException {
        try {
            if (!this.hasBeenCanceled()) {
                this.awaitEndOfFuture();
                Log.LOGGER.finer(this.logPrefix() + "Finished making " + this.fMirrorFilesInfo.getRemoteDataLocation());
            }
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotMakeRemoteDataLocationFulfillmentException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotMakeRemoteDataLocationInterruptedException(this.fMirrorFilesInfo.getJobId(), this.fMirrorFilesInfo.getRemoteDataLocation(), interruptedException);
        }
    }

    private void sendFile(SharedPath sharedPath, FileSystemManipulator fileSystemManipulator) throws CouldNotSendJobFilesException {
        if (!this.hasBeenCanceled()) {
            Set<File> set = SharedPath.sharedPathsToLocalFiles(this.fMirrorFilesInfo.getExcludeFromUpload(), this.fMirrorFilesInfo.getLocalDataLocation());
            CopyToRemoteCommand copyToRemoteCommand = new CopyToRemoteCommand(sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()), sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()), set);
            Log.LOGGER.finest(this.logPrefix() + "About to start to send " + sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()) + " to " + this.getHostname() + ":" + sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()));
            try {
                this.performRemoteCommand(copyToRemoteCommand, fileSystemManipulator, "Started sending " + sharedPath + " for job " + this.fMirrorFilesInfo.getJobId());
            }
            catch (DispatchException dispatchException) {
                throw new CouldNotSendJobFilesDispatchException(this.fMirrorFilesInfo.getJobId(), sharedPath, dispatchException);
            }
            this.awaitEndOfSendingFile(sharedPath);
        }
    }

    private void awaitEndOfSendingFile(SharedPath sharedPath) throws CouldNotSendJobFilesException {
        try {
            if (!this.hasBeenCanceled()) {
                this.awaitEndOfFuture();
                this.fMirrorFilesInfo.addToSentFiles(SharedPath.remotePathKeysToSharedPathKeys(this.getFuture().getFileAttributes(), this.fMirrorFilesInfo.getRemoteDataLocation()));
                Log.LOGGER.finer(this.logPrefix() + "Finished sending " + sharedPath.getLocalPath(this.fMirrorFilesInfo.getLocalDataLocation()) + " to " + this.getHostname() + ":" + sharedPath.getRemotePath(this.fMirrorFilesInfo.getRemoteDataLocation()));
            }
        }
        catch (FulfillmentException fulfillmentException) {
            throw new CouldNotSendJobFilesFulfillmentException(this.fMirrorFilesInfo.getJobId(), sharedPath, fulfillmentException);
        }
        catch (InterruptedException interruptedException) {
            throw new CouldNotSendJobFilesInterruptedException(this.fMirrorFilesInfo.getJobId(), sharedPath, interruptedException);
        }
    }

    @Override
    public String logPrefix() {
        return "Upload files for job " + this.fMirrorFilesInfo.getJobId() + " to " + this.getHostname() + ": ";
    }

    private static final class CouldNotSendJobFilesInterruptedException
    extends CouldNotSendJobFilesException {
        CouldNotSendJobFilesInterruptedException(int n, SharedPath sharedPath, InterruptedException interruptedException) {
            super(n, sharedPath, interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotSendJobFilesInterrupted(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotSendJobFilesInterrupted(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotSendJobFilesFulfillmentException
    extends CouldNotSendJobFilesException {
        CouldNotSendJobFilesFulfillmentException(int n, SharedPath sharedPath, FulfillmentException fulfillmentException) {
            super(n, sharedPath, fulfillmentException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotSendJobFilesFulfillment(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotSendJobFilesFulfillment(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotSendJobFilesDispatchException
    extends CouldNotSendJobFilesException {
        CouldNotSendJobFilesDispatchException(int n, SharedPath sharedPath, DispatchException dispatchException) {
            super(n, sharedPath, dispatchException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotSendJobFilesDispatch(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotSendJobFilesDispatch(this.getJobIdAsString(), this.getPathAsString(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotMakeRemoteDataLocationInterruptedException
    extends CouldNotMakeRemoteDataLocationException {
        CouldNotMakeRemoteDataLocationInterruptedException(int n, String string, InterruptedException interruptedException) {
            super(n, string, interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotMakeRemoteDataLocationInterrupted(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotMakeRemoteDataLocationInterrupted(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotMakeRemoteDataLocationFulfillmentException
    extends CouldNotMakeRemoteDataLocationException {
        CouldNotMakeRemoteDataLocationFulfillmentException(int n, String string, FulfillmentException fulfillmentException) {
            super(n, string, fulfillmentException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotMakeRemoteDataLocationFulfillment(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotMakeRemoteDataLocationFulfillment(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static final class CouldNotMakeRemoteDataLocationDispatchException
    extends CouldNotMakeRemoteDataLocationException {
        CouldNotMakeRemoteDataLocationDispatchException(int n, String string, RemoteExecutionException remoteExecutionException) {
            super(n, string, remoteExecutionException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CouldNotMakeRemoteDataLocationDispatch(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CouldNotMakeRemoteDataLocationDispatch(this.getJobIdAsString(), this.getRemoteDataLocation(), this.getExceptionCause().getLocalizedMessage());
        }
    }

    private static abstract class CouldNotMakeRemoteDataLocationException
    extends FileMirrorControlException {
        private String fRemoteDataLocation;
        private Throwable fCause;

        CouldNotMakeRemoteDataLocationException(int n, String string, Exception exception) {
            super(n);
            this.fRemoteDataLocation = string;
            this.fCause = exception;
        }

        protected String getRemoteDataLocation() {
            return this.fRemoteDataLocation;
        }

        protected Throwable getExceptionCause() {
            return this.fCause;
        }
    }
}

