/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.util.Version;

public final class CommandDialogHandShake {
    static final int COMMAND_SENDER_PROTOCOL = 2999;
    private static final int R2012BPROTOCOL = -1393754107;
    private static final int R2012BVERSION = 1936850996;
    private static final int R2012BVERSION_ADMINCENTER = 1936851024;

    private CommandDialogHandShake() {
    }

    static void checkProtocolAndVersion(int n, int n2) throws HandShakeException {
        if (2999 == n) {
            if (20 != n2) {
                String string = Version.getVersionStringFromNumber(n2);
                if (!string.isEmpty()) {
                    throw new WrongVersionException(string);
                }
                throw new UnknownVersionException(n2);
            }
        } else {
            if (-1393754107 == n && (1936850996 == n2 || 1936851024 == n2)) {
                throw new Pre2013aVersionException();
            }
            throw new UnknownProtocolException(n, n2);
        }
    }

    private static final class UnknownProtocolException
    extends HandShakeException {
        private final BaseMsgID fBaseMsgID;

        private UnknownProtocolException(int n, int n2) {
            this.fBaseMsgID = new mjs.UnknownProtocol(Integer.toString(n), Integer.toString(n2), Version.VERSION_STRING);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class Pre2013aVersionException
    extends HandShakeException {
        private final BaseMsgID fBaseMsgID = new mjs.Pre2013aVersion(Version.VERSION_STRING);

        private Pre2013aVersionException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WrongVersionException
    extends HandShakeException {
        private final BaseMsgID fBaseMsgID;

        private WrongVersionException(String string) {
            this.fBaseMsgID = new mjs.WrongVersion(string, Version.VERSION_STRING);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class UnknownVersionException
    extends HandShakeException {
        private final BaseMsgID fBaseMsgID;

        private UnknownVersionException(int n) {
            this.fBaseMsgID = new mjs.UnknownVersion(Integer.toString(n), Version.VERSION_STRING);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    static abstract class HandShakeException
    extends DispatchException {
        private HandShakeException() {
        }
    }
}

