/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.Log;
import com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client.PeerSCShellSender;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Environment;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.ShellCommand;
import com.mathworks.toolbox.distcomp.remote.ShellFuture;
import com.mathworks.toolbox.distcomp.remote.spi.ShellCommandSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.LocalShellSender;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.ShellParameter;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.net.SocketException;
import java.util.LinkedHashMap;

public final class PeerOrLocalShellSender
implements ShellCommandSender {
    private static final String PROTOCOL_NAME = "winsc-shell";
    private static final String PROTOCOL_TYPE = "winsc";
    public static final ParameterSet PEER_OR_LOCAL_PARAMETER_SET = new ParameterSet(PeerOrLocalParameter.RESTRICT, PeerSCShellSender.PeerSCParameter.PORT, PathUtils.MatlabRootParameter.MATLAB_ROOT, LocalShellSender.LocalParameter.COMMAND, LocalShellSender.LocalParameter.FLAG, LocalShellSender.LocalParameter.DIRECTORY, ShellParameter.LOCAL_ENVIRONMENT);

    @Override
    public ParameterSet getParameterSet() {
        return PEER_OR_LOCAL_PARAMETER_SET;
    }

    @Override
    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    @Override
    public String getProtocolType() {
        return PROTOCOL_TYPE;
    }

    @Override
    public Class<? extends Command> getCommandClass() {
        return ShellCommand.class;
    }

    @Override
    public ShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
        parameterMap.checkParameters(PEER_OR_LOCAL_PARAMETER_SET);
        Restrict restrict = parameterMap.getOrSuggest(PeerOrLocalParameter.RESTRICT);
        return restrict.sendAndRun(shellCommand, string, parameterMap);
    }

    @Override
    public Future execute(Command command, String string, ParameterMap parameterMap) throws DispatchException {
        return this.sendAndRun((ShellCommand)command, string, parameterMap);
    }

    public static class PeerOrLocalParameter<V>
    extends ParameterImpl<V> {
        public static final Parameter<Restrict> RESTRICT = new PeerOrLocalParameter<Restrict>(Key.RESTRICT, false, false, Restrict.class, Restrict.ANY);

        private PeerOrLocalParameter(Parameter.PersistentKey persistentKey, boolean bl, boolean bl2, Class<V> clazz, V v) {
            super(persistentKey, bl, bl2, clazz, v);
        }

        @Override
        protected String getSimpleName() {
            return PeerOrLocalParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            RESTRICT;

        }
    }

    private static final class ProtocolDispatchPeerOrLocalShellException
    extends ProtocolDispatchException {
        private final BaseMsgID fBaseMsgID;

        ProtocolDispatchPeerOrLocalShellException(String string, SocketException socketException) {
            super(socketException);
            this.fBaseMsgID = new remote.PeerOrLocalShell(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    public static enum Restrict {
        JUST_LOCAL{
            private final LocalShellSender fLocalShellSender = new LocalShellSender();

            @Override
            ShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
                ParameterMap parameterMap2 = parameterMap.createCopyRetaining(this.fLocalShellSender.getParameterSet());
                return this.fLocalShellSender.sendAndRun(shellCommand, parameterMap2);
            }
        }
        ,
        JUST_PEER{
            private final PeerSCShellSender fPeerSCShellSender = new PeerSCShellSender();

            @Override
            ShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
                ParameterMap parameterMap2 = parameterMap.createCopyRetaining(this.fPeerSCShellSender.getParameterSet());
                Environment environment = parameterMap2.get(ShellParameter.LOCAL_ENVIRONMENT);
                if (environment == null) {
                    Log.LOGGER.info("LOCAL_ENVIRONMENT was not specified - using USERDOMAIN from current environment.");
                    String string2 = System.getenv("USERDOMAIN");
                    if (string2 != null) {
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        linkedHashMap.put("USERDOMAIN", string2);
                        boolean bl = false;
                        Environment environment2 = new Environment(linkedHashMap, bl);
                        parameterMap2.put(ShellParameter.LOCAL_ENVIRONMENT, environment2);
                    }
                }
                return this.fPeerSCShellSender.sendAndRun(shellCommand, string, parameterMap2);
            }
        }
        ,
        ANY{

            @Override
            ShellFuture sendAndRun(ShellCommand shellCommand, String string, ParameterMap parameterMap) throws DispatchException {
                try {
                    if (LocalShellSender.isLocalhost(string)) {
                        return JUST_LOCAL.sendAndRun(shellCommand, string, parameterMap);
                    }
                    return JUST_PEER.sendAndRun(shellCommand, string, parameterMap);
                }
                catch (SocketException socketException) {
                    throw new ProtocolDispatchPeerOrLocalShellException(string, socketException);
                }
            }
        };


        abstract ShellFuture sendAndRun(ShellCommand var1, String var2, ParameterMap var3) throws DispatchException;
    }
}

