/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractExecutableCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.distcomp.local.ProcessUtilities;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Callable;

final class ConcurrentTaskCommand
implements Callable<Integer> {
    private final int fLabRank;
    private final FileOutputStream fOutputStream;
    private final int fNumLabs;
    private final AbstractExecutableCommand fCommand;
    private Process fProcess;

    ConcurrentTaskCommand(int n, int n2, AbstractExecutableCommand abstractExecutableCommand, FileOutputStream fileOutputStream) {
        this.fLabRank = n;
        this.fOutputStream = fileOutputStream;
        this.fNumLabs = n2;
        this.fCommand = abstractExecutableCommand;
    }

    Process getProcess() {
        return this.fProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws IOException {
        Integer n = 1;
        boolean bl = false;
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("MDCE_NUMLABS", Integer.toString(this.fNumLabs));
            hashMap.put("MDCE_LABINDEX", Integer.toString(this.fLabRank + 1));
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "About to start process with labindex " + (this.fLabRank + 1));
            this.fProcess = this.fCommand.createProcessFromBuilderWithRetry(hashMap);
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Created process with labindex " + (this.fLabRank + 1));
            String string = "[" + this.fLabRank + "]";
            n = ProcessUtilities.waitForProcessWithRedirection(this.fProcess, this.fCommand.getStreamRedirector(), this.fOutputStream, string);
            bl = true;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (bl) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Process with labindex " + (this.fLabRank + 1) + " has finished with code: " + n);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Process with labindex " + (this.fLabRank + 1) + " is about to be destroyed.");
                if (this.fProcess != null) {
                    this.fProcess.destroy();
                }
            }
        }
        return n;
    }
}

