/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.Predicate;
import com.mathworks.toolbox.parallel.util.concurrent.PredicateCondition;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.util.LinkedList;

class TokenManager {
    private ReentrantLock fDataLock;
    private int fTotalTokens;
    private int fAvailableTokens;
    private LinkedList<WaitingToken> fWaitingTokens;

    TokenManager(int n) {
        this.fTotalTokens = n;
        this.fAvailableTokens = n;
        this.fWaitingTokens = new LinkedList();
        this.fDataLock = new ReentrantLock();
    }

    SemaphoreToken acquire(int n) throws InterruptedException {
        return this.acquire(n, n);
    }

    /*
     * Loose catch block
     */
    SemaphoreToken acquire(int n, int n2) throws InterruptedException {
        assert (n <= n2) : "Min number requested must be less than or equal to max";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Entering TokenManager.acquire with min = " + n + ", max = " + n2 + ". fTotalTokens: " + this.fTotalTokens + ", fAvailableTokens: " + this.fAvailableTokens);
        this.fDataLock.lockInterruptibly();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Acquired TokenManager lock (" + this.fDataLock + ") for TokenManager.acquire");
            if (n > this.fTotalTokens) {
                throw new IllegalStateException("Too many licenses requested");
            }
            if (n <= this.fAvailableTokens && this.fWaitingTokens.isEmpty()) {
                int n3 = Math.min(n2, this.fAvailableTokens);
                this.fAvailableTokens -= n3;
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "TokenManager.acquire(" + n + "," + n2 + ") actually acquired " + n3 + ", fAvailableTokens now: " + this.fAvailableTokens);
                SemaphoreToken semaphoreToken = new SemaphoreToken(n3, this);
                return semaphoreToken;
            }
            WaitingToken waitingToken = new WaitingToken(n, n2);
            this.fWaitingTokens.add(waitingToken);
            try {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "About to wait for tokens to become available");
                waitingToken.await();
                if (waitingToken.fException != null) {
                    throw waitingToken.fException;
                }
                assert (waitingToken.fNumAcquired >= n) : "Incorrect number acquired";
                SemaphoreToken semaphoreToken = new SemaphoreToken(waitingToken.fNumAcquired, this);
                return semaphoreToken;
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Caught InterruptedException whilst waiting for tokens");
                this.fWaitingTokens.remove(waitingToken);
                if (waitingToken.fNumAcquired > 0) {
                    this.release(waitingToken.fNumAcquired);
                }
                throw interruptedException;
            }
            finally {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Finished waiting for tokens to become available");
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.fDataLock.unlock();
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Released TokenManager lock (" + this.fDataLock + ")");
        }
    }

    void release(SemaphoreToken semaphoreToken) {
        int n = semaphoreToken.setReleased();
        if (n > 0) {
            this.release(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(int n) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Entering TokenManager.release with num = " + n);
        this.fDataLock.lock();
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Acquired TokenManager lock (" + this.fDataLock + ") for TokenManager.release");
            this.fAvailableTokens += n;
            this.fAvailableTokens = Math.min(this.fTotalTokens, this.fAvailableTokens);
            while (!this.fWaitingTokens.isEmpty()) {
                WaitingToken waitingToken = this.fWaitingTokens.getFirst();
                if (waitingToken.fMinRequested > this.fTotalTokens) {
                    waitingToken.fException = new IllegalStateException("Too many licenses requested");
                } else if (waitingToken.fMinRequested <= this.fAvailableTokens) {
                    waitingToken.fNumAcquired = Math.min(waitingToken.fMaxRequested, this.fAvailableTokens);
                    this.fAvailableTokens -= waitingToken.fNumAcquired;
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "TokenManager waiting token being given: " + waitingToken.fNumAcquired + ", fAvailableTokens now: " + this.fAvailableTokens);
                } else {
                    return;
                }
                this.fWaitingTokens.removeFirst();
                waitingToken.signal();
            }
        }
        finally {
            this.fDataLock.unlock();
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Released TokenManager lock (" + this.fDataLock + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTotalNumberOfTokens(int n) {
        assert (n > 0) : "Total number of licenses must be greater than zero";
        this.fDataLock.lock();
        try {
            int n2 = this.fTotalTokens;
            int n3 = n - n2;
            this.fTotalTokens = n;
            this.release(n3);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "TokenManager.setTotalNumberOfTokens(" + n + ") changed " + "from " + n2 + " with change of " + n3);
        }
        finally {
            this.fDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfTokens() {
        this.fDataLock.lock();
        try {
            int n = this.fTotalTokens;
            return n;
        }
        finally {
            this.fDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfAvailableTokens() {
        this.fDataLock.lock();
        try {
            int n = this.fAvailableTokens;
            return n;
        }
        finally {
            this.fDataLock.unlock();
        }
    }

    static class SemaphoreToken
    implements AutoCloseable {
        private int fNumAcquired;
        private boolean fTokenHasBeenReleased = false;
        private TokenManager fTokenManager;

        private SemaphoreToken(int n, TokenManager tokenManager) {
            this.fNumAcquired = n;
            this.fTokenManager = tokenManager;
        }

        public synchronized int getNumberAcquired() {
            return this.fNumAcquired;
        }

        public synchronized boolean hasBeenReleased() {
            return this.fTokenHasBeenReleased;
        }

        @Override
        public void close() {
            this.fTokenManager.release(this);
        }

        private synchronized int setReleased() {
            if (this.fTokenHasBeenReleased) {
                return 0;
            }
            this.fTokenHasBeenReleased = true;
            return this.fNumAcquired;
        }
    }

    private class WaitingToken {
        private final int fMaxRequested;
        private final int fMinRequested;
        private int fNumAcquired;
        private IllegalStateException fException;
        private boolean fSignalled;
        private final PredicateCondition fCondition;

        private WaitingToken(int n, int n2) {
            this.fMaxRequested = n2;
            this.fMinRequested = n;
            this.fNumAcquired = -1;
            this.fException = null;
            this.fSignalled = false;
            this.fCondition = TokenManager.this.fDataLock.newPredicateCondition(new Predicate(){

                public boolean test() {
                    return WaitingToken.this.fSignalled;
                }
            });
        }

        void await() throws InterruptedException {
            this.fCondition.await();
        }

        void signal() {
            this.fSignalled = true;
            this.fCondition.signal();
        }
    }
}

