/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerlookupservice;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.Log;
import com.mathworks.toolbox.distcomp.mjs.peerlookupservice.LookupServiceDispatcher;
import com.mathworks.toolbox.distcomp.pmode.io.DirectCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerPassiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ProtocolId;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.UUID;
import java.util.logging.Level;

public final class PeerLookupService {
    private static final String PREFIX = "PeerLookupService: ";
    static final UUID LOOKUP_SERVICE_GROUP_UUID = UUID.fromString("4689e3f7-1c95-4d37-98ec-6ec6696fdf56");
    private static final String URI_SCHEME = "peerlookup";
    private final PeerSession fPeerSession;
    private final PeerPassiveAcceptor fAcceptor;
    private final String fStringDescription;

    public PeerLookupService(String string, int n, int n2, AcceptorSecurityDescription acceptorSecurityDescription, Accessor accessor) throws AbstractPeerAcceptor.InitializeServerSocketChannelException, DistcompException {
        PeerInstance peerInstance = new PeerInstance(ProtocolId.MJS, LOOKUP_SERVICE_GROUP_UUID, UUID.randomUUID());
        ServerSocketAcceptInfo serverSocketAcceptInfo = ServerSocketAcceptInfo.createServerSocketAcceptInfo(DirectCommunicationGroup.class, LOOKUP_SERVICE_GROUP_UUID, n, n2, acceptorSecurityDescription);
        this.fPeerSession = PeerLookupService.initializeSession(peerInstance, serverSocketAcceptInfo, accessor);
        this.fAcceptor = this.initializeAcceptor(peerInstance, string, serverSocketAcceptInfo);
        this.fStringDescription = PeerLookupService.createLookupServiceURI(string, n) + " --> " + accessor.toString();
    }

    static URI createLookupServiceURI(String string, int n) {
        try {
            return new URI(URI_SCHEME, null, string, n, null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    static boolean isPeerLookupScheme(URI uRI) {
        return URI_SCHEME.equals(uRI.getScheme());
    }

    public PeerLookupService() {
        this.fPeerSession = null;
        this.fAcceptor = null;
        this.fStringDescription = "Not Enabled";
    }

    public void shutDown() {
        this.fAcceptor.close();
        this.fPeerSession.normalShutdown();
    }

    public String toString() {
        return PREFIX + this.fStringDescription;
    }

    private static PeerSession initializeSession(PeerInstance peerInstance, ServerSocketAcceptInfo serverSocketAcceptInfo, Accessor accessor) throws DistcompException {
        HashSet<PeerDispatcher<? extends Message>> hashSet = new HashSet<PeerDispatcher<? extends Message>>(1);
        LookupServiceDispatcher lookupServiceDispatcher = new LookupServiceDispatcher(accessor);
        hashSet.add(lookupServiceDispatcher);
        return new PeerSession(serverSocketAcceptInfo, peerInstance, new DoNothingErrorHandler(), hashSet);
    }

    private PeerPassiveAcceptor initializeAcceptor(PeerInstance peerInstance, String string, ServerSocketAcceptInfo serverSocketAcceptInfo) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        PeerPassiveAcceptor peerPassiveAcceptor = new PeerPassiveAcceptor(string, peerInstance, serverSocketAcceptInfo, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.LOGGER.log(Level.SEVERE, "Uncaught exception in PeerPassiveAcceptor. Shutting down the peer lookup service.", throwable);
                PeerLookupService.this.shutDown();
            }
        });
        peerPassiveAcceptor.startAccepting(this.createConnectionHandler());
        return peerPassiveAcceptor;
    }

    private PeerPassiveAcceptor.ConnectionHandler createConnectionHandler() {
        return new PeerPassiveAcceptor.ConnectionHandler(){

            @Override
            public void newConnection(Connection connection) {
                Log.LOGGER.log(DistcompLevel.FOUR, "PeerLookupService: Accepted " + connection);
                try {
                    PeerLookupService.this.fPeerSession.addConnection(connection);
                }
                catch (RuntimeException runtimeException) {
                    Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupService: Failed to add " + connection + " to session.", runtimeException);
                    this.safeCloseConnection(connection);
                }
            }

            private void safeCloseConnection(Connection connection) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(DistcompLevel.FOUR, "PeerLookupService: Failed to close " + connection, iOException);
                }
            }
        };
    }

    private static class DoNothingErrorHandler
    implements ErrorHandler {
        private DoNothingErrorHandler() {
        }

        @Override
        public void readError(Instance instance, Throwable throwable) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupService: readError from " + instance, throwable);
        }

        @Override
        public void writeError(Instance instance, Throwable throwable) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupService: writeError from " + instance, throwable);
        }

        @Override
        public void lostCommunication(Instance instance, Throwable throwable) {
            if (throwable instanceof EOFException) {
                Log.LOGGER.log(DistcompLevel.SIX, "PeerLookupService: lostCommunication due to EOF from " + instance);
            } else {
                Log.LOGGER.log(DistcompLevel.SIX, "PeerLookupService: lostCommunication to " + instance, throwable);
            }
        }

        @Override
        public void executorError(Throwable throwable) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupService: executorError", throwable);
        }

        @Override
        public void communicationError(Error error) {
            Log.LOGGER.log(DistcompLevel.ONE, "PeerLookupService: communicationError", error);
        }

        @Override
        public void activate(ShutdownHandler shutdownHandler) {
        }

        @Override
        public void deactivate() {
        }
    }
}

