/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.peerrmi.messages;

import com.mathworks.toolbox.distcomp.mjs.peerrmi.Log;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.ObjectRegistry;
import com.mathworks.toolbox.distcomp.mjs.peerrmi.messages.InvocationReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;

public final class InvocationMessage
implements ObservableMessage {
    private static final String TAG = InvocationMessage.class.getSimpleName();
    private static final AtomicLong sSequenceGenerator = new AtomicLong(1L);
    private final String fMethodName;
    private final Class<?>[] fParameterTypes;
    private final ObjectRegistry.ID fObjectId;
    private final Object[] fArguments;
    private final long fSequenceNumber = sSequenceGenerator.getAndIncrement();

    public InvocationMessage(ObjectRegistry.ID iD, String string, Class<?>[] classArray, Object[] objectArray) {
        this.fMethodName = string;
        this.fParameterTypes = classArray;
        this.fObjectId = iD;
        this.fArguments = objectArray;
    }

    @Override
    public long getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public ObjectRegistry.ID getObjectId() {
        return this.fObjectId;
    }

    protected Object invokeMethod(Remote remote2) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Method method = remote2.getClass().getMethod(this.fMethodName, this.fParameterTypes);
        Log.LOGGER.info(TAG + ": Invoking " + method.getDeclaringClass().getSimpleName() + "." + this.fMethodName + " on " + remote2);
        return method.invoke((Object)remote2, this.fArguments);
    }

    public InvocationReturnMessage invoke(Remote remote2, long l) {
        try {
            Object object = this.invokeMethod(remote2);
            return new InvocationReturnMessage(l, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            return new InvocationReturnMessage(l, invocationTargetException.getTargetException());
        }
        catch (IllegalAccessException illegalAccessException) {
            return new InvocationReturnMessage(l, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new InvocationReturnMessage(l, noSuchMethodException);
        }
    }

    public String toString() {
        return "InvocationMessage{fMethodName='" + this.fMethodName + '\'' + ", fParameterTypes=" + (this.fParameterTypes == null ? null : Arrays.asList(this.fParameterTypes)) + ", fObjectId=" + this.fObjectId + ", fArguments=" + (this.fArguments == null ? null : Arrays.asList(this.fArguments)) + ", fSequenceNumber=" + this.fSequenceNumber + '}';
    }
}

