/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mwlogin;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.webservices;
import com.mathworks.toolbox.distcomp.mwlogin.AuthenticationRequiredDialog;
import com.mathworks.toolbox.distcomp.mwlogin.BlockableValidationStrategy;
import com.mathworks.toolbox.distcomp.mwlogin.EmptyUserTokenPair;
import com.mathworks.toolbox.distcomp.mwlogin.Expirable;
import com.mathworks.toolbox.distcomp.mwlogin.Log;
import com.mathworks.toolbox.distcomp.mwlogin.MJSValidationStrategy;
import com.mathworks.toolbox.distcomp.mwlogin.SimpleExpirable;
import com.mathworks.toolbox.distcomp.mwlogin.UserTokenPair;
import com.mathworks.toolbox.distcomp.mwlogin.ValidationFailedException;
import com.mathworks.widgets.login.CompletionStatus;
import com.mathworks.widgets.login.FailureType;
import com.mathworks.widgets.login.ValidationConsumer;
import com.mathworks.widgets.login.ValidationStrategy;
import com.mathworks.widgets.login.ValidationWorkFlow;
import com.mathworks.widgets.login.WorkFlowReturn;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.logging.Level;

public class LoginTokenValidation {
    private BlockableValidationStrategy fValidationStrategy = null;
    private ValidationWorkFlow fValidationWorkFlow = null;
    private Callable<Integer> fShowAuthenticationRequiredCallback = null;
    private static Expirable<UserTokenPair> sUserTokenPair = new EmptyUserTokenPair();

    public LoginTokenValidation(boolean bl) {
        MJSValidationStrategy mJSValidationStrategy = new MJSValidationStrategy(bl);
        this.initialize(bl, mJSValidationStrategy);
    }

    public LoginTokenValidation(boolean bl, ValidationConsumer validationConsumer) {
        ValidationConsumerProvider validationConsumerProvider = new ValidationConsumerProvider(bl, validationConsumer);
        this.initialize(bl, validationConsumerProvider);
    }

    private void initialize(boolean bl, MJSValidationStrategy mJSValidationStrategy) {
        if (bl) {
            LoginTokenValidation.clearPersistedToken();
        }
        this.fValidationStrategy = mJSValidationStrategy;
        this.fValidationWorkFlow = new ValidationWorkFlow((ValidationStrategy)this.fValidationStrategy);
        this.fShowAuthenticationRequiredCallback = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                if (!LoginTokenValidation.this.fValidationStrategy.getLoginPersistenceStrategy().readLoginToken().isEmpty()) {
                    return 0;
                }
                Component component = null;
                if (LoginTokenValidation.this.fValidationStrategy.getValidationConsumer() != null) {
                    component = LoginTokenValidation.this.fValidationStrategy.getValidationConsumer().getInvoker();
                }
                return AuthenticationRequiredDialog.showDialog(component);
            }
        };
    }

    public LoginTokenValidation(BlockableValidationStrategy blockableValidationStrategy, ValidationWorkFlow validationWorkFlow) {
        this.fValidationStrategy = blockableValidationStrategy;
        this.fValidationWorkFlow = validationWorkFlow;
        this.fShowAuthenticationRequiredCallback = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return 0;
            }
        };
    }

    public UserTokenPair validate() throws ValidationFailedException {
        UserTokenPair userTokenPair = sUserTokenPair.getValue();
        if (userTokenPair != null) {
            return userTokenPair;
        }
        Integer n = null;
        try {
            n = this.fShowAuthenticationRequiredCallback.call();
        }
        catch (Exception exception) {
            Log.LOGGER.log(Level.FINEST, "Unexpected exception from calling show authentication dialog.", exception);
        }
        if (n != null && n == 1) {
            return null;
        }
        this.fValidationWorkFlow.startWorkFlow();
        try {
            this.fValidationStrategy.awaitComplete();
        }
        catch (InterruptedException interruptedException) {
            this.fValidationWorkFlow.cancelWorkFlow();
            throw new ValidationDidNotCompleteException(interruptedException);
        }
        WorkFlowReturn workFlowReturn = this.fValidationStrategy.getWorkFlowReturn();
        CompletionStatus completionStatus = workFlowReturn.getCompletionStatus();
        if (!completionStatus.equals((Object)CompletionStatus.SUCCEEDED)) {
            if (completionStatus.equals((Object)CompletionStatus.CANCELLED)) {
                return null;
            }
            FailureType failureType = workFlowReturn.getFailureType();
            switch (failureType) {
                case AUTHENTICATION_FAILURE: {
                    return null;
                }
                case NOT_SUPPORTED: {
                    LoginNotSupportedException loginNotSupportedException = new LoginNotSupportedException();
                    Log.LOGGER.log(Level.WARNING, "Login attempted in unsupported environment", loginNotSupportedException);
                    throw loginNotSupportedException;
                }
            }
            UnknownFailureTypeException unknownFailureTypeException = new UnknownFailureTypeException(completionStatus, failureType);
            Log.LOGGER.log(Level.SEVERE, "An unknown failure type was encountered", unknownFailureTypeException);
            throw unknownFailureTypeException;
        }
        String string = workFlowReturn.getLoginResponse().getToken();
        String string2 = workFlowReturn.getLoginResponse().getMwaUserName();
        userTokenPair = new UserTokenPair(string2, string);
        LoginTokenValidation.cacheToken(new SimpleExpirable<UserTokenPair>(userTokenPair));
        return userTokenPair;
    }

    private static void cacheToken(Expirable<UserTokenPair> expirable) {
        sUserTokenPair = expirable;
    }

    public static void clearPersistedToken() {
        sUserTokenPair.expireNow();
    }

    public static class UnknownFailureTypeException
    extends ValidationFailedException {
        UnknownFailureTypeException(CompletionStatus completionStatus, FailureType failureType) {
            super((BaseMsgID)new webservices.UnknownFailureType(completionStatus.name(), failureType.name()));
        }
    }

    public static class LoginNotSupportedException
    extends ValidationFailedException {
        LoginNotSupportedException() {
            super((BaseMsgID)new webservices.LoginNotSupported());
        }
    }

    public static class ValidationDidNotCompleteException
    extends ValidationFailedException {
        ValidationDidNotCompleteException(Exception exception) {
            super((BaseMsgID)new webservices.ValidationDidNotComplete(), exception);
        }
    }

    private static class ValidationConsumerProvider
    extends MJSValidationStrategy {
        private final ValidationConsumer fValidationConsumer;

        ValidationConsumerProvider(boolean bl, ValidationConsumer validationConsumer) {
            super(bl);
            this.fValidationConsumer = validationConsumer;
        }

        public ValidationConsumer getValidationConsumer() {
            Log.LOGGER.log(Level.FINEST, "Using the provided login dialog consumer: " + this.fValidationConsumer);
            return this.fValidationConsumer;
        }
    }
}

