/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pml;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.resources.parallel.job;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.pml.LabCompatibilityChecker;
import com.mathworks.toolbox.distcomp.pml.PackageInfo;
import com.mathworks.toolbox.distcomp.pml.ParallelJob;
import com.mathworks.toolbox.distcomp.pml.ParallelJobSingleTaskException;
import com.mathworks.toolbox.distcomp.pml.SimultaneousTasksJobImpl;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.worker.Worker;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.toolbox.distcomp.workunit.WorkerSortStrategy;
import com.mathworks.toolbox.distcomp.workunit.WorkerTaskInfo;
import com.mathworks.toolbox.distcomp.workunit.messages.CancelMessage;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collection;
import java.util.Vector;

public class ParallelJobImpl
extends SimultaneousTasksJobImpl
implements ParallelJob {
    private static final WorkerSortStrategy DEFAULT_PARALLEL_STRATEGY = WorkerSortStrategy.FEWEST_MACHINES;

    public ParallelJobImpl(int n, String string) {
        super(n, string);
        this.setWorkerSortStrategy(DEFAULT_PARALLEL_STRATEGY);
    }

    public ParallelJobImpl(int n, String string, TimeProvider timeProvider) {
        super(n, string, timeProvider);
        this.setWorkerSortStrategy(DEFAULT_PARALLEL_STRATEGY);
    }

    @Override
    protected MJSException oneTaskOnlyException() {
        return new ParallelJobSingleTaskException();
    }

    @Override
    public String workUnitTypeForPrinting() {
        return "parallel job";
    }

    @Override
    protected void taskCompleted(TaskImpl taskImpl) throws MJSException {
        super.taskCompleted(taskImpl);
        int n = this.getJobStorage().countTasksByJobID(this.getID());
        if (taskImpl.isFinishedAbnormally() && (this.fState != 0 || n != 0)) {
            long l = taskImpl.getNum();
            String string = taskImpl.getErrorMessage();
            this.cancel(new TaskOfParallelJobAbortedAbnormallyMessage(l, string));
        }
    }

    @Override
    protected void checkTotalNumberOfWorkers(Worker[][] workerArray) throws MJSException {
        Worker[] workerArray2 = workerArray[0];
        Worker[] workerArray3 = workerArray[1];
        Worker[] workerArray4 = new Worker[workerArray2.length + workerArray3.length];
        System.arraycopy(workerArray2, 0, workerArray4, 0, workerArray2.length);
        System.arraycopy(workerArray3, 0, workerArray4, workerArray2.length, workerArray3.length);
        Worker[][] workerArray5 = LabCompatibilityChecker.instance().getCompatibleLabs(workerArray4);
        int n = 0;
        for (Worker[] workerArray6 : workerArray5) {
            if (workerArray6.length <= n) continue;
            n = workerArray6.length;
        }
        if (this.fMinWorkers > n) {
            if (n < workerArray4.length) {
                this.cancelJobBeforeRunning(new NotEnoughCompatibleWorkersMessage(this.fMinWorkers, this.fMaxWorkers, n));
            } else {
                this.cancelJobBeforeRunning(new NotEnoughWorkersMessage(this.fMinWorkers, this.fMaxWorkers));
            }
        }
    }

    @Override
    protected Worker[] chooseIdleWorkersForQueuedJob(Worker[][] workerArray) {
        Worker[] workerArray2 = workerArray[0];
        Worker[][] workerArray3 = LabCompatibilityChecker.instance().getCompatibleLabs(workerArray2);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < workerArray3.length; ++i) {
            if (workerArray3[i].length <= n) continue;
            n = workerArray3[i].length;
            n2 = i;
        }
        if (n < this.fMinWorkers) {
            return null;
        }
        return workerArray3[n2];
    }

    @Override
    protected Worker[] chooseIdleWorkersForRunningJob(Worker[][] workerArray) {
        return this.chooseIdleWorkersForQueuedJob(workerArray);
    }

    @Override
    protected Collection<WorkerTaskInfo> rerunTask(TaskImpl taskImpl, CancelMessage cancelMessage) throws MJSException {
        return this.rerunJob(new ParallelJobRerunMessage(this.workUnitTypeForPrinting(), taskImpl.getNum(), cancelMessage));
    }

    @Override
    protected void checkJobCanRerun() throws WorkUnitStateException, StorageException {
        TaskImpl taskImpl;
        super.checkJobCanRerun();
        try {
            taskImpl = (TaskImpl)this.getJobStorage().readWorkUnit(this.getLeadingTaskUuid());
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Could not read leading task from database", workUnitNotFoundException);
            throw new NoLeadingTaskException(workUnitNotFoundException, this.workUnitTypeForPrinting());
        }
        taskImpl.checkTaskCanRerun();
    }

    @Override
    protected Collection<WorkerTaskInfo> prepareTaskToRerun(TaskImpl taskImpl, CancelMessage cancelMessage) throws MJSException {
        Vector<WorkerTaskInfo> vector = new Vector<WorkerTaskInfo>();
        vector.add(taskImpl.getWorkerTaskInfo());
        if (this.isLeadingTask(taskImpl.getID())) {
            taskImpl.setErrorIdentifier("distcomp:task:Cancelled");
            taskImpl.setErrorMessage(cancelMessage.getLocalizedMessage());
            taskImpl.prepareToRerun();
        } else {
            taskImpl.destroyWithoutNotifyingJob(false);
        }
        return vector;
    }

    @Override
    protected void prepareToRerun() throws MJSException {
        this.setParallelTag("");
        this.resetTaskSequenceNum();
        super.prepareToRerun();
    }

    private static final class NoLeadingTaskException
    extends WorkUnitStateException {
        private final BaseMsgID fMessageID;

        NoLeadingTaskException(WorkUnitNotFoundException workUnitNotFoundException, String string) {
            super(workUnitNotFoundException);
            this.fMessageID = new job.NoLeadingTask(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class ParallelJobRerunMessage
    extends SimpleCancelMessage {
        ParallelJobRerunMessage(String string, long l, CancelMessage cancelMessage) {
            super((BaseMsgID)new mjs.ParallelJobRerun(string, Long.toString(l), cancelMessage.getLocalizedMessage()));
        }
    }

    private static final class NotEnoughWorkersMessage
    extends SimpleCancelMessage {
        NotEnoughWorkersMessage(int n, int n2) {
            super((BaseMsgID)new mjs.NotEnoughWorkers(Integer.toString(n), Integer.toString(n2)));
        }
    }

    private static final class NotEnoughCompatibleWorkersMessage
    extends SimpleCancelMessage {
        NotEnoughCompatibleWorkersMessage(int n, int n2, int n3) {
            super((BaseMsgID)new job.NotEnoughCompatibleWorkers(Integer.toString(n), Integer.toString(n2), Integer.toString(n3)));
        }
    }

    private static final class TaskOfParallelJobAbortedAbnormallyMessage
    extends SimpleCancelMessage {
        TaskOfParallelJobAbortedAbnormallyMessage(long l, String string) {
            super((BaseMsgID)new mjs.TaskOfParallelJobAbortedAbnormally(Long.toString(l), string));
        }
    }
}

