/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pml;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.resources.parallel.job;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcher;
import com.mathworks.toolbox.distcomp.jobmanager.TaskDispatcherForParallelJobs;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.pml.CannotAddTasksToFinishedJobException;
import com.mathworks.toolbox.distcomp.pml.PackageInfo;
import com.mathworks.toolbox.distcomp.pml.ParallelJobSetupInfo;
import com.mathworks.toolbox.distcomp.pml.SimultaneousTasksJob;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.distcomp.util.TimeProvider;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.JobStateException;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.messages.SimpleCancelMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import net.jini.id.Uuid;

public abstract class SimultaneousTasksJobImpl
extends JobImpl
implements SimultaneousTasksJob {
    private int fNumLabs = 0;
    private Uuid fLeadingTaskUuid;
    private long fLeadingTaskNum = -1L;
    private String fParallelTag = "";

    public SimultaneousTasksJobImpl(int n, String string) {
        super(n, string);
    }

    public SimultaneousTasksJobImpl(int n, String string, TimeProvider timeProvider) {
        super(n, string, timeProvider);
    }

    protected abstract MJSException oneTaskOnlyException();

    @Override
    public final boolean isLeadingTask(final Uuid uuid) {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Boolean>(){

            @Override
            public Boolean invoke() {
                if (uuid != null) {
                    return uuid.equals((Object)SimultaneousTasksJobImpl.this.getLeadingTaskUuid());
                }
                return Boolean.FALSE;
            }
        });
    }

    @Override
    public long getLeadingTaskNum() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Long>(){

            @Override
            public Long invoke() {
                return SimultaneousTasksJobImpl.this.fLeadingTaskNum;
            }
        });
    }

    @Override
    public final int getNumLabs() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<Integer>(){

            @Override
            public Integer invoke() {
                return SimultaneousTasksJobImpl.this.getNumLabsWithoutLocking();
            }
        });
    }

    @Override
    public final void setNumLabs(final int n) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                SimultaneousTasksJobImpl.this.fNumLabs = n;
                return null;
            }
        });
    }

    @Override
    public final Uuid createTask(final TaskInfo taskInfo) throws MJSException {
        return this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Uuid>(){

            @Override
            public Uuid invoke() throws MJSException {
                if (SimultaneousTasksJobImpl.this.fState == 2) {
                    throw new CannotAddTaskToRunningParallelJobException(SimultaneousTasksJobImpl.this.getNum());
                }
                int n = SimultaneousTasksJobImpl.this.getJobStorage().countTasksByJobID(SimultaneousTasksJobImpl.this.getID());
                if (n != 0) {
                    throw SimultaneousTasksJobImpl.this.oneTaskOnlyException();
                }
                Pair pair = SimultaneousTasksJobImpl.this.createTaskAndSetInfo(taskInfo);
                SimultaneousTasksJobImpl.this.fLeadingTaskUuid = (Uuid)pair.getFirst();
                SimultaneousTasksJobImpl.this.fLeadingTaskNum = (Long)pair.getSecond();
                return SimultaneousTasksJobImpl.this.getLeadingTaskUuid();
            }
        });
    }

    @Override
    public ParallelJobSetupInfo getParallelJobSetupInfo() {
        return this.invokeWithReadLock(new WorkUnitImpl.LockedInvocationNoException<ParallelJobSetupInfo>(){

            @Override
            public ParallelJobSetupInfo invoke() {
                if (SimultaneousTasksJobImpl.this.getNumLabsWithoutLocking() >= 1 && !SimultaneousTasksJobImpl.this.fParallelTag.isEmpty()) {
                    return new ParallelJobSetupInfo(SimultaneousTasksJobImpl.this.fParallelTag, SimultaneousTasksJobImpl.this.getNumLabsWithoutLocking());
                }
                return null;
            }
        });
    }

    @Override
    public void setParallelTag(final String string) {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoException<Void>(){

            @Override
            public Void invoke() {
                SimultaneousTasksJobImpl.this.fParallelTag = string;
                return null;
            }
        });
    }

    @Override
    public void createCopiesOfTask(final int n) throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocation<Void>(){

            @Override
            public Void invoke() throws MJSException {
                if (SimultaneousTasksJobImpl.this.fState == 3) {
                    throw new CannotAddTasksToFinishedJobException(SimultaneousTasksJobImpl.this.getNum());
                }
                TaskImpl taskImpl = SimultaneousTasksJobImpl.this.getFirstTask();
                for (int i = 0; i < n; ++i) {
                    TaskImpl taskImpl2 = SimultaneousTasksJobImpl.this.createCopyOfTask(taskImpl);
                    SimultaneousTasksJobImpl.this.getJobStorage().putTask(taskImpl2);
                    taskImpl2 = (TaskImpl)SimultaneousTasksJobImpl.this.getJobStorage().readWorkUnit(taskImpl2.getID());
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "task " + taskImpl2.getNum() + " of " + SimultaneousTasksJobImpl.this.workUnitTypeForPrinting() + " " + SimultaneousTasksJobImpl.this.fNum + " has been created");
                }
                return null;
            }
        });
        this.notifyJobRunnerOfNewTask();
    }

    protected TaskImpl createCopyOfTask(TaskImpl taskImpl) throws StorageException {
        return taskImpl.deepCopy(this.getID(), this.nextTaskSequenceNumber(), this.getWorkUnitUserName());
    }

    @Override
    public final void destroyPendingTasks() throws MJSException {
        this.invokeWithWriteLock(new WorkUnitImpl.LockedInvocationNoStorageUpdate<Void>(){

            @Override
            public Void invoke() throws MJSException {
                Uuid[] uuidArray;
                Uuid[][] uuidArray2 = SimultaneousTasksJobImpl.this.getJobStorage().readTasksByJobIDAndState(SimultaneousTasksJobImpl.this.getID(), new int[]{0});
                for (Uuid uuid : uuidArray = uuidArray2[0]) {
                    try {
                        TaskImpl taskImpl = (TaskImpl)SimultaneousTasksJobImpl.this.getJobStorage().readWorkUnit(uuid);
                        boolean bl = true;
                        taskImpl.destroyWithoutNotifyingJob(bl);
                    }
                    catch (WorkUnitNotFoundException workUnitNotFoundException) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Override
    public TaskDispatcher getTaskDispatcherToUse() {
        return TaskDispatcherForParallelJobs.instance();
    }

    @Override
    protected final void checkNumTasksBeforeRunning() throws MJSException {
        int n = this.getJobStorage().countTasksByJobIDAndState(this.getID(), 0);
        if (n != 1) {
            this.cancelJobBeforeRunning(new NumTasksNotOneMessage(this.workUnitTypeForPrinting(), n));
        }
    }

    @Override
    public final int getMinimumTasksToDispatch() {
        return this.getMinWorkers();
    }

    protected final TaskImpl getFirstTask() throws MJSException {
        assert (this.haveWriteLock()) : "Caller does not have the write lock.";
        int n = this.getJobStorage().countTasksByJobID(this.getID());
        if (n != 1) {
            throw this.oneTaskOnlyException();
        }
        try {
            return (TaskImpl)this.getJobStorage().readWorkUnit(this.getLeadingTaskUuid());
        }
        catch (WorkUnitNotFoundException workUnitNotFoundException) {
            throw this.oneTaskOnlyException();
        }
    }

    protected int getNumLabsWithoutLocking() {
        return this.fNumLabs;
    }

    protected Uuid getLeadingTaskUuid() {
        return this.fLeadingTaskUuid;
    }

    private static class NumTasksNotOneMessage
    extends SimpleCancelMessage {
        NumTasksNotOneMessage(String string, int n) {
            super((BaseMsgID)new mjs.NumTasksNotOne(string, Integer.toString(n)));
        }
    }

    private static final class CannotAddTaskToRunningParallelJobException
    extends JobStateException {
        private final BaseMsgID fMessageID;

        private CannotAddTaskToRunningParallelJobException(long l) {
            this.fMessageID = new job.CannotAddTaskToRunningParallelJob(Long.toString(l));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }
}

