/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.nativedmatlab.ProcessManipulation;
import com.mathworks.toolbox.distcomp.pmode.DebugUtils;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SyncBoolean;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;

class LabFinishSessionWithMonitoring
implements Runnable {
    private SyncBoolean fHasOrderlyShutdownCompleted = new SyncBoolean(false);
    private Thread fWatchdog = new Thread(this);

    public static LabFinishSessionWithMonitoring create() {
        LabFinishSessionWithMonitoring labFinishSessionWithMonitoring = new LabFinishSessionWithMonitoring();
        labFinishSessionWithMonitoring.init();
        return labFinishSessionWithMonitoring;
    }

    private LabFinishSessionWithMonitoring() {
        this.fWatchdog.setDaemon(true);
    }

    private void init() {
        this.fWatchdog.start();
    }

    private void onStopWorkerCompleted(int n, Object object) {
        if (Matlab.getExecutionStatus((int)n) == 0) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Stopping the worker was successful.");
            this.fHasOrderlyShutdownCompleted.setValueGetOldValue(true);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Stopping the worker was not successful.  It finished with execution status " + Matlab.getExecutionStatus((int)n) + ".");
        }
        this.fWatchdog.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DebugUtils.interruptMatlabClearDebugState();
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Stopping the worker by running the command parallel.internal.pool.stopInteractiveWorker;");
        MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
        matlabMCR.eval("parallel.internal.pool.stopInteractiveWorker;", new CompletionObserver(){

            public void completed(int n, Object object) {
                LabFinishSessionWithMonitoring.this.onStopWorkerCompleted(n, object);
            }
        });
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Finishing the session with command: dctFinishInteractiveSession;");
        matlabMCR.eval("dctFinishInteractiveSession;", new CompletionObserver(){

            public void completed(int n, Object object) {
                PackageInfo.LOGGER.log(DistcompLevel.THREE, "Finished dctFinishInteractiveSession; with status: " + Matlab.getExecutionStatus((int)n) + " and results: " + object);
            }
        });
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "ShutdownMonitor waiting for 120000 milliseconds.");
        try {
            Thread.sleep(120000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.fHasOrderlyShutdownCompleted.getValue()) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Shutdown timeout has expired.  Killing the lab.");
        try {
            ProcessManipulation processManipulation = new ProcessManipulation();
            processManipulation.sendSIGTERM();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            processManipulation.sendSIGKILL();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            System.exit(1);
        }
    }
}

