/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.distcomp.pmode.DebugUtils;
import com.mathworks.toolbox.distcomp.pmode.MEvalCommand;
import com.mathworks.toolbox.distcomp.pmode.MExecutorImpl;
import com.mathworks.toolbox.distcomp.pmode.MInteractiveInterrupt;
import com.mathworks.toolbox.distcomp.pmode.MInterruptResult;
import com.mathworks.toolbox.distcomp.pmode.MResultsHandler;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class LabMExecutorImpl
extends MExecutorImpl {
    private MatlabMCR fMCR = MatlabRefStore.getMatlabRef();
    private MResultsHandler fResultsHandler;
    private boolean fCommandCleanupInProgress;
    private List<MInteractiveInterrupt> fPendingInterrupts;
    private boolean fIsAlive;
    private ReturnGroup fOutputGroup;

    public LabMExecutorImpl(ReturnGroup returnGroup) {
        this.fResultsHandler = new MResultsHandler(returnGroup);
        this.fCommandCleanupInProgress = false;
        this.fPendingInterrupts = Collections.synchronizedList(new LinkedList());
        this.fIsAlive = true;
        this.fOutputGroup = returnGroup;
    }

    @Override
    public synchronized void eval(MEvalCommand mEvalCommand) {
        assert (this.fIsAlive) : "Received a command to evaluate after destroy.";
        assert (mEvalCommand != null && mEvalCommand.fCommand != null) : "Command and command string must not be null.";
        assert (!this.fCommandCleanupInProgress) : "Cannot evaluate MATLAB code while deadlock detection is in progress.";
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Evaluating command " + mEvalCommand.getSequenceNumber());
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Command " + mEvalCommand.getSequenceNumber() + " is '" + mEvalCommand.fCommand + "'");
        final long l = mEvalCommand.getSequenceNumber();
        this.fResultsHandler.commandAboutToStart(l, mEvalCommand.getSourceProcess());
        this.fMCR.evalStreamOutput(mEvalCommand.fCommand, new CompletionObserver(){

            public void completed(int n, Object object) {
                LabMExecutorImpl.this.onCommandCompleted(l, n, object);
            }
        });
    }

    @Override
    public synchronized void interrupt(MInteractiveInterrupt mInteractiveInterrupt) {
        assert (this.fIsAlive) : "Received an interrupt request after destroy.";
        this.fPendingInterrupts.add(mInteractiveInterrupt);
        if (this.fCommandCleanupInProgress) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Delaying interrupt " + mInteractiveInterrupt.getSequenceNumber() + " due to deadlock detection.");
        } else {
            this.executePendingInterrupts();
        }
    }

    @Override
    public synchronized void destroy() {
        assert (this.fIsAlive) : "Destroy method called more than once.";
        this.fIsAlive = false;
    }

    private synchronized void onCommandCompleted(final long l, final int n, Object object) {
        if (!NativeMatlab.nativeIsMatlabThread()) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "onCommandCompleted invoked outside MATLAB main thread.");
            assert (false) : "onCommandCompleted must run on the MATLAB main thread.";
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Command " + l + " finished.");
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Execution status " + Matlab.getExecutionStatus((int)n));
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Code block status " + Matlab.getCodeBlockStatus((int)n));
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "fCommandCleanupInProgress: " + this.fCommandCleanupInProgress);
        assert (!this.fCommandCleanupInProgress) : "Command completed while deadlock detection was in progress.";
        if (!this.fIsAlive) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Not performing command cleanup due to object destruction.");
            return;
        }
        this.fResultsHandler.commandCompleted(l, (String)object);
        if (Matlab.getCodeBlockStatus((int)n) == 0) {
            this.fCommandCleanupInProgress = true;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Running command cleanup for command " + l + ".");
            this.fMCR.fevalConsoleOutput("parallel.internal.pool.interPPromptFcn", new Object[0], 0, new CompletionObserver(){

                public void completed(int n2, Object object) {
                    LabMExecutorImpl.this.onDeadlockDetectionCompleted(l, n, n2, object);
                }
            });
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Not performing command cleanup.");
            this.fResultsHandler.deadlockDetectionCompleted(l, n, null);
        }
    }

    private synchronized void onDeadlockDetectionCompleted(long l, int n, int n2, Object object) {
        assert (this.fCommandCleanupInProgress) : "Deadlock detection completed while deadlock detection status was set to false.";
        if (!NativeMatlab.nativeIsMatlabThread()) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "onDeadlockDetectionCompleted invoked outside MATLAB main thread.");
            assert (false) : "onDeadlockDetectionCompleted must run on the MATLAB main thread.";
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Command cleanup for sequence number " + l + " finished with execution status " + Matlab.getExecutionStatus((int)n2) + " prompt status " + Matlab.getInputRequester((int)n2) + ", and code block status " + Matlab.getCodeBlockStatus((int)n2) + ".");
        this.fCommandCleanupInProgress = false;
        if (!this.fIsAlive) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Not sending command cleanup results due to object destruction.");
            return;
        }
        this.fResultsHandler.deadlockDetectionCompleted(l, n, (String)object);
        if (this.fPendingInterrupts.size() > 0) {
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "A total of " + this.fPendingInterrupts.size() + " interrupts left to process.  " + "Only issuing one.");
            this.executePendingInterrupts();
        }
    }

    private synchronized void executePendingInterrupts() {
        assert (!this.fCommandCleanupInProgress) : "Must not interrupt the deadlock detection.";
        if (this.fPendingInterrupts.size() == 0) {
            return;
        }
        final MInteractiveInterrupt[] mInteractiveInterruptArray = this.fPendingInterrupts.toArray(new MInteractiveInterrupt[0]);
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                for (int i = 0; i < mInteractiveInterruptArray.length; ++i) {
                    MInteractiveInterrupt mInteractiveInterrupt = mInteractiveInterruptArray[i];
                    MInterruptResult mInterruptResult = new MInterruptResult(n, mInteractiveInterrupt.getSequenceNumber());
                    LabMExecutorImpl.this.fOutputGroup.returnTo(mInteractiveInterrupt.getSourceProcess(), (ReturnMessage)mInterruptResult);
                }
            }
        };
        DebugUtils.interruptMatlabClearDebugState(completionObserver);
        this.fPendingInterrupts.clear();
    }
}

