/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.NativeMatlab;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;

class MatlabOutputWriters {
    private static final int STDOUT = 1;
    private static final int STDERR = 2;
    private BufferedWriter fOutBuf;
    private BufferedWriter fErrBuf;
    private StringWriter fOutWriter;
    private StringWriter fErrWriter;
    private List<MatlabOutputListener> fListenerList = new Vector<MatlabOutputListener>();
    private static MatlabOutputWriters sInstance = null;

    private MatlabOutputWriters() {
        this.fOutWriter = new InnerWriter(1);
        this.fErrWriter = new InnerWriter(2);
        this.fOutBuf = new BufferedWriter(this.fOutWriter, 100000);
        this.fErrBuf = new BufferedWriter(this.fErrWriter, 100000);
    }

    public void flushAllPendingOutput() throws IOException {
        this.fOutBuf.flush();
        this.fErrBuf.flush();
    }

    public void flushAllPendingOutputNoException() {
        block2: {
            try {
                this.flushAllPendingOutput();
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"An exception occurred during output flushing");
            }
        }
    }

    public void addOutputListener(MatlabOutputListener matlabOutputListener) {
        this.fListenerList.add(matlabOutputListener);
    }

    public void removeOutputListener(MatlabOutputListener matlabOutputListener) {
        assert (this.fListenerList.contains(matlabOutputListener)) : "attempt to remove a listener that wasn't already present";
        this.fListenerList.remove(matlabOutputListener);
    }

    public void setup() {
        NativeMatlab.nativeLabCmdWinSetup((Writer)this.fOutBuf, (Writer)this.fErrBuf);
        this.fListenerList.clear();
    }

    public void teardown() {
        NativeMatlab.nativeLabCmdWinRemove();
        this.fListenerList.clear();
    }

    public static MatlabOutputWriters getInstance() {
        if (sInstance == null) {
            sInstance = new MatlabOutputWriters();
        }
        return sInstance;
    }

    static void returnCommandOutput(String string, ReturnGroup returnGroup, long l, Instance instance) {
        String[] stringArray;
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = StringUtils.splitStringOnNewLine(string, 100000)) {
            String[] stringArray2 = StringUtils.splitStringOnNewLine(string2, 4000);
            CmdWinOutput cmdWinOutput = new CmdWinOutput(stringArray2, l);
            returnGroup.returnTo(instance, (ReturnMessage)cmdWinOutput);
        }
    }

    private class InnerWriter
    extends StringWriter {
        private final int fStreamId;

        private InnerWriter(int n) {
            this.fStreamId = n;
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            super.write(cArray, n, n2);
            this.flush();
        }

        @Override
        public void flush() {
            if (this.getBuffer().length() > 0) {
                for (MatlabOutputListener matlabOutputListener : MatlabOutputWriters.this.fListenerList) {
                    switch (this.fStreamId) {
                        case 1: {
                            matlabOutputListener.stdout(this.getBuffer().toString());
                            break;
                        }
                        case 2: {
                            matlabOutputListener.stderr(this.getBuffer().toString());
                        }
                    }
                }
                this.getBuffer().setLength(0);
            }
        }
    }

    public static interface MatlabOutputListener {
        public void stdout(String var1);

        public void stderr(String var1);
    }
}

