/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureFevalResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MvmExecutionException;
import com.mathworks.toolbox.distcomp.pmode.BufferTransferCommand;
import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.DependencyExistsException;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.UUID;

public final class NewDirectoryDependencyCommand
extends BufferTransferCommand {
    private static final String ADD_COMMAND = "distcomp.pAddDependenciesFromZipfile";
    private transient File fClientDir;
    private final String fClientDirStr;
    private final String fRemoteName;

    public NewDirectoryDependencyCommand(ByteBufferHandle byteBufferHandle, File file, String string) {
        super(byteBufferHandle);
        assert (file.isDirectory()) : "Must be constructed with a directory.";
        this.fClientDir = file;
        this.fClientDirStr = file.getPath();
        this.fRemoteName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(ReturnGroup returnGroup, Instance instance, SessionService sessionService) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispatch of NewDirectoryDependencyCommand for fClientDir: " + this.fClientDir + " with fRemoteName: " + this.fRemoteName + ".");
        DependencyCommandResult dependencyCommandResult = new DependencyCommandResult(this.getSequenceNumber());
        try {
            this.addDependenciesFromZipFile(sessionService.getFileDependenciesAssistant());
        }
        catch (MvmExecutionException mvmExecutionException) {
            Object object = mvmExecutionException.getMvmCause() != null ? mvmExecutionException.getMvmCause() : mvmExecutionException.getCause();
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "MVM error caught during dispatch.", (Throwable)object);
            dependencyCommandResult.setException((Throwable)object);
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during dispatch.", throwable);
            dependencyCommandResult.setException(throwable);
        }
        finally {
            if (this.fBuffer != null) {
                this.fBuffer.free();
            }
            returnGroup.returnTo(this.getSourceProcess(), (ReturnMessage)dependencyCommandResult);
        }
    }

    private void addDependenciesFromZipFile(FileDependenciesAssistant fileDependenciesAssistant) throws IOException, InterruptedException, MvmExecutionException {
        assert (this.fBuffer != null) : "Input ByteBuffer was null";
        if (fileDependenciesAssistant.dependencyExists(this.fClientDir)) {
            throw new DependencyExistsException(this.fClientDir.getPath() + " is already added as a FileDependency.");
        }
        File file = File.createTempFile(UUID.randomUUID().toString(), ".zip");
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: zipFile ( " + file + ") created.");
        this.writeBufferToFile(file);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: buffer written to " + file + ".");
        MVM mVM = MatlabRefStore.getMVMRef();
        MatlabFevalRequest matlabFevalRequest = new MatlabFevalRequest(ADD_COMMAND, Integer.valueOf(0), new Object[]{file.getPath(), this.fClientDir.getPath(), this.fRemoteName, fileDependenciesAssistant.getDependencyDir().getPath()});
        FutureFevalResult futureFevalResult = mVM.getExecutor().submit(matlabFevalRequest);
        futureFevalResult.get();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: finished feval into MATLAB for " + file + ".");
        boolean bl = file.delete();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "NewDirectoryDependencyCommand: " + file + " deleted, result: " + bl);
        File file2 = new File(fileDependenciesAssistant.getDependencyDir(), FileUtils.convertToLocalSeparators(this.fRemoteName));
        if (!fileDependenciesAssistant.addDependency(this.fClientDir, file2)) {
            throw new DependencyExistsException(this.fClientDir.getPath() + " : unexpectedly failed to add as a FileDependency");
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.fClientDir = new File(this.fClientDirStr);
        return this;
    }
}

