/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.AbstractErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class NonFatalErrorHandler
extends AbstractErrorHandler {
    private static final int SHUTDOWN_SIZE_THRESHOLD = 0;
    private final Set<Instance> fConnectedInstances = Collections.synchronizedSet(new HashSet());
    private final Set<Instance> fTreatAsFatalInstances;

    public NonFatalErrorHandler(boolean bl, SessionRoleMapping sessionRoleMapping, List<Instance> list, List<Instance> list2) {
        super(bl, sessionRoleMapping);
        this.fConnectedInstances.addAll(list);
        this.fTreatAsFatalInstances = Collections.unmodifiableSet(new HashSet<Instance>(list2));
    }

    private void shutDownIfWorkersLost(Instance instance, AbstractErrorHandler.FatalError fatalError) {
        boolean bl = this.fConnectedInstances.remove(instance);
        boolean bl2 = bl && this.fConnectedInstances.size() <= 0 || this.fTreatAsFatalInstances.contains(instance);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "NonFatalErrorHandler: got error with ID " + fatalError.getMessageID() + " from " + instance);
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "NonFatalErrorHandler: will invoke shutdown? " + bl2);
        if (bl2) {
            this.maybeShutDown(fatalError);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "A worker was lost: " + fatalError.getLocalizedMessage());
        }
    }

    @Override
    public void readError(Instance instance, Throwable throwable) {
        this.shutDownIfWorkersLost(instance, this.buildReadError(instance, throwable));
    }

    @Override
    public void writeError(Instance instance, Throwable throwable) {
        this.shutDownIfWorkersLost(instance, this.buildWriteError(instance, throwable));
    }

    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        this.communicationLost(instance, throwable);
    }

    @Override
    public void executorError(Throwable throwable) {
        this.maybeShutDown(this.buildExecutorError(throwable));
    }

    @Override
    public void communicationError(Error error) {
        this.maybeShutDown(this.buildExecutorError(error));
    }

    @Override
    public void communicationLost(Instance instance, Throwable throwable) {
        this.shutDownIfWorkersLost(instance, this.buildLostCommunicationError(instance, throwable));
    }

    @Override
    public void communicationEstablished(Instance instance) {
        boolean bl = this.fConnectedInstances.add(instance);
    }
}

