/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.toolbox.distcomp.pmode.DebugUtils;
import com.mathworks.toolbox.distcomp.pmode.FevalLargeDataResult;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SendingWriterManager;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlock;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlockResult;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutor;
import com.mathworks.toolbox.distcomp.pmode.SpmdExecutorCommand;
import com.mathworks.toolbox.distcomp.pmode.SpmdInterrupt;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.FutureWaiter;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpmdExecutorImpl
implements SpmdExecutor {
    private FutureWaiter fFutureWaiter;
    private CommunicationGroup fCommGroup;
    private MVM fMVM;
    private FutureResult fBlockFuture = null;
    private AtomicBoolean fIsAlive;
    private Semaphore fInterruptProgress;
    private BlockProperties fBlockProperties;
    private SendingWriterManager fWriter;
    private ExecutorState fState;

    public SpmdExecutorImpl(CommunicationGroup communicationGroup, FutureWaiter futureWaiter) {
        this.fCommGroup = communicationGroup;
        this.fMVM = MatlabRefStore.getMVMRef();
        this.fIsAlive = new AtomicBoolean(true);
        this.fInterruptProgress = new Semaphore(0);
        this.fBlockProperties = null;
        this.fState = ExecutorState.IDLE;
        this.fFutureWaiter = futureWaiter;
        this.fWriter = new SendingWriterManager(communicationGroup);
    }

    @Override
    public void dispatch(SpmdExecutorCommand spmdExecutorCommand, Instance instance) {
        if (spmdExecutorCommand instanceof SpmdBlock) {
            this.execute((SpmdBlock)spmdExecutorCommand);
        } else if (spmdExecutorCommand instanceof SpmdInterrupt) {
            this.interrupt((SpmdInterrupt)spmdExecutorCommand);
        }
    }

    private synchronized ExecutorState moveToState(ExecutorState executorState) {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "SPMD Starting move to state: " + (Object)((Object)executorState) + " from " + (Object)((Object)this.fState));
        ExecutorState executorState2 = this.fState;
        this.fState = executorState;
        return executorState2;
    }

    private synchronized BlockProperties moveToPrelude(SpmdBlock spmdBlock) {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_PRELUDE);
        assert (executorState == ExecutorState.IDLE) : "Bad IDLE->PRELUDE state progression";
        this.fBlockProperties = new BlockProperties(spmdBlock);
        return this.fBlockProperties;
    }

    private synchronized boolean moveToBody(BlockProperties blockProperties) {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_BODY);
        assert (executorState == ExecutorState.EXECUTING_PRELUDE) : "Bad PRELUDE->BODY state progression";
        assert (this.fBlockFuture == null) : "fBlockFuture should be null";
        return blockProperties.isInterruptReceived();
    }

    private synchronized boolean moveToWaiting(BlockProperties blockProperties) {
        ExecutorState executorState = this.moveToState(ExecutorState.WAITING_FOR_INTERRUPT_COMPLETION);
        assert (executorState == ExecutorState.EXECUTING_BODY) : "Bad BODY->WAITING_FOR_INTERRUPT state progression";
        this.fBlockFuture = null;
        return blockProperties.isInterruptReceived();
    }

    private synchronized void moveToCleanup() {
        ExecutorState executorState = this.moveToState(ExecutorState.EXECUTING_CLEANUP);
        assert (executorState == ExecutorState.WAITING_FOR_INTERRUPT_COMPLETION) : "Bad BODY->CLEANUP state progression";
    }

    private synchronized void moveToIdle() {
        ExecutorState executorState = this.moveToState(ExecutorState.IDLE);
        assert (executorState == ExecutorState.EXECUTING_CLEANUP) : "Bad CLEANUP->IDLE state progression";
        this.fBlockProperties = null;
    }

    @Override
    public void execute(SpmdBlock spmdBlock) {
        assert (this.fIsAlive.get()) : "Received block to execute after destroy()";
        assert (this.fInterruptProgress.availablePermits() == 0) : "Invalid number of interrupt permits";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor executing: " + spmdBlock.getSequenceNumber());
        BlockProperties blockProperties = this.moveToPrelude(spmdBlock);
        this.triggerPrelude(spmdBlock, blockProperties);
    }

    private void triggerPrelude(final SpmdBlock spmdBlock, final BlockProperties blockProperties) {
        FutureWaiter.OnFutureCompletion onFutureCompletion = new FutureWaiter.OnFutureCompletion(){

            @Override
            public void run(Object object, Exception exception) {
                SpmdExecutorImpl.this.triggerBody(blockProperties);
            }

            public String toString() {
                return "[SpmdExecutorImpl/triggerPrelude/OnFutureCompletion for SPMD block: " + spmdBlock + "]";
            }
        };
        this.fWriter.enable(spmdBlock.getSequenceNumber(), spmdBlock.getSourceProcess());
        this.fFutureWaiter.waitAndTrigger((FutureResult)this.fMVM.getExecutor().submit(new MatlabFevalRequest("spmdlang.remoteBlockExecution", Integer.valueOf(2), this.fWriter.getSendingWriter(), this.fWriter.getSendingWriter(), blockProperties.getBlock().getPreludeArgs("prelude"))), onFutureCompletion);
    }

    private void bodyCompleted(final BlockProperties blockProperties, Exception exception, Object object) {
        boolean bl = this.moveToWaiting(blockProperties);
        SpmdBlockResult spmdBlockResult = SpmdExecutorImpl.buildBlockResult(blockProperties.getSequenceNumber(), exception, object, bl);
        if (spmdBlockResult.isError()) {
            this.fCommGroup.returnTo(blockProperties.getBlock().getSourceProcess(), (ReturnMessage)spmdBlockResult);
            this.fWriter.disable();
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD skipping return of SpmdBlockResult - nothing interesting - interrupted? " + bl);
        }
        if (bl) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD waiting for interrupt completion...");
                    try {
                        SpmdExecutorImpl.this.fInterruptProgress.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD interrupted while waiting", interruptedException);
                    }
                    SpmdExecutorImpl.this.triggerCleanup(blockProperties);
                }
            });
            thread.setDaemon(true);
            thread.start();
        } else {
            this.triggerCleanup(blockProperties);
        }
    }

    private synchronized void triggerBody(final BlockProperties blockProperties) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD in triggerBody");
        boolean bl = this.moveToBody(blockProperties);
        if (bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD already interrupted, skipping body");
            this.fWriter.disable();
            this.moveToWaiting(blockProperties);
            this.triggerCleanup(blockProperties);
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD about to invoke BODY");
            this.fBlockFuture = this.fMVM.getExecutor().submit(new MatlabFevalRequest("spmdlang.remoteBlockExecution", Integer.valueOf(2), this.fWriter.getSendingWriter(), this.fWriter.getSendingWriter(), new Object[]{"interruptibleExecution"}));
            this.fFutureWaiter.waitAndTrigger(this.fBlockFuture, new FutureWaiter.OnFutureCompletion(){

                @Override
                public void run(Object object, Exception exception) {
                    SpmdExecutorImpl.this.bodyCompleted(blockProperties, exception, object);
                }

                public String toString() {
                    return "[SpmdExecutorImpl/triggerBody/OnFutureCompletion for SPMD block: " + blockProperties.getBlock() + "]";
                }
            });
        }
    }

    private static SpmdBlockResult buildBlockResult(long l, Exception exception, Object object, boolean bl) {
        if (bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD Block was interrupted - building 'no error' result");
            return SpmdBlockResult.NO_ERROR_RESULT;
        }
        if (exception != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD Block execution caught exception.");
            return new SpmdBlockResult(l, true, null);
        }
        try {
            Object[] objectArray = (Object[])object;
            boolean[] blArray = (boolean[])objectArray[0];
            boolean bl2 = !blArray[0];
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD build block result - Got error? " + bl2);
            return new SpmdBlockResult(l, bl2, objectArray[1]);
        }
        catch (Exception exception2) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "An error occurred extracting error info", exception2);
            return new SpmdBlockResult(l, true, null);
        }
    }

    private void triggerCleanup(final BlockProperties blockProperties) {
        assert (this.fIsAlive.get()) : "Attempt to cleanup after destroy()";
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup: " + blockProperties.getSequenceNumber());
        this.moveToCleanup();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup, state changed");
        FutureWaiter.OnFutureCompletion onFutureCompletion = new FutureWaiter.OnFutureCompletion(){

            @Override
            public void run(Object object, Exception exception) {
                SpmdExecutorImpl.this.fWriter.disable();
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup completed with exception: " + exception);
                FevalLargeDataResult fevalLargeDataResult = new FevalLargeDataResult(exception, object, 2, blockProperties.getSequenceNumber());
                SpmdExecutorImpl.this.moveToIdle();
                SpmdExecutorImpl.this.fCommGroup.returnTo(blockProperties.getBlock().getSourceProcess(), (ReturnMessage)fevalLargeDataResult);
            }

            public String toString() {
                return "[SpmdExecutorImpl/triggerCleanup/OnFutureCompletion for block " + blockProperties.getBlock() + "]";
            }
        };
        this.fFutureWaiter.waitAndTrigger((FutureResult)this.fMVM.getExecutor().submit(new MatlabFevalRequest("spmdlang.remoteBlockExecution", Integer.valueOf(2), this.fWriter.getSendingWriter(), this.fWriter.getSendingWriter(), new Object[]{"postlude"})), onFutureCompletion);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor cleanup, feval sent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(final SpmdInterrupt spmdInterrupt) {
        assert (this.fIsAlive.get()) : "Received interrupt after destroy()";
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.fBlockProperties != null) {
                this.fBlockProperties.setInterruptReceived(true);
            }
            switch (this.fState) {
                case IDLE: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor ignoring received interrupt after block completion");
                    break;
                }
                case EXECUTING_PRELUDE: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor received interrupt during prelude, no action taken, block should be skipped");
                    break;
                }
                case EXECUTING_BODY: {
                    assert (this.fBlockProperties != null) : "Should have valid fBlockProperties";
                    assert (this.fBlockProperties.getSequenceNumber() == spmdInterrupt.getBlockSequence()) : "Wrong interrupt sequence: received " + spmdInterrupt.getBlockSequence() + " while executing " + this.fBlockProperties.getSequenceNumber();
                    assert (this.fBlockFuture != null) : "Should have fBlockFuture";
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor received interrupt during block, will interrupt");
                    bl = true;
                    break;
                }
                case WAITING_FOR_INTERRUPT_COMPLETION: 
                case EXECUTING_CLEANUP: {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor ignoring received during cleanup");
                }
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD executor received interrupt during block, will interrupt: " + bl);
        if (bl) {
            object = new CompletionObserver(){

                public void completed(int n, Object object) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "SpmdInterrupt successfully completed, returning to: " + spmdInterrupt.getSourceProcess());
                    SpmdExecutorImpl.this.fInterruptProgress.release();
                }
            };
            SpmdExecutorImpl spmdExecutorImpl = this;
            synchronized (spmdExecutorImpl) {
                if (this.fBlockFuture == null) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD fBlockFuture already null so no need to interrupt.");
                    this.fInterruptProgress.release();
                } else {
                    this.fWriter.disable();
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD: About to cancel fBlockFuture");
                    boolean bl2 = this.fBlockFuture.cancel(true);
                    boolean bl3 = this.fBlockFuture.isDone();
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD: fBlockFuture cancelled, result: " + bl2 + ", isDone: " + bl3);
                    DebugUtils.clearDebugStateUseMwmpi((CompletionObserver)object);
                }
            }
        }
    }

    @Override
    public void destroy() {
        boolean bl = this.fIsAlive.getAndSet(false);
        assert (bl) : "2nd call to destroy";
    }

    private static final class BlockProperties {
        private final SpmdBlock fSpmdBlock;
        private boolean fInterruptReceived;

        private BlockProperties(SpmdBlock spmdBlock) {
            this.fSpmdBlock = spmdBlock;
            this.fInterruptReceived = false;
        }

        public SpmdBlock getBlock() {
            return this.fSpmdBlock;
        }

        public synchronized boolean isInterruptReceived() {
            return this.fInterruptReceived;
        }

        public synchronized boolean setInterruptReceived(boolean bl) {
            boolean bl2 = this.fInterruptReceived;
            this.fInterruptReceived = bl;
            return bl2;
        }

        public long getSequenceNumber() {
            return this.fSpmdBlock.getSequenceNumber();
        }
    }

    private static enum ExecutorState {
        IDLE,
        EXECUTING_PRELUDE,
        EXECUTING_BODY,
        WAITING_FOR_INTERRUPT_COMPLETION,
        EXECUTING_CLEANUP;

    }
}

