/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.Log;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.util.ArrayList;
import java.util.List;

public class RoleCommunicationGroup
implements RoleReturnGroup,
RoleOutputGroup,
CommunicationObserver {
    private final CommunicationGroup fCommGroup;
    private final SessionRoleMapping fMapping;

    @Override
    public void communicationLost(Instance instance, Throwable throwable) {
    }

    @Override
    public void communicationEstablished(Instance instance) {
        this.registerConnection(instance);
    }

    public void registerConnection(Instance instance) {
        if (instance instanceof MatlabPoolPeerInstance) {
            MatlabPoolPeerInstance matlabPoolPeerInstance = (MatlabPoolPeerInstance)instance;
            int n = matlabPoolPeerInstance.getLabIndex();
            ProcessInstance processInstance = n == -1 ? ProcessInstance.getClientInstance() : ProcessInstance.getLabInstance(n);
            Log.LOGGER.info("RoleCommunicationGroup.registerConnection Mapping from " + processInstance + " to " + instance);
            this.fMapping.registerProcess(processInstance, instance);
        } else {
            Log.LOGGER.info("RoleCommunicationGroup.registerConnection Ignoring non-pool instance " + instance);
        }
    }

    public RoleCommunicationGroup(CommunicationGroup communicationGroup, SessionRoleMapping sessionRoleMapping) {
        this.fCommGroup = communicationGroup;
        this.fMapping = sessionRoleMapping;
    }

    private MessageObserver wrap(RoleMessageObserver roleMessageObserver) {
        return new WrappingObserver(roleMessageObserver);
    }

    @Override
    public void sendTo(List<ProcessInstance> list, Message message) throws NoSuchDestinationException {
        this.fCommGroup.sendTo(this.fMapping.roleToInstance(list), message);
    }

    @Override
    public void sendTo(List<ProcessInstance> list, ObservableMessage observableMessage, RoleMessageObserver roleMessageObserver) throws NoSuchDestinationException {
        this.fCommGroup.sendTo(this.fMapping.roleToInstance(list), observableMessage, this.wrap(roleMessageObserver));
    }

    @Override
    public void sendTo(ProcessInstance processInstance, ObservableMessage observableMessage, RoleMessageObserver roleMessageObserver) throws NoSuchDestinationException {
        this.fCommGroup.sendTo(this.fMapping.roleToInstance(processInstance), observableMessage, this.wrap(roleMessageObserver));
    }

    @Override
    public void sendTo(ProcessInstance processInstance, Message message) throws NoSuchDestinationException {
        this.fCommGroup.sendTo(this.fMapping.roleToInstance(processInstance), message);
    }

    @Override
    public List<ProcessInstance> getConnectedProcessInstances() {
        return new ArrayList<ProcessInstance>(this.fMapping.instanceToRole(this.fCommGroup.getConnectedInstances()));
    }

    @Override
    public void returnTo(List<ProcessInstance> list, ReturnMessage returnMessage) throws NoSuchDestinationException {
        this.fCommGroup.returnTo(this.fMapping.roleToInstance(list), returnMessage);
    }

    @Override
    public void returnTo(ProcessInstance processInstance, ReturnMessage returnMessage) throws NoSuchDestinationException {
        this.fCommGroup.returnTo(this.fMapping.roleToInstance(processInstance), returnMessage);
    }

    private final class WrappingObserver
    implements MessageObserver {
        private final RoleMessageObserver fUnderlyingObserver;

        private WrappingObserver(RoleMessageObserver roleMessageObserver) {
            this.fUnderlyingObserver = roleMessageObserver;
        }

        @Override
        public void completed(ReturnMessage returnMessage, Instance instance) {
            this.fUnderlyingObserver.completed(returnMessage, RoleCommunicationGroup.this.fMapping.instanceToRole(instance));
        }

        @Override
        public void aborted(long l, Instance instance) {
            this.fUnderlyingObserver.aborted(l, RoleCommunicationGroup.this.fMapping.instanceToRole(instance));
        }

        @Override
        public void expectReturnsFrom(long l, List<Instance> list) {
            this.fUnderlyingObserver.expectReturnsFrom(l, new ArrayList<ProcessInstance>(RoleCommunicationGroup.this.fMapping.instanceToRole(list)));
        }
    }
}

