/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nullable;

public final class ObservableMessageFuture<V extends FinalReturnMessage>
implements Future<V>,
MessageObserver {
    private final CountDownLatch fCountDownLatch = new CountDownLatch(1);
    private final Class<V> fFinalReturnMessageClass;
    private V fFinalReturnMessage = null;
    private ExecutionException fExecutionException = null;

    public ObservableMessageFuture(Class<V> clazz) {
        this.fFinalReturnMessageClass = clazz;
    }

    @Override
    public boolean cancel(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.fCountDownLatch.await();
        return this.getFinalReturnMessage();
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.fCountDownLatch.await(l, timeUnit)) {
            return this.getFinalReturnMessage();
        }
        throw new TimeoutException("Timed out after " + l + " " + (Object)((Object)timeUnit));
    }

    private V getFinalReturnMessage() throws ExecutionException {
        if (this.fExecutionException != null) {
            throw this.fExecutionException;
        }
        return this.fFinalReturnMessage;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.fCountDownLatch.getCount() == 0L;
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        if (returnMessage instanceof FinalReturnMessage) {
            try {
                this.fFinalReturnMessage = (FinalReturnMessage)this.fFinalReturnMessageClass.cast(returnMessage);
            }
            catch (ClassCastException classCastException) {
                this.fExecutionException = new ExecutionException(classCastException);
            }
            this.fCountDownLatch.countDown();
        }
    }

    @Override
    public void aborted(long l, @Nullable Instance instance) {
        this.fFinalReturnMessage = null;
        this.fExecutionException = new ExecutionException(new IOException("Lost connection to " + instance));
        this.fCountDownLatch.countDown();
    }

    @Override
    public void expectReturnsFrom(long l, List<Instance> list) {
        if (list.isEmpty()) {
            this.aborted(l, null);
        } else assert (list.size() == 1);
    }
}

