/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.JoinInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.UUID;

public final class ServerSocketConnectInfo
implements ConnectInfo {
    private final Class<? extends CommunicationGroup> fCommunicationGroupClass;
    private InetSocketAddress fSocketAddress;
    private final UUID fGroupUuid;
    private final ConnectorSecurityDescription fSecurityDescription;
    private final long fJoinTimeLimit;
    private final long fDeadline;
    private final int fConnectAttempts;

    private ServerSocketConnectInfo(Class<? extends CommunicationGroup> clazz, InetSocketAddress inetSocketAddress, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l, long l2, int n) {
        this.fCommunicationGroupClass = clazz;
        this.fSocketAddress = inetSocketAddress;
        this.fGroupUuid = uUID;
        this.fSecurityDescription = connectorSecurityDescription;
        this.fJoinTimeLimit = l;
        this.fDeadline = l2;
        this.fConnectAttempts = n;
    }

    @Override
    public UUID getGroupUUID() {
        return this.fGroupUuid;
    }

    @Override
    public Class<? extends CommunicationGroup> getGroupImplementation() {
        return this.fCommunicationGroupClass;
    }

    @Override
    public boolean hasExpired() {
        return JoinInfo.DeadlineHelper.hasExpired(this);
    }

    @Override
    public long getRemainingTime() {
        return JoinInfo.DeadlineHelper.getRemainingTime(this);
    }

    @Override
    public ConnectorSecurityDescription getConnectorSecurityDescription() {
        return this.fSecurityDescription;
    }

    public InetSocketAddress getSocketAddress() {
        return this.fSocketAddress;
    }

    public ServerSocketConnectInfo createMangledConnectionInfo(InetAddress inetAddress) {
        return new ServerSocketConnectInfo(this.fCommunicationGroupClass, new InetSocketAddress(inetAddress, this.fSocketAddress.getPort()), this.fGroupUuid, this.fSecurityDescription, this.fJoinTimeLimit, this.fDeadline, this.fConnectAttempts);
    }

    public ServerSocketConnectInfo createCopyReplaceSecurityDescription(ConnectorSecurityDescription connectorSecurityDescription) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(this.fCommunicationGroupClass, this.fSocketAddress, this.fGroupUuid, connectorSecurityDescription, this.fJoinTimeLimit, this.fDeadline, this.fConnectAttempts);
    }

    public ServerSocketConnectInfo createCopyReplaceGroupImplementation(Class<? extends CommunicationGroup> clazz) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(clazz, this.fSocketAddress, this.fGroupUuid, this.fSecurityDescription, this.fJoinTimeLimit, this.fDeadline, this.fConnectAttempts);
    }

    @Override
    public ServerSocketConnectInfo createCopyReplaceDeadline(long l) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(this.fCommunicationGroupClass, this.fSocketAddress, this.fGroupUuid, this.fSecurityDescription, this.fJoinTimeLimit, l, this.fConnectAttempts);
    }

    public ServerSocketConnectInfo createCopyReplaceSocket(InetSocketAddress inetSocketAddress) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(this.fCommunicationGroupClass, inetSocketAddress, this.fGroupUuid, this.fSecurityDescription, this.fJoinTimeLimit, this.fDeadline, this.fConnectAttempts);
    }

    @Override
    public long getDeadline() {
        return this.fDeadline;
    }

    @Override
    public long getHandShakeDeadline() {
        return JoinInfo.DeadlineHelper.getReasonableHandShakeDeadline(this);
    }

    @Override
    public long getJoinTimeLimit() {
        return this.fJoinTimeLimit;
    }

    @Override
    public ServerSocketConnectInfo createCopyWithReasonableDeadline() {
        return (ServerSocketConnectInfo)JoinInfo.DeadlineHelper.createCopyWithReasonableDeadline(this);
    }

    @Override
    public int getNumberOfAttempts() {
        return this.fConnectAttempts;
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName() + " at " + this.fSocketAddress + " for group " + this.fGroupUuid;
    }

    @Override
    public boolean peersConnectingAsGroupShareBarrier() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ServerSocketConnectInfo serverSocketConnectInfo = (ServerSocketConnectInfo)object;
        if (this.fConnectAttempts != serverSocketConnectInfo.fConnectAttempts) {
            return false;
        }
        if (this.fDeadline != serverSocketConnectInfo.fDeadline) {
            return false;
        }
        if (this.fJoinTimeLimit != serverSocketConnectInfo.fJoinTimeLimit) {
            return false;
        }
        if (this.fGroupUuid != null ? !this.fGroupUuid.equals(serverSocketConnectInfo.fGroupUuid) : serverSocketConnectInfo.fGroupUuid != null) {
            return false;
        }
        if (this.fSecurityDescription != null ? !this.fSecurityDescription.equals(serverSocketConnectInfo.fSecurityDescription) : serverSocketConnectInfo.fSecurityDescription != null) {
            return false;
        }
        return !(this.fSocketAddress != null ? !this.fSocketAddress.equals(serverSocketConnectInfo.fSocketAddress) : serverSocketConnectInfo.fSocketAddress != null);
    }

    public int hashCode() {
        int n = this.fSocketAddress != null ? this.fSocketAddress.hashCode() : 0;
        n = 31 * n + (this.fGroupUuid != null ? this.fGroupUuid.hashCode() : 0);
        n = 31 * n + (this.fSecurityDescription != null ? this.fSecurityDescription.hashCode() : 0);
        n = 31 * n + (int)(this.fJoinTimeLimit ^ this.fJoinTimeLimit >>> 32);
        n = 31 * n + (int)(this.fDeadline ^ this.fDeadline >>> 32);
        n = 31 * n + this.fConnectAttempts;
        return n;
    }

    public String toString() {
        return "ServerSocketConnectInfo{fSocketAddress=" + this.fSocketAddress + ", fGroupUuid=" + this.fGroupUuid + ", fSecurityDescription=" + this.fSecurityDescription + ", fJoinTimeLimit=" + this.fJoinTimeLimit + ", fDeadline=" + this.fDeadline + ", fConnectAttempts=" + this.fConnectAttempts + '}';
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fSocketAddress = new InetSocketAddress(this.fSocketAddress.getHostName(), this.fSocketAddress.getPort());
    }

    public static ServerSocketConnectInfo createServerSocketConnectInfo(Class<? extends CommunicationGroup> clazz, InetSocketAddress inetSocketAddress, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l, long l2, int n) {
        return new ServerSocketConnectInfo(clazz, inetSocketAddress, uUID, connectorSecurityDescription, l, l2, n);
    }

    public static ServerSocketConnectInfo createServerSocketConnectInfo(Class<? extends CommunicationGroup> clazz, String string, int n, UUID uUID, ConnectorSecurityDescription connectorSecurityDescription, long l, long l2, int n2) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(clazz, new InetSocketAddress(string, n), uUID, connectorSecurityDescription, l, l2, n2);
    }

    public static ServerSocketConnectInfo createServerSocketConnectInfo(ServerSocketAcceptInfo serverSocketAcceptInfo, String string, int n) {
        return ServerSocketConnectInfo.createServerSocketConnectInfo(serverSocketAcceptInfo.getGroupImplementation(), string, n, serverSocketAcceptInfo.getGroupUUID(), serverSocketAcceptInfo.getAcceptorSecurityDescription().createConnectorSecurityDescription(), serverSocketAcceptInfo.getJoinTimeLimit(), serverSocketAcceptInfo.getDeadline(), serverSocketAcceptInfo.getNumberOfAttempts());
    }
}

