/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.transfer;

import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.transfer.DataSender;
import com.mathworks.toolbox.distcomp.pmode.transfer.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferACKOfDataReceived;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferCommand;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferDataItem;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferHeader;
import com.mathworks.toolbox.distcomp.pmode.transfer.TransferPayload;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.concurrent.atomic.AtomicLong;

class DataSenderImpl
extends DataSender {
    private RoleOutputGroup fOutGroup;
    private long fTransferSeqNumber;
    private long fNumBlocks;
    private AtomicLong fLastSentBlock;
    private AtomicLong fACKBlockCount;
    private ProcessInstance fDestID;

    public DataSenderImpl(RoleOutputGroup roleOutputGroup) {
        this.fOutGroup = roleOutputGroup;
        this.fLastSentBlock = new AtomicLong();
        this.fACKBlockCount = new AtomicLong();
        this.reset();
    }

    @Override
    public void sendNextBlock(byte[] byArray) {
        assert (this.isTransferInProgress()) : "sendNextBlock called when there was no transfer in progress.";
        assert (byArray != null && byArray.length > 0) : "Data must be non-null and non-empty.";
        long l = this.fLastSentBlock.incrementAndGet();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Sending block " + (this.fLastSentBlock.get() + 1L) + " out of " + this.fNumBlocks + ".");
        TransferPayload transferPayload = new TransferPayload(this.fTransferSeqNumber, byArray, l);
        this.fOutGroup.sendTo(this.fDestID, (Message)transferPayload);
    }

    @Override
    public boolean isReadyForNextBlock() {
        long l = this.fACKBlockCount.get();
        long l2 = this.fLastSentBlock.get();
        return this.isTransferInProgress() && l2 < l + 10L;
    }

    @Override
    public void setHeader(long l, long l2) {
        assert (this.isTransferInProgress()) : "setTransferHeader called when there was no transfer in progress.";
        this.fNumBlocks = l2;
        this.fOutGroup.sendTo(this.fDestID, (Message)new TransferHeader(this.fTransferSeqNumber, l, l2));
    }

    @Override
    public void dispatch(TransferDataItem transferDataItem, ProcessInstance processInstance) {
        assert (this.fDestID.equals(processInstance)) : "Received a TransferDataItem from source " + processInstance + ". Expected source to be " + this.fDestID + ".";
        assert (this.isTransferInProgress()) : "Received data of type " + transferDataItem.getClass().getName() + "when transfer was not in progress.";
        this.assertSeqNumber(transferDataItem.getTransferSeqNumber());
        if (transferDataItem instanceof TransferACKOfDataReceived) {
            TransferACKOfDataReceived transferACKOfDataReceived = (TransferACKOfDataReceived)transferDataItem;
            this.assertSeqNumber(transferACKOfDataReceived.getTransferSeqNumber());
            this.markReceived(transferACKOfDataReceived.fBlockNumber);
        } else {
            String string = DataSenderImpl.sMsgUnexpectedTransferCommand(transferDataItem);
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
            assert (false) : string;
        }
    }

    @Override
    public void prepareForTransfer(long l, ProcessInstance processInstance) {
        this.reset();
        this.fTransferSeqNumber = l;
        this.fDestID = processInstance;
    }

    private boolean isTransferInProgress() {
        return this.fTransferSeqNumber >= 0L;
    }

    private void markReceived(long l) {
        assert (l >= 0L && l < this.fNumBlocks) : "Invalid block number " + l + ". Expected a value between 0 and " + (this.fNumBlocks - 1L) + ", inclusive.";
        long l2 = this.fACKBlockCount.incrementAndGet();
        assert (l == l2) : "Receiving out-of-order ACK for data transfer.";
        if (l2 == this.fNumBlocks - 1L) {
            this.reset();
        }
    }

    private void reset() {
        this.fTransferSeqNumber = -1L;
        this.fLastSentBlock.set(-1L);
        this.fDestID = null;
        this.fNumBlocks = -1L;
        this.fACKBlockCount.set(-1L);
    }

    private void assertSeqNumber(long l) {
        assert (this.fTransferSeqNumber == l) : "Invalid Transfer sequence number. Was " + l + ". Expected " + this.fTransferSeqNumber + ".";
    }

    private static String sMsgUnexpectedTransferCommand(TransferCommand transferCommand) {
        return "Received unexpected transfer object of type " + transferCommand.getClass().getName() + " with transfer sequence number " + transferCommand.getTransferSeqNumber() + ".";
    }
}

