/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterNotAllowedException;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.RequiredParameterMissingException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ParameterMap
implements Serializable {
    private Map<Parameter<?>, Object> fMap;

    public ParameterMap() {
        this.fMap = new HashMap();
    }

    private ParameterMap(Map<Parameter<?>, Object> map) {
        this.fMap = new HashMap(map);
    }

    public ParameterMap createCopy() {
        return new ParameterMap(this.fMap);
    }

    public ParameterMap createCopyRetaining(ParameterSet parameterSet) {
        ParameterMap parameterMap = new ParameterMap(this.fMap);
        HashSet hashSet = new HashSet(parameterMap.keySet());
        for (Parameter parameter : hashSet) {
            if (parameterSet.getParameters().contains(parameter)) continue;
            parameterMap.remove(parameter);
        }
        return parameterMap;
    }

    public void checkParameters(ParameterSet parameterSet) throws ParameterNotAllowedException, RequiredParameterMissingException, InvalidValueException {
        HashSet hashSet = new HashSet(this.keySet());
        hashSet.removeAll(parameterSet.getParameters());
        if (!hashSet.isEmpty()) {
            throw new ParameterNotAllowedException(hashSet);
        }
        HashSet hashSet2 = new HashSet();
        for (Parameter<?> parameter : parameterSet.getParameters()) {
            if (!parameter.isRequired() || this.fMap.containsKey(parameter)) continue;
            hashSet2.add(parameter);
        }
        if (!hashSet2.isEmpty()) {
            throw new RequiredParameterMissingException(hashSet2);
        }
        for (Parameter<?> parameter : this.fMap.keySet()) {
            parameter.checkValue(this.fMap.get(parameter));
        }
    }

    public boolean containsKey(Parameter<?> parameter) {
        return this.fMap.containsKey(parameter);
    }

    public <V> V get(Parameter<V> parameter) {
        Object object = this.fMap.get(parameter);
        return parameter.getValueClass().cast(object);
    }

    public <V> V getOrSuggest(Parameter<V> parameter) {
        V v = this.fMap.containsKey(parameter) ? this.fMap.get(parameter) : parameter.getSuggestedValue();
        return parameter.getValueClass().cast(v);
    }

    public int size() {
        return this.fMap.size();
    }

    private Set<Parameter<?>> keySet() {
        return this.fMap.keySet();
    }

    public <V> void put(Parameter<V> parameter, V v) {
        parameter.getValueClass().cast(v);
        this.fMap.put(parameter, v);
    }

    public void putAll(ParameterMap parameterMap) {
        this.fMap.putAll(parameterMap.fMap);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Parameter<?>, Object> entry : this.fMap.entrySet()) {
            Parameter<?> parameter = entry.getKey();
            Object object = entry.getValue();
            String string = parameter.getValueClass().getSimpleName();
            String string2 = "<" + string + ">";
            stringBuilder.append(String.format("%-20s = ", parameter.getIdentifier()));
            stringBuilder.append(String.format("%-10s ", string2));
            stringBuilder.append(String.format("%-20s\n", object));
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    public <V> V remove(Parameter<V> parameter) {
        Object object = this.fMap.remove(parameter);
        return parameter.getValueClass().cast(object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ParameterMap parameterMap = (ParameterMap)object;
        return this.fMap.equals(parameterMap.fMap);
    }

    public int hashCode() {
        return this.fMap.hashCode();
    }
}

